/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    PhysicalConnection connection;
    OracleStatement statement;
    int m_beginColumnIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleResultSetMetaData() {
    }

    public OracleResultSetMetaData(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = 0;
    }

    OracleResultSetMetaData(PhysicalConnection physicalConnection, OracleStatement oracleStatement, int n2) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = n2;
    }

    public OracleResultSetMetaData(OracleResultSet oracleResultSet) throws SQLException {
        this.statement = (OracleStatement)((OracleStatementWrapper)oracleResultSet.getStatement()).statement;
        this.connection = (PhysicalConnection)this.statement.getConnection();
        this.statement.describe();
        this.m_beginColumnIndex = oracleResultSet.getFirstUserColumnIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.statement.getNumberOfColumns() - this.m_beginColumnIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getValidColumnIndex(int n2) throws SQLException {
        try {
            int n3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((n3 = n2 + this.m_beginColumnIndex - 1) < 0 || n3 >= this.statement.getNumberOfColumns()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSetMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "getValidColumnIndex");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = n3;
            return n4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        try {
            int n3;
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = (n3 = this.getColumnType(n2)) == 1 || n3 == 12 || n3 == -1 || n3 == -15 || n3 == -9;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSearchable(int n2) throws SQLException {
        try {
            int n3;
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = (n3 = this.getColumnType(n2)) != -4 && n3 != -1 && n3 != 2004 && n3 != 2005 && n3 != -13 && n3 != 2011 && n3 != 2002 && n3 != 2008 && n3 != 2007 && n3 != 2003 && n3 != 2006 && n3 != -10;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrency(int n2) throws SQLException {
        try {
            int n3;
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = (n3 = this.getColumnType(n2)) == 2 || n3 == 6;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isNullable(int n2) throws SQLException {
        try {
            int n3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = this.getValidColumnIndex(n2);
            int n5 = n3 = this.getDescription()[n4].nullable ? 1 : 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n6 = n3;
            return n6;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSigned(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.getValidColumnIndex(n2);
            int n4 = this.getDescription()[n3].describeType;
            switch (n4) {
                case 2: {
                    int n5;
                    int n6 = this.getPrecision(n2);
                    int n7 = this.getDescription()[n3].scale;
                    if (n6 != 0 && n7 == -127) {
                        n6 = (int)((double)n6 / 3.32193);
                        n7 = 1;
                    } else {
                        if (n6 == 0) {
                            n6 = 38;
                        }
                        if (n7 == -127) {
                            n7 = 0;
                        }
                    }
                    int n8 = n5 = n6 + (n7 != 0 ? 1 : 0) + 1;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n8);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n9 = n8;
                    return n9;
                }
            }
            int n10 = this.getDescription()[n3].describeMaxLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n10);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n11 = n10;
            return n11;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnLabel(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.getColumnName(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.getValidColumnIndex(n2);
            String string = this.statement.getDescriptionWithNames()[n3].columnName;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrecision(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.getValidColumnIndex(n2);
            int n4 = this.getDescription()[n3].describeType;
            switch (n4) {
                case 112: 
                case 113: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n5 = -1;
                    return n5;
                }
                case 8: 
                case 24: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + Integer.MAX_VALUE);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n6 = Integer.MAX_VALUE;
                    return n6;
                }
                case 1: 
                case 96: {
                    int n7 = this.getDescription()[n3].describeMaxLength;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n7);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n8 = n7;
                    return n8;
                }
            }
            int n9 = this.getDescription()[n3].precision;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n9);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n10 = n9;
            return n10;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.getValidColumnIndex(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.getDescription()[n3].securityAttribute));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleResultSetMetaData.SecurityAttribute securityAttribute = this.getDescription()[n3].securityAttribute;
            return securityAttribute;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScale(int n2) throws SQLException {
        try {
            int n3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = this.getValidColumnIndex(n2);
            int n5 = this.getDescription()[n4].scale;
            int n6 = n3 = n5 == -127 && this.statement.connection.j2ee13Compliant ? 0 : n5;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n7 = n3;
            return n7;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogName(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int getColumnType(int var1_1) throws SQLException {
        try {
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(var1_1));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var2_3 = this.getValidColumnIndex(var1_1);
            var3_4 = this.getDescription()[var2_3].describeType;
            switch (var3_4) {
                case 96: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl26
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -15);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_6 = -15;
                    return var4_6;
lbl26:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_7 = 1;
                    return var4_7;
                }
                case 1: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl48
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -9);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_8 = -9;
                    return var4_8;
lbl48:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 12);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_9 = 12;
                    return var4_9;
                }
                case 8: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_10 = -1;
                    return var4_10;
                }
                case 2: 
                case 6: {
                    if (!this.statement.connection.j2ee13Compliant || this.getDescription()[var2_3].precision == 0 || this.getDescription()[var2_3].scale != -127) ** GOTO lbl81
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 6);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_11 = 6;
                    return var4_11;
lbl81:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_12 = 2;
                    return var4_12;
                }
                case 100: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 100);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_13 = 100;
                    return var4_13;
                }
                case 101: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 101);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_14 = 101;
                    return var4_14;
                }
                case 23: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -3);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_15 = -3;
                    return var4_15;
                }
                case 24: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -4);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_16 = -4;
                    return var4_16;
                }
                case 104: 
                case 208: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -8);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_17 = -8;
                    return var4_17;
                }
                case 102: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -10);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_18 = -10;
                    return var4_18;
                }
                case 12: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.connection.mapDateToTimestamp != false ? 93 : 91));
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_19 = this.connection.mapDateToTimestamp != false ? 93 : 91;
                    return var4_19;
                }
                case 180: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 93);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_20 = 93;
                    return var4_20;
                }
                case 181: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -101);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_21 = -101;
                    return var4_21;
                }
                case 231: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -102);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_22 = -102;
                    return var4_22;
                }
                case 113: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2004);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_23 = 2004;
                    return var4_23;
                }
                case 112: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl224
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2011);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_24 = 2011;
                    return var4_24;
lbl224:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2005);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_25 = 2005;
                    return var4_25;
                }
                case 114: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -13);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_26 = -13;
                    return var4_26;
                }
                case 109: {
                    var4_27 = (OracleNamedType)this.getDescription()[var2_3].describeOtype;
                    var5_33 = TypeDescriptor.getTypeDescriptor(var4_27.getFullName(), this.connection);
                    if (var5_33 == null) ** GOTO lbl260
                    var6_35 = var5_33.getTypeCode();
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + var6_35);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var7_38 = var6_35;
                    return var7_38;
lbl260:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var6_36 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60);
                    var6_36.fillInStackTrace();
                    throw var6_36;
                }
                case 111: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2006);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_28 = 2006;
                    return var4_28;
                }
                case 182: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -103);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_29 = -103;
                    return var4_29;
                }
                case 183: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -104);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_30 = -104;
                    return var4_30;
                }
            }
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1111);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_31 = 1111;
            return var4_31;
        }
        finally {
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public String getColumnTypeName(int var1_1) throws SQLException {
        try {
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(var1_1));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var2_3 = this.getValidColumnIndex(var1_1);
            var3_4 = this.getDescription()[var2_3].describeType;
            switch (var3_4) {
                case 96: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl26
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NCHAR");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_6 = "NCHAR";
                    return var4_6;
lbl26:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "CHAR");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_7 = "CHAR";
                    return var4_7;
                }
                case 1: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl48
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NVARCHAR2");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_8 = "NVARCHAR2";
                    return var4_8;
lbl48:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "VARCHAR2");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_9 = "VARCHAR2";
                    return var4_9;
                }
                case 8: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "LONG");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_10 = "LONG";
                    return var4_10;
                }
                case 2: 
                case 6: {
                    if (!this.statement.connection.j2ee13Compliant || this.getDescription()[var2_3].precision == 0 || this.getDescription()[var2_3].scale != -127) ** GOTO lbl81
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "FLOAT");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_11 = "FLOAT";
                    return var4_11;
lbl81:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NUMBER");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_12 = "NUMBER";
                    return var4_12;
                }
                case 100: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BINARY_FLOAT");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_13 = "BINARY_FLOAT";
                    return var4_13;
                }
                case 101: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BINARY_DOUBLE");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_14 = "BINARY_DOUBLE";
                    return var4_14;
                }
                case 23: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "RAW");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_15 = "RAW";
                    return var4_15;
                }
                case 24: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "LONG RAW");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_16 = "LONG RAW";
                    return var4_16;
                }
                case 104: 
                case 208: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "ROWID");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_17 = "ROWID";
                    return var4_17;
                }
                case 102: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "REFCURSOR");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_18 = "REFCURSOR";
                    return var4_18;
                }
                case 12: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "DATE");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_19 = "DATE";
                    return var4_19;
                }
                case 180: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_20 = "TIMESTAMP";
                    return var4_20;
                }
                case 181: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP WITH TIME ZONE");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_21 = "TIMESTAMP WITH TIME ZONE";
                    return var4_21;
                }
                case 231: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP WITH LOCAL TIME ZONE");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_22 = "TIMESTAMP WITH LOCAL TIME ZONE";
                    return var4_22;
                }
                case 113: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BLOB");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_23 = "BLOB";
                    return var4_23;
                }
                case 112: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl224
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NCLOB");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_24 = "NCLOB";
                    return var4_24;
lbl224:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "CLOB");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_25 = "CLOB";
                    return var4_25;
                }
                case 114: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BFILE");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_26 = "BFILE";
                    return var4_26;
                }
                case 109: {
                    var4_27 = (OracleTypeADT)this.getDescription()[var2_3].describeOtype;
                    var5_33 = var4_27.getFullName();
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + var5_33);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var6_36 = var5_33;
                    return var6_36;
                }
                case 111: {
                    var4_28 = (OracleTypeADT)this.getDescription()[var2_3].describeOtype;
                    var5_34 = var4_28.getFullName();
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + var5_34);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var6_37 = var5_34;
                    return var6_37;
                }
                case 182: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "INTERVALYM");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_29 = "INTERVALYM";
                    return var4_29;
                }
                case 183: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "INTERVALDS");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_30 = "INTERVALDS";
                    return var4_30;
                }
            }
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_31 = null;
            return var4_31;
        }
        finally {
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public String getColumnClassName(int var1_1) throws SQLException {
        try {
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(var1_1));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var2_3 = this.getValidColumnIndex(var1_1);
            var3_4 = this.getDescription()[var2_3].describeType;
            switch (var3_4) {
                case 1: 
                case 8: 
                case 96: 
                case 999: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.lang.String");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_6 = "java.lang.String";
                    return var4_6;
                }
                case 2: 
                case 6: {
                    if (this.getDescription()[var2_3].precision == 0 || this.getDescription()[var2_3].scale != -127) ** GOTO lbl37
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.lang.Double");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_7 = "java.lang.Double";
                    return var4_7;
lbl37:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.math.BigDecimal");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_8 = "java.math.BigDecimal";
                    return var4_8;
                }
                case 23: 
                case 24: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "byte[]");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_9 = "byte[]";
                    return var4_9;
                }
                case 12: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.sql.Timestamp");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_10 = "java.sql.Timestamp";
                    return var4_10;
                }
                case 180: {
                    if (!this.statement.connection.j2ee13Compliant) ** GOTO lbl81
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.sql.Timestamp");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_11 = "java.sql.Timestamp";
                    return var4_11;
lbl81:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.TIMESTAMP");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_12 = "oracle.sql.TIMESTAMP";
                    return var4_12;
                }
                case 181: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.TIMESTAMPTZ");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_13 = "oracle.sql.TIMESTAMPTZ";
                    return var4_13;
                }
                case 231: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.TIMESTAMPLTZ");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_14 = "oracle.sql.TIMESTAMPLTZ";
                    return var4_14;
                }
                case 182: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.INTERVALYM");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_15 = "oracle.sql.INTERVALYM";
                    return var4_15;
                }
                case 183: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.INTERVALDS");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_16 = "oracle.sql.INTERVALDS";
                    return var4_16;
                }
                case 104: 
                case 208: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.ROWID");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_17 = "oracle.sql.ROWID";
                    return var4_17;
                }
                case 113: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleBlob.class.getName());
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_18 = OracleBlob.class.getName();
                    return var4_18;
                }
                case 112: {
                    if (this.getDescription()[var2_3].formOfUse != 2) ** GOTO lbl169
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleNClob.class.getName());
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_19 = OracleNClob.class.getName();
                    return var4_19;
lbl169:
                    // 1 sources

                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleClob.class.getName());
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_20 = OracleClob.class.getName();
                    return var4_20;
                }
                case 114: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleBfile.class.getName());
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_21 = OracleBfile.class.getName();
                    return var4_21;
                }
                case 102: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "OracleResultSet");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_22 = "OracleResultSet";
                    return var4_22;
                }
                case 109: {
                    switch (this.getColumnType(var1_1)) {
                        case 2003: {
                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleArray.class.getName());
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var4_23 = OracleArray.class.getName();
                            return var4_23;
                        }
                        case 2007: {
                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleOpaque.class.getName());
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var4_24 = OracleOpaque.class.getName();
                            return var4_24;
                        }
                        case 2008: {
                            var4_25 = (OracleNamedType)this.getDescription()[var2_3].describeOtype;
                            var5_34 = this.connection.getJavaObjectTypeMap();
                            if (var5_34 == null || (var6_37 = (Class)var5_34.get(var4_25.getFullName())) == null) ** GOTO lbl240
                            var7_40 = var6_37.getName();
                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + var7_40);
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var8_44 = var7_40;
                            return var8_44;
lbl240:
                            // 1 sources

                            var6_37 = StructDescriptor.getJavaObjectClassName(this.connection, var4_25.getSchemaName(), var4_25.getSimpleName());
                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)var6_37);
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var7_41 = var6_37;
                            return var7_41;
                        }
                        case 2002: {
                            var4_26 = this.connection.getTypeMap();
                            if (var4_26 == null || (var5_35 = (Class)var4_26.get(((OracleNamedType)this.getDescription()[var2_3].describeOtype).getFullName())) == null) ** GOTO lbl265
                            var6_38 = var5_35.getName();
                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + var6_38);
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var7_42 = var6_38;
                            return var7_42;
lbl265:
                            // 1 sources

                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleStruct.class.getName());
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var5_35 = OracleStruct.class.getName();
                            return var5_35;
                        }
                        case 2009: {
                            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.sql.SQLXML");
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var4_27 = "java.sql.SQLXML";
                            return var4_27;
                        }
                    }
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleResultSetMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_28 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                    var4_28.fillInStackTrace();
                    throw var4_28;
                }
                case 111: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleRef.class.getName());
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_29 = OracleRef.class.getName();
                    return var4_29;
                }
                case 101: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.BINARY_DOUBLE");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_30 = "oracle.sql.BINARY_DOUBLE";
                    return var4_30;
                }
                case 100: {
                    if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.BINARY_FLOAT");
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_31 = "oracle.sql.BINARY_FLOAT";
                    return var4_31;
                }
            }
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_32 = null;
            return var4_32;
        }
        finally {
            if (OracleResultSetMetaData.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCHAR(int n2) throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.getValidColumnIndex(n2);
            boolean bl2 = bl = this.getDescription()[n3].formOfUse == 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    Accessor[] getDescription() throws SQLException {
        return this.statement.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (clazz.isInterface()) {
                boolean bl = clazz.isInstance(this);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (clazz.isInterface() && clazz.isInstance(this)) {
                OracleResultSetMetaData oracleResultSetMetaData = this;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleResultSetMetaData);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleResultSetMetaData oracleResultSetMetaData2 = oracleResultSetMetaData;
                return (T)oracleResultSetMetaData2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSetMetaData.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleResultSetMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

