/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.sql.ARRAY;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements OracleStruct {
    StructDescriptor descriptor;
    Datum[] datumArray;
    Object[] objectArray;
    boolean enableLocalCache = false;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(structDescriptor) + ", " + OracleLog.argument(connection) + ", " + OracleLog.argument(objectArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT.assertNotNull(structDescriptor);
            this.descriptor = structDescriptor;
            STRUCT.assertNotNull(connection);
            if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct STRUCT instance + " + "invalid connection");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            structDescriptor.setConnection(connection);
            if (!this.descriptor.isInstantiable()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct STRUCT instance for a " + "non-instantiable object type");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setPhysicalConnectionOf(connection);
            this.datumArray = objectArray != null ? this.descriptor.toArray(objectArray) : new Datum[this.descriptor.getLength()];
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT(StructDescriptor structDescriptor, Connection connection, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(structDescriptor) + ", " + OracleLog.argument(connection) + ", " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT.assertNotNull(structDescriptor);
            this.descriptor = structDescriptor;
            STRUCT.assertNotNull(connection);
            if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct STRUCT instance + " + "invalid connection");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            structDescriptor.setConnection(connection);
            if (!this.descriptor.isInstantiable()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct STRUCT instance for a " + "non-instantiable object type");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setPhysicalConnectionOf(connection);
            this.datumArray = this.descriptor.toOracleArray(map);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT(StructDescriptor structDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Cannot construct STRUCT instance + " + "invalid connection");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        structDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQLTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            String string;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string2 = this.descriptor.getName();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object[] objectArray2 = this.getAttributes(this.getMap());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object[] objectArray2 = this.descriptor.toArray(this, map, this.enableLocalCache);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = this.getDescriptor();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + structDescriptor);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor2 = structDescriptor;
            return structDescriptor2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor getDescriptor() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            StructDescriptor structDescriptor;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.descriptor);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                structDescriptor = this.descriptor;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return structDescriptor;
        }
    }

    public void setDescriptor(StructDescriptor structDescriptor) {
        this.descriptor = structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] getOracleAttributes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Datum[] datumArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum[] datumArray2 = this.descriptor.toOracleArray(this, this.enableLocalCache);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datumArray = datumArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datumArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Map map = null;
            try {
                map = this.getInternalConnection().getTypeMap();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + map);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Map map2 = map;
            return map2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toBytes(this, this.enableLocalCache);
        }
    }

    public void setDatumArray(Datum[] datumArray) {
        try {
            this.datumArray = datumArray == null ? new Datum[this.descriptor.getLength()] : datumArray;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjArray(Object[] objectArray) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.objectArray = objectArray == null ? new Object[]{} : objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static STRUCT toSTRUCT(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        STRUCT sTRUCT = null;
        if (object != null) {
            if (object instanceof STRUCT) {
                sTRUCT = (STRUCT)object;
            } else if (object instanceof ORAData) {
                sTRUCT = (STRUCT)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof OracleData) {
                Object object2 = ((OracleData)object).toJDBCObject(oracleConnection);
                sTRUCT = (STRUCT)object2;
            } else if (object instanceof CustomDatum) {
                sTRUCT = (STRUCT)((OracleConnection)oracleConnection).toDatum((CustomDatum)object);
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)oracleConnection);
                SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
                sQLData.writeSQL(sQLOutput);
                sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.SEVERE, "         Throwing SQLException: 59" + object);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJdbc() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Map map = this.getMap();
            Object object = this.toJdbc(map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJdbc(Map map) throws SQLException {
        try {
            Serializable serializable;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this;
            if (map != null && (serializable = this.descriptor.getClass(map)) != null) {
                object = this.toClass((Class)serializable, map);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            serializable = object;
            return serializable;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toClass(Class clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.toClass(clazz, this.getMap());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toClass(Class clazz, Map map) throws SQLException {
        try {
            STRUCT sTRUCT;
            Object object;
            block40: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz) + ", " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = null;
                try {
                    if (clazz == null || clazz == STRUCT.class || clazz == Struct.class) {
                        object = this;
                        break block40;
                    }
                    sTRUCT = clazz.newInstance();
                    if (sTRUCT instanceof SQLData) {
                        ((SQLData)((Object)sTRUCT)).readSQL(this.descriptor.toJdbc2SQLInput(this, map), this.descriptor.getName());
                        object = sTRUCT;
                        break block40;
                    }
                    if (sTRUCT instanceof ORADataFactory) {
                        ORADataFactory oRADataFactory = (ORADataFactory)((Object)sTRUCT);
                        object = oRADataFactory.create(this, 2002);
                        break block40;
                    }
                    if (sTRUCT instanceof OracleDataFactory) {
                        OracleDataFactory oracleDataFactory = (OracleDataFactory)((Object)sTRUCT);
                        object = oracleDataFactory.create(this, 2002);
                        break block40;
                    }
                    if (sTRUCT instanceof CustomDatumFactory) {
                        CustomDatumFactory customDatumFactory = (CustomDatumFactory)((Object)sTRUCT);
                        object = customDatumFactory.create(this, 2002);
                        break block40;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 49 + this.descriptor.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (InstantiationException instantiationException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 49 + "InstantiationException: " + instantiationException.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 49 + "IllegalAccessException: " + illegalAccessException.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sTRUCT = object;
            return sTRUCT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConvertibleTo(Class clazz) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBuffering(boolean bl) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.enableLocalCache = bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoBuffering() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.enableLocalCache);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = this.enableLocalCache;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }

    public long getImageLength() {
        return this.imageLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatumFactory getFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (CustomDatumFactory)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORADataFactory getORADataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (ORADataFactory)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleDataFactory getOracleDataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (OracleDataFactory)v;
    }

    public String debugString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        try {
            StructDescriptor structDescriptor = this.getDescriptor();
            stringWriter.write("name = " + structDescriptor.getName());
            int n2 = structDescriptor.getLength();
            stringWriter.write(" length = " + n2);
            Object[] objectArray = this.getAttributes();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringWriter.write(" attribute[" + i2 + "] = " + objectArray[i2]);
            }
            string = stringWriter.toString();
        }
        catch (SQLException sQLException) {
            string = "StructDescriptor missing or bad";
        }
        return string;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        return this.getDescriptor().isInHierarchyOf(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getJavaSqlConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = super.getJavaSqlConnection();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = STRUCT.dump(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    STRUCT.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static String dump(Object object) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        STRUCT.dump(object, printWriter);
        return stringWriter.getBuffer().substring(0);
    }

    public static void dump(Object object, PrintStream printStream) throws SQLException {
        STRUCT.dump(object, new PrintWriter(printStream, true));
    }

    public static void dump(Object object, PrintWriter printWriter) throws SQLException {
        STRUCT.dump(object, printWriter, 0);
    }

    static void dump(Object object, PrintWriter printWriter, int n2) throws SQLException {
        if (object instanceof STRUCT) {
            STRUCT.dump((STRUCT)object, printWriter, n2);
            return;
        }
        if (object instanceof ARRAY) {
            ARRAY.dump((ARRAY)object, printWriter, n2);
            return;
        }
        if (object == null) {
            printWriter.println("null");
        } else {
            printWriter.println(object.toString());
        }
    }

    static void dump(STRUCT sTRUCT, PrintWriter printWriter, int n2) throws SQLException {
        int n3;
        StructDescriptor structDescriptor = sTRUCT.getDescriptor();
        ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        printWriter.println("name = " + structDescriptor.getName());
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        int n4 = structDescriptor.getLength();
        printWriter.println("length = " + n4);
        Object[] objectArray = sTRUCT.getAttributes();
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                printWriter.print(' ');
            }
            printWriter.print(resultSetMetaData.getColumnName(n3 + 1) + " = ");
            STRUCT.dump(objectArray[n3], printWriter, n2 + 1);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.STRUCT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

