/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class SQLName
implements Serializable {
    static boolean DEBUG = false;
    static boolean s_parseAllFormat = false;
    static final long serialVersionUID = 2266340348729491526L;
    String name;
    String schema;
    String simple;
    int version;
    boolean synonym;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected SQLName() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLName(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(oracleConnection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(string, oracleConnection);
            this.version = 2;
            this.synonym = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLName(String string, String string2, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2) + ", " + OracleLog.argument(oracleConnection));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.schema = string;
            this.simple = string2;
            this.name = this.schema + "." + this.simple;
            this.version = 2;
            this.synonym = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void init(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        if (SQLName.parse(string, stringArray, stringArray2, true)) {
            this.schema = stringArray[0];
            this.simple = stringArray2[0];
        } else {
            this.schema = oracleConnection.physicalConnectionWithin().getDefaultSchemaNameForNamedTypes();
            this.simple = stringArray2[0];
        }
        this.name = this.schema + "." + this.simple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.name);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.name;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchema() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.schema);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.schema;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSimpleName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.simple);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.simple;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.version);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.version;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) throws SQLException {
        return SQLName.parse(string, stringArray, stringArray2, s_parseAllFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parse(String string, String[] stringArray, String[] stringArray2, boolean bl) throws SQLException {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < 1 || stringArray2 == null || stringArray2.length < 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.SEVERE, "         Throwing SQLException: 68");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!bl) {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n2);
            stringArray2[0] = string.substring(n2 + 1);
            return true;
        }
        int n3 = string.length();
        int n4 = string.indexOf("\"");
        int n5 = string.indexOf("\"", n4 + 1);
        int n6 = -1;
        if (n4 < 0) {
            n6 = string.indexOf(".");
            if (n6 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n6);
            stringArray2[0] = string.substring(n6 + 1);
            return true;
        }
        if (n4 == 0) {
            if (n5 == n3 - 1) {
                stringArray2[0] = string.substring(n4 + 1, n5);
                return false;
            }
            n6 = string.indexOf(".", n5);
            stringArray[0] = string.substring(n4 + 1, n5);
            n4 = string.indexOf("\"", n6);
            n5 = string.indexOf("\"", n4 + 1);
            if (n4 < 0) {
                stringArray2[0] = string.substring(n6 + 1);
                return true;
            }
            stringArray2[0] = string.substring(n4 + 1, n5);
            return true;
        }
        n6 = string.indexOf(".");
        stringArray[0] = string.substring(0, n6);
        stringArray2[0] = string.substring(n4 + 1, n5);
        return true;
    }

    public static void setHandleDoubleQuote(boolean bl) throws SQLException {
        s_parseAllFormat = bl;
    }

    public static boolean getHandleDoubleQuote() throws SQLException {
        return s_parseAllFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (object == this) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (!(object instanceof SQLName)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = ((SQLName)object).name.equals(this.name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public int hashCode() {
        return this.name == null ? -1 : this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.name);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.name;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLName.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeUTF(this.schema);
        objectOutputStream.writeUTF(this.simple);
        objectOutputStream.writeInt(this.version);
        objectOutputStream.writeBoolean(this.synonym);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.schema = objectInputStream.readUTF();
        this.simple = objectInputStream.readUTF();
        this.version = objectInputStream.readInt();
        this.synonym = objectInputStream.readBoolean();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.SQLName"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

