/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataDescriptorPacket
extends Packet
implements SQLnetDef {
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd = new int[26];
    Packet packet;
    boolean useLongDescriptor = false;
    private static final byte[] STANDARD_SDD_MAX_DD = new byte[]{0, 72, 0, 0, 15, 0, 0, 0, 0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public DataDescriptorPacket(SessionAtts sessionAtts) {
        super(sessionAtts, 72, 15, 0);
    }

    public DataDescriptorPacket(Packet packet, SessionAtts sessionAtts) {
        super(sessionAtts);
        this.packet = packet;
        this.buffer = this.packet.buffer;
    }

    protected void receive() throws IOException, NetException {
        this.packet.receive();
        this.descriptorFLaG = (this.buffer[8] & 0xFF) << 24 | (this.buffer[9] & 0xFF) << 16 | (this.buffer[10] & 0xFF) << 8 | this.buffer[11] & 0xFF;
        this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
        this.totalDataLength = (this.buffer[12] & 0xFF) << 24 | (this.buffer[13] & 0xFF) << 16 | (this.buffer[14] & 0xFF) << 8 | this.buffer[15] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int n2, boolean bl) throws IOException {
        int n3;
        if (n2 == 1703910 && !bl) {
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                this.sAtts.ntOutputStream.write(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length);
            }
        }
        this.useLongDescriptor = false;
        this.descriptorFLaG = 2;
        if (bl) {
            this.descriptorFLaG |= 1;
        }
        int n4 = 0;
        int n5 = n2;
        while (n5 > 0) {
            this.sdd[n4] = n5 > 65535 ? 65535 : n5;
            n5 -= this.sdd[n4];
            ++n4;
        }
        this.writeB4ToBuffer(this.buffer, 8, this.descriptorFLaG);
        this.writeB4ToBuffer(this.buffer, 12, n2);
        this.writeB4ToBuffer(this.buffer, 16, n4);
        for (n3 = 0; n3 < n4; ++n3) {
            this.writeB2ToBuffer(this.buffer, 20 + n3 * 2, this.sdd[n3]);
        }
        for (n3 = n4; n3 < 26; ++n3) {
            this.writeB2ToBuffer(this.buffer, 20 + n3 * 2, 0);
        }
        OutputStream outputStream = this.sAtts.ntOutputStream;
        synchronized (outputStream) {
            this.sAtts.ntOutputStream.write(this.buffer, 0, 72);
        }
    }

    void writeB4ToBuffer(byte[] byArray, int n2, int n3) {
        byte by = (byte)((n3 & 0xFF000000) >>> 24 & 0xFF);
        byte by2 = (byte)((n3 & 0xFF0000) >>> 16 & 0xFF);
        byte by3 = (byte)((n3 & 0xFF00) >>> 8 & 0xFF);
        byte by4 = (byte)(n3 & 0xFF);
        byArray[n2] = by;
        byArray[n2 + 1] = by2;
        byArray[n2 + 2] = by3;
        byArray[n2 + 3] = by4;
    }

    void writeB2ToBuffer(byte[] byArray, int n2, int n3) {
        byte by = (byte)((n3 & 0xFF00) >>> 8 & 0xFF);
        byte by2 = (byte)(n3 & 0xFF);
        byArray[n2] = by;
        byArray[n2 + 1] = by2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.net.ns");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.net.ns.DataDescriptorPacket"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

