/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleDataSourceFactory
implements ObjectFactory {
    private static final String CONNECTION_CACHING_ENABLED = "connectionCachingEnabled";
    private static final String CONNECTION_CACHE_NAME = "connectionCacheName";
    private static final String CONNECTION_CACHE_PROPERTIES = "connectionCacheProperties";
    private static final String CONNECTION_PROPERTIES = "connectionProperties";
    private static final String FAST_CONNECTION_FAILOVER_ENABLED = "fastConnectionFailoverEnabled";
    private static final String ONS_CONFIG_STR = "onsConfigStr";
    private static final String ORACLE_CONN_DATA_POOL_SOURCE = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
    private static final String ORACLE_OCI_CONN_POOL = "oracle.jdbc.pool.OracleOCIConnectionPool";
    private static final String ORACLE_DATA_SOURCE = "oracle.jdbc.pool.OracleDataSource";
    private static final String ORACLE_XA_DATA_SOURCE = "oracle.jdbc.xa.client.OracleXADataSource";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Object object2;
        try {
            String string;
            OracleDataSource oracleDataSource;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSourceFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(context) + ", " + OracleLog.argument(hashtable));
                    }
                    oracleDataSource = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Reference reference = (Reference)object;
            oracleDataSource = null;
            String string2 = reference.getClassName();
            Properties properties = new Properties();
            if (string2.equals(ORACLE_DATA_SOURCE) || string2.equals(ORACLE_XA_DATA_SOURCE)) {
                Properties properties2;
                oracleDataSource = string2.equals(ORACLE_DATA_SOURCE) ? new OracleDataSource() : new OracleXADataSource();
                object2 = null;
                object2 = (StringRefAddr)reference.get(CONNECTION_CACHING_ENABLED);
                if (object2 != null && (string = (String)((StringRefAddr)object2).getContent()).equals(String.valueOf("true"))) {
                    oracleDataSource.setConnectionCachingEnabled(true);
                }
                if ((object2 = (StringRefAddr)reference.get(CONNECTION_CACHE_NAME)) != null) {
                    oracleDataSource.setConnectionCacheName((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get(CONNECTION_CACHE_PROPERTIES)) != null) {
                    string = (String)((StringRefAddr)object2).getContent();
                    properties2 = this.extractConnectionCacheProperties(string);
                    oracleDataSource.setConnectionCacheProperties(properties2);
                }
                if ((object2 = (StringRefAddr)reference.get(CONNECTION_PROPERTIES)) != null) {
                    string = (String)((StringRefAddr)object2).getContent();
                    properties2 = this.extractConnectionProperties(string);
                    oracleDataSource.setConnectionProperties(properties2);
                }
                if ((object2 = (StringRefAddr)reference.get(FAST_CONNECTION_FAILOVER_ENABLED)) != null && (string = (String)((StringRefAddr)object2).getContent()).equals(String.valueOf("true"))) {
                    oracleDataSource.setFastConnectionFailoverEnabled(true);
                }
                if ((object2 = (StringRefAddr)reference.get(ONS_CONFIG_STR)) != null) {
                    oracleDataSource.setONSConfiguration((String)((StringRefAddr)object2).getContent());
                }
            } else if (string2.equals(ORACLE_CONN_DATA_POOL_SOURCE)) {
                oracleDataSource = new OracleConnectionPoolDataSource();
            } else if (string2.equals(ORACLE_OCI_CONN_POOL)) {
                oracleDataSource = new OracleOCIConnectionPool();
                object2 = null;
                string = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                StringRefAddr stringRefAddr = null;
                Object var17_21 = null;
                String string8 = null;
                stringRefAddr = (StringRefAddr)reference.get("connpool_min_limit");
                if (stringRefAddr != null) {
                    object2 = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("connpool_max_limit")) != null) {
                    string = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("connpool_increment")) != null) {
                    string3 = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("connpool_active_size")) != null) {
                    string4 = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("connpool_pool_size")) != null) {
                    string5 = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("connpool_timeout")) != null) {
                    string6 = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("connpool_nowait")) != null) {
                    string7 = (String)stringRefAddr.getContent();
                }
                if ((stringRefAddr = (StringRefAddr)reference.get("transactions_distributed")) != null) {
                    string8 = (String)stringRefAddr.getContent();
                }
                properties.put("connpool_min_limit", object2);
                properties.put("connpool_max_limit", string);
                properties.put("connpool_increment", string3);
                properties.put("connpool_active_size", string4);
                properties.put("connpool_pool_size", string5);
                properties.put("connpool_timeout", string6);
                if (string7 == "true") {
                    properties.put("connpool_nowait", string7);
                }
                if (string8 == "true") {
                    properties.put("transactions_distributed", string8);
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleDataSourceFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                        Object var20_23 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var20_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object var9_12 = null;
                Object var24_26 = null;
                if (!TRACE) return var9_12;
                if (!OracleLog.recursiveEnter()) return var9_12;
                try {
                    OracleDataSourceFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var26_29 = null;
                    OracleLog.recursiveExit();
                    return var9_12;
                }
                catch (Throwable throwable) {
                    Object var26_30 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (oracleDataSource != null) {
                object2 = null;
                object2 = (StringRefAddr)reference.get("url");
                if (object2 != null) {
                    oracleDataSource.setURL((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("userName")) != null || (object2 = (StringRefAddr)reference.get("u")) != null || (object2 = (StringRefAddr)reference.get("user")) != null) {
                    oracleDataSource.setUser((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("passWord")) != null || (object2 = (StringRefAddr)reference.get("password")) != null) {
                    oracleDataSource.setPassword((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("description")) != null || (object2 = (StringRefAddr)reference.get("describe")) != null) {
                    oracleDataSource.setDescription((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("driverType")) != null || (object2 = (StringRefAddr)reference.get("driver")) != null) {
                    oracleDataSource.setDriverType((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("serverName")) != null || (object2 = (StringRefAddr)reference.get("host")) != null) {
                    oracleDataSource.setServerName((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("databaseName")) != null || (object2 = (StringRefAddr)reference.get("sid")) != null) {
                    oracleDataSource.setDatabaseName((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("serviceName")) != null) {
                    oracleDataSource.setServiceName((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("networkProtocol")) != null || (object2 = (StringRefAddr)reference.get("protocol")) != null) {
                    oracleDataSource.setNetworkProtocol((String)((StringRefAddr)object2).getContent());
                }
                if ((object2 = (StringRefAddr)reference.get("portNumber")) != null || (object2 = (StringRefAddr)reference.get("port")) != null) {
                    string = (String)((StringRefAddr)object2).getContent();
                    oracleDataSource.setPortNumber(Integer.parseInt(string));
                }
                if ((object2 = (StringRefAddr)reference.get("tnsentryname")) != null || (object2 = (StringRefAddr)reference.get("tns")) != null) {
                    oracleDataSource.setTNSEntryName((String)((StringRefAddr)object2).getContent());
                } else if (string2.equals(ORACLE_OCI_CONN_POOL)) {
                    string = null;
                    object2 = (StringRefAddr)reference.get("connpool_is_poolcreated");
                    if (object2 != null) {
                        string = (String)((StringRefAddr)object2).getContent();
                    }
                    if (string.equals(String.valueOf("true"))) {
                        ((OracleOCIConnectionPool)oracleDataSource).setPoolConfig(properties);
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSourceFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleDataSource);
                    }
                    Object var22_38 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var22_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            object2 = oracleDataSource;
            Object var24_27 = null;
            if (!TRACE) return object2;
        }
        catch (Throwable throwable) {
            Object var24_28 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var26_34 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleDataSourceFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var26_33 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return object2;
        try {}
        catch (Throwable throwable) {
            Object var26_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleDataSourceFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var26_31 = null;
        OracleLog.recursiveExit();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties extractConnectionCacheProperties(String string) throws SQLException {
        String string2;
        Object object;
        String string3;
        Object object2;
        Properties properties = new Properties();
        int n2 = (string = string.substring(1, string.length() - 1)).indexOf("AttributeWeights", 0);
        if (n2 >= 0) {
            if (string.charAt(n2 + 16) != '=' || n2 > 0 && string.charAt(n2 - 1) != ' ') {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSourceFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 139);
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 139);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            object2 = new Properties();
            int n3 = string.indexOf("}", n2);
            string3 = string.substring(n2, n3);
            String string4 = string3.substring(18);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ");
            object = stringTokenizer;
            synchronized (object) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n4 = string2.length();
                    int n5 = string2.indexOf("=");
                    String string5 = string2.substring(0, n5);
                    String string6 = string2.substring(n5 + 1, n4);
                    ((Properties)object2).setProperty(string5, string6);
                }
            }
            properties.put("AttributeWeights", object2);
            if (n2 > 0 && n3 + 1 == string.length()) {
                string = string.substring(0, n2 - 2);
            } else if (n2 > 0 && n3 + 1 < string.length()) {
                object = string.substring(0, n2 - 2);
                string2 = string.substring(n3 + 1, string.length());
                string = ((String)object).concat(string2);
            } else {
                string = string.substring(n3 + 2, string.length());
            }
        }
        object2 = new StringTokenizer(string, ", ");
        StringTokenizer stringTokenizer = object2;
        synchronized (stringTokenizer) {
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string3 = ((StringTokenizer)object2).nextToken();
                int n6 = string3.length();
                int n7 = string3.indexOf("=");
                object = string3.substring(0, n7);
                string2 = string3.substring(n7 + 1, n6);
                properties.setProperty((String)object, string2);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties extractConnectionProperties(String string) throws SQLException {
        String[] stringArray;
        Properties properties = new Properties();
        string = string.substring(1, string.length() - 1);
        for (String string2 : stringArray = string.split(";")) {
            Object object;
            String string3;
            int n2 = string2.length();
            int n3 = string2.indexOf("=");
            if (n2 == 0 || n3 <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSourceFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 190);
                        string3 = null;
                    }
                    catch (Throwable throwable) {
                        string3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190);
                ((Throwable)object).fillInStackTrace();
                throw object;
            }
            object = string2.substring(0, n3);
            string3 = string2.substring(n3 + 1, n2);
            properties.setProperty(((String)object).trim(), string3.trim());
        }
        return properties;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDataSourceFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

