/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    boolean isFirstCol = true;
    static final byte TTICMD_UNAUTHORIZED = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIrxd(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)7);
    }

    void init() {
        this.isFirstCol = true;
    }

    void setNumberOfColumns(int n2) {
        this.nbOfColumns = n2;
        this.bvcFound = false;
        if (this.bvcColSent == null || this.bvcColSent.length() < this.nbOfColumns) {
            this.bvcColSent = new BitSet(this.nbOfColumns);
        } else {
            this.bvcColSent.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmarshalBVC(int n2) throws SQLException, IOException {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.bvcColSent.length(); ++n3) {
            this.bvcColSent.clear(n3);
        }
        n3 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((by & 1 << i3) == 0) continue;
                this.bvcColSent.set(i2 * 8 + i3);
                ++n4;
            }
        }
        if (n4 != n2) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIrxd.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + -1 + "INTERNAL ERROR: oracle.jdbc.driver." + "T4CTTIrxd.unmarshalBVC: bits missing in vector");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.unmarshalBVC: bits missing in vector");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] byArray) throws SQLException, IOException {
        int n2;
        for (n2 = 0; n2 < this.bvcColSent.length(); ++n2) {
            this.bvcColSent.clear(n2);
        }
        if (byArray == null || byArray.length == 0) {
            this.bvcFound = false;
        } else {
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byte by = byArray[n2];
                for (int i2 = 0; i2 < 8; ++i2) {
                    if ((by & 1 << i2) == 0) continue;
                    this.bvcColSent.set(n2 * 8 + i2);
                }
            }
            this.bvcFound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector<IOException> marshal(byte[] byArray, char[] cArray, short[] sArray, int n2, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[][] byArray3, OracleTypeADT[] oracleTypeADTArray, byte[] byArray4, char[] cArray2, short[] sArray2, byte[] byArray5, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2) throws IOException {
        Vector<IOException> vector = null;
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            this.marshalTTCcode();
            int n21 = sArray[n2 + 0] & 0xFFFF;
            int n22 = 0;
            int n23 = nArray3[0];
            int[] nArray5 = nArray4[0];
            int n24 = 0;
            if (bl2) {
                n20 = 1;
                assert (n23 > 0) : "No postoned columns in RXD";
            } else {
                for (n19 = 0; n19 < n21; ++n19) {
                    short s2;
                    int n25;
                    int n26;
                    if (n22 < n23 && nArray5[n22] == n19) {
                        ++n22;
                        continue;
                    }
                    n18 = 0;
                    n17 = n2 + 5 + 10 * n19;
                    n16 = sArray[n17 + 0] & 0xFFFF;
                    if (byArray5 != null && (byArray5[n19] & 0x20) == 0) {
                        if (n16 != 998) continue;
                        ++n24;
                        continue;
                    }
                    n15 = ((sArray[n17 + 7] & 0xFFFF) << 16) + (sArray[n17 + 8] & 0xFFFF) + n3;
                    n14 = ((sArray[n17 + 5] & 0xFFFF) << 16) + (sArray[n17 + 6] & 0xFFFF) + n3;
                    n13 = sArray[n15] & 0xFFFF;
                    n12 = sArray[n14];
                    if (n16 == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n16 == 994) {
                        n12 = -1;
                        n26 = nArray2[3 + n19 * 4 + 0];
                        if (n26 == 109) {
                            n18 = 1;
                        }
                    } else if (n16 == 8 || n16 == 24 || !bl && nArray != null && nArray.length > n19 && nArray[n19] > 4000) {
                        if (n23 >= nArray5.length) {
                            int[] nArray6 = new int[nArray5.length << 1];
                            System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                            nArray5 = nArray6;
                        }
                        nArray5[n23++] = n19;
                        continue;
                    }
                    if (n12 == -1) {
                        if (n16 == 109 || n18 != 0) {
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (n16 == 998) {
                            ++n24;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n16 == 112 || n16 == 113 || n16 == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n16 != 8 && n16 != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (n16 == 998) {
                        n26 = (sArray2[6 + n24 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n24 * 8 + 5] & 0xFFFF;
                        n25 = (sArray2[6 + n24 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n24 * 8 + 7] & 0xFFFF;
                        n11 = sArray2[6 + n24 * 8] & 0xFFFF;
                        n10 = sArray2[6 + n24 * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(n26);
                        for (n9 = 0; n9 < n26; ++n9) {
                            s2 = n25 + n9 * n10;
                            if (n11 == 9) {
                                n8 = cArray2[s2] / 2;
                                n7 = 0;
                                n7 = dBConversion.javaCharsToCHARBytes(cArray2, s2 + 1, byArray2, 0, n8);
                                this.meg.marshalCLR(byArray2, n7);
                                continue;
                            }
                            n13 = byArray4[s2];
                            if (n13 < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(byArray4, s2 + 1, n13);
                        }
                        ++n24;
                        continue;
                    }
                    int n27 = sArray[n17 + 1] & 0xFFFF;
                    if (n27 != 0) {
                        int n28 = ((sArray[n17 + 3] & 0xFFFF) << 16) + (sArray[n17 + 4] & 0xFFFF) + n27 * n3;
                        if (n16 == 6) {
                            ++n28;
                            --n13;
                        } else if (n16 == 9) {
                            n28 += 2;
                            n13 -= 2;
                        } else if (n16 == 114 || n16 == 113 || n16 == 112) {
                            this.meg.marshalUB4(n13);
                        }
                        if (n16 == 109 || n16 == 111) {
                            if (byArray3 == null) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        T4CTTIrxd.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + -1 + "INTERNAL ERROR: oracle.jdbc.driver." + "T4CTTIrxd.marshal: parameterDatum is null");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            byte[] byArray6 = byArray3[n19];
                            int n29 = n13 = byArray6 == null ? 0 : byArray6.length;
                            if (n16 == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(n13);
                                this.meg.marshalUB2(1);
                            }
                            if (n13 <= 0) continue;
                            this.meg.marshalCLR(byArray6, 0, n13);
                            continue;
                        }
                        if (n16 == 104) {
                            long[] lArray = T4CRowidAccessor.stringToRowid(byArray, n28 += 2, 18);
                            n25 = 14;
                            long l2 = lArray[0];
                            n9 = (int)lArray[1];
                            s2 = 0;
                            long l3 = lArray[2];
                            int n30 = (int)lArray[3];
                            if (l2 == 0L && n9 == 0 && l3 == 0L && n30 == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1((short)n25);
                            this.meg.marshalUB4(l2);
                            this.meg.marshalUB2(n9);
                            this.meg.marshalUB1(s2);
                            this.meg.marshalUB4(l3);
                            this.meg.marshalUB2(n30);
                            continue;
                        }
                        if (n16 == 208) {
                            this.meg.marshalUB4(n13 -= 2);
                            this.meg.marshalCLR(byArray, n28 += 2, n13);
                            continue;
                        }
                        if (n13 < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        this.meg.marshalCLR(byArray, n28, n13);
                        continue;
                    }
                    n6 = sArray[n17 + 9] & 0xFFFF;
                    n5 = sArray[n17 + 2] & 0xFFFF;
                    n4 = ((sArray[n17 + 3] & 0xFFFF) << 16) + (sArray[n17 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n16 == 996) {
                        n26 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n26) {
                            this.bufferCHAR = new byte[n26];
                        }
                        for (n25 = 0; n25 < n26; ++n25) {
                            this.bufferCHAR[n25] = (byte)((cArray[n4 + n25 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (n25 >= n26 - 1) continue;
                            this.bufferCHAR[n25 + 1] = (byte)(cArray[n4 + n25 / 2] & 0xFF & 0xFF);
                            ++n25;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n26);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n16 == 96) {
                        n8 = n13 / 2;
                        --n4;
                    } else {
                        n8 = (n13 - 2) / 2;
                    }
                    n7 = 0;
                    n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                    this.meg.marshalCLR(byArray2, n7);
                }
                n20 = n23;
            }
            if (n23 > 0) {
                for (n19 = 0; n19 < n20; ++n19) {
                    InputStream inputStream;
                    int n31;
                    n18 = nArray5[n19];
                    n17 = n2 + 5 + 10 * n18;
                    n16 = sArray[n17 + 0] & 0xFFFF;
                    n15 = ((sArray[n17 + 7] & 0xFFFF) << 16) + (sArray[n17 + 8] & 0xFFFF) + n3;
                    n14 = ((sArray[n17 + 5] & 0xFFFF) << 16) + (sArray[n17 + 6] & 0xFFFF) + n3;
                    n12 = sArray[n14];
                    n13 = sArray[n15] & 0xFFFF;
                    n5 = sArray[n17 + 2] & 0xFFFF;
                    n4 = ((sArray[n17 + 3] & 0xFFFF) << 16) + (sArray[n17 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n12 == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n16 == 996) {
                        n31 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n31) {
                            this.bufferCHAR = new byte[n31];
                        }
                        for (int i2 = 0; i2 < n31; ++i2) {
                            this.bufferCHAR[i2] = (byte)((cArray[n4 + i2 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i2 >= n31 - 1) continue;
                            this.bufferCHAR[i2 + 1] = (byte)(cArray[n4 + i2 / 2] & 0xFF & 0xFF);
                            ++i2;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n31);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n16 != 8 && n16 != 24) {
                        if (n16 == 96) {
                            n8 = n13 / 2;
                            --n4;
                        } else {
                            n8 = (n13 - 2) / 2;
                        }
                        n6 = sArray[n17 + 9] & 0xFFFF;
                        n7 = 0;
                        n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                        this.meg.marshalCLR(byArray2, n7);
                        continue;
                    }
                    n31 = n18;
                    if (inputStreamArray == null || (inputStream = inputStreamArray[n31]) == null) continue;
                    n11 = 64;
                    if (this.buffer == null) {
                        this.buffer = new byte[n11];
                    }
                    n10 = 0;
                    this.meg.marshalUB1((short)254);
                    n9 = 0;
                    while (n9 == 0 && !this.connection.sentCancel) {
                        try {
                            n10 = inputStream.read(this.buffer, 0, n11);
                        }
                        catch (IOException iOException) {
                            n10 = -1;
                            if (vector == null) {
                                vector = new Vector<IOException>();
                            }
                            vector.add(iOException);
                        }
                        if (n10 == -1) {
                            n9 = 1;
                        }
                        if (n10 <= 0) continue;
                        this.meg.marshalUB1((short)(n10 & 0xFF));
                        this.meg.marshalB1Array(this.buffer, 0, n10);
                    }
                    this.meg.marshalUB1((short)0);
                }
            }
            nArray3[0] = n23;
            nArray4[0] = nArray5;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException);
            throw iOException;
        }
        return vector;
    }

    boolean unmarshal(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        return this.unmarshal(accessorArray, 0, n2);
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3) throws SQLException, IOException {
        if (n2 == 0) {
            this.isFirstCol = true;
        }
        for (int i2 = n2; i2 < n3 && i2 < accessorArray.length; ++i2) {
            int n4;
            int n5;
            if (accessorArray[i2] == null) continue;
            if (accessorArray[i2].physicalColumnIndex < 0) {
                n5 = 0;
                for (n4 = 0; n4 < n3 && n4 < accessorArray.length; ++n4) {
                    if (accessorArray[n4] == null) continue;
                    accessorArray[n4].physicalColumnIndex = n5++;
                    if (accessorArray[n4].isUseLess) continue;
                }
            }
            if (this.bvcFound && !accessorArray[i2].isUseLess && !this.bvcColSent.get(accessorArray[i2].physicalColumnIndex)) {
                accessorArray[i2].copyRow();
                continue;
            }
            n5 = 0;
            if (accessorArray[i2].statement.statementType != 2 && !accessorArray[i2].statement.sqlKind.isPlsqlOrCall()) {
                n4 = accessorArray[i2].metaDataIndex + accessorArray[i2].lastRowProcessed * 1;
                if (accessorArray[i2].securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                    n5 = (byte)this.meg.unmarshalUB1();
                }
                accessorArray[i2].rowSpaceMetaData[n4] = n5;
            }
            if (accessorArray[i2].unmarshalOneRow()) {
                return true;
            }
            this.isFirstCol = false;
        }
        this.bvcFound = false;
        return false;
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3, int n4) throws SQLException, IOException {
        return false;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIrxd"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

