/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T2CDriverExtension() {
    }

    Connection getConnection(String string, Properties properties) throws SQLException {
        T2CConnection t2CConnection = null;
        t2CConnection = properties.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(string, properties, (Object)this) : new T2CConnection(string, properties, this);
        return t2CConnection;
    }

    OracleStatement allocateStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        return new T2CStatement((T2CConnection)physicalConnection, 1, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T2CPreparedStatement((T2CConnection)physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    OracleCallableStatement allocateCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T2CCallableStatement((T2CConnection)physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
    }

    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T2CInputStream(oracleStatement, n2, accessor);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CDriverExtension"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

