/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.ECForJDBC;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.CancelLock;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    int cursorId;
    int numberOfDefinePositions;
    int definesBatchSize;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described = false;
    boolean describedWithNames = false;
    byte[] defineMetaData;
    int defineMetaDataSubRange;
    static final int METADATALENGTH = 1;
    int rowsProcessed;
    int cachedDefineByteSize = 0;
    int cachedDefineCharSize = 0;
    int cachedDefineIndicatorSize = 0;
    int cachedDefineMetaDataSize = 0;
    OracleStatement children = null;
    OracleStatement parent = null;
    OracleStatement nextChild = null;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    Object[][] userStream;
    int firstRowInBatch;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    ByteBuffer[] nioBuffers = null;
    Object[] lobPrefetchMetaData = null;
    boolean hasStream;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    int[] definedColumnFormOfUse = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    boolean aFetchWasDoneDuringDescribe = false;
    boolean implicitDefineForLobPrefetchDone = false;
    long checkSum = 0L;
    boolean checkSumComputationFailure = false;
    int accessorByteOffset = 0;
    int accessorCharOffset = 0;
    int accessorShortOffset = 0;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl currentResultSet;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int batch;
    int numberOfExecutedElementsInBatch = -1;
    int currentRank;
    boolean bsendBatchInProgress = false;
    int currentRow;
    int validRows;
    int maxFieldSize;
    int maxRows;
    int totalRowsVisited;
    int rowPrefetch;
    int rowPrefetchInLastFetch = -1;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    int defaultLobPrefetchSize;
    boolean gotLastBatch;
    boolean clearParameters;
    boolean closed;
    boolean sqlStringChanged;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.SELECT;
    byte sqlKindByte = 1;
    int autoRollback;
    int defaultFetchDirection;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    protected CancelLock cancelLock = new CancelLock();
    OracleStatementWrapper wrapper;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType = (byte)-1;
    OracleResultSet scrollRset;
    oracle.jdbc.OracleResultSetCache rsetCache;
    int userRsetType;
    int realRsetType;
    boolean needToAddIdentifier;
    SQLWarning sqlWarning;
    int cacheState = 3;
    int creationState = 0;
    boolean isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    int[] returnParamMeta;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_FORM_OF_USE_OFFSET = 3;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 4;
    Accessor[] returnParamAccessors;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    byte[] returnParamBytes;
    char[] returnParamChars;
    short[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    OracleReturnResultSet returnResultSet;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone = null;
    String defaultTimeZoneName = null;
    Calendar defaultCalendar = null;
    Calendar gmtCalendar = null;
    static int GLOBAL_STATEMENT_NUMBER = 1;
    StateIntf dmsSqlText = null;
    PhaseEventIntf dmsExecute = null;
    PhaseEventIntf dmsFetch = null;
    long inScn = 0L;
    int lastIndex;
    Vector m_batchItems = null;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    ArrayList oldTempClobsToFree = null;
    ArrayList oldTempBlobsToFree = null;
    NTFDCNRegistration registration = null;
    String[] dcnTableName = null;
    long dcnQueryId = -1L;
    long _checkSum = 0L;
    static final byte IS_UNINITIALIZED = 0;
    static final byte IS_SELECT = 1;
    static final byte IS_DELETE = 2;
    static final byte IS_INSERT = 4;
    static final byte IS_MERGE = 8;
    static final byte IS_UPDATE = 16;
    static final byte IS_PLSQL_BLOCK = 32;
    static final byte IS_CALL_BLOCK = 64;
    static final byte IS_OTHER = -128;
    static final byte IS_DML = 30;
    static final byte IS_PLSQL = 96;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForRows(boolean var1) throws SQLException;

    abstract void fetch() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueReadRow(int n2) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "continueReadRow is only implemented by the T4C statements.");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cursorIfRefCursor() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "cursorIfRefCursor not implemented");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void closeCursorOnPlainStatement() throws SQLException {
    }

    public void setSnapshotSCN(long l2) throws SQLException {
        this.doSetSnapshotSCN(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetSnapshotSCN(long l2) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void createDMSSensors() throws SQLException {
        this.dmsSqlText = this.connection.commonDmsSqlText;
        if (this.connection.dmsUpdateSqlText()) {
            this.dmsSqlText.update((Object)this.sqlObject.toString());
        }
        this.dmsExecute = this.connection.commonDmsExecute;
        this.dmsFetch = this.connection.commonDmsFetch;
    }

    void destroyDMSSensors() throws SQLException {
        if (this.dmsSqlText != null && this.dmsSqlText != this.connection.commonDmsSqlText) {
            this.dmsSqlText.destroy();
            this.dmsSqlText = null;
        }
        if (this.dmsExecute != null && this.dmsExecute != this.connection.commonDmsExecute) {
            this.dmsExecute.destroy();
            this.dmsExecute = null;
        }
        if (this.dmsFetch != null && this.dmsFetch != this.connection.commonDmsFetch) {
            this.dmsFetch.destroy();
            this.dmsFetch = null;
        }
    }

    OracleStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        this(physicalConnection, n2, n3, -1, -1);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n2, int n3, int n4, int n5) throws SQLException {
        this.connection = physicalConnection;
        this.connection.needLine();
        this.connection.registerHeartbeat();
        this.connection.addStatement(this);
        this.sqlObject = new OracleSql(this.connection.conversion);
        this.processEscapes = this.connection.processEscapes;
        this.convertNcharLiterals = this.connection.convertNcharLiterals;
        this.autoRollback = 2;
        this.gotLastBatch = false;
        this.closed = false;
        this.clearParameters = true;
        this.serverCursor = false;
        this.needToAddIdentifier = false;
        this.defaultFetchDirection = 1000;
        this.fixedString = this.connection.getDefaultFixedString();
        this.rowPrefetchChanged = false;
        this.rowPrefetch = n3;
        this.defaultRowPrefetch = n3;
        this.defaultLobPrefetchSize = this.connection.getVersionNumber() >= 11000 ? this.connection.defaultLobPrefetchSize : -1;
        this.batch = n2;
        this.sqlStringChanged = true;
        this.needToParse = true;
        this.needToPrepareDefineBuffer = true;
        this.columnsDefinedByUser = false;
        if (n4 != -1 || n5 != -1) {
            this.realRsetType = 0;
            this.userRsetType = ResultSetUtil.getRsetTypeCode(n4, n5);
            this.needToAddIdentifier = ResultSetUtil.needIdentifier(this.userRsetType);
        } else {
            this.userRsetType = 1;
            this.realRsetType = 1;
        }
        this.createDMSSensors();
    }

    void initializeDefineSubRanges() {
        this.defineByteSubRange = 0;
        this.defineCharSubRange = 0;
        this.defineIndicatorSubRange = 0;
        this.defineMetaDataSubRange = 0;
    }

    void prepareDefinePreambles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareAccessors() throws SQLException {
        Accessor accessor;
        int n2;
        byte[] byArray = null;
        char[] cArray = null;
        short[] sArray = null;
        boolean bl = false;
        byte[] byArray2 = null;
        if (this.accessors == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.numberOfDefinePositions; ++n2) {
            accessor = this.accessors[n2];
            if (accessor == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            switch (accessor.internalType) {
                case 8: 
                case 24: {
                    this.hasStream = true;
                }
            }
            n3 += accessor.byteLength;
            n4 += accessor.charLength;
            ++n5;
        }
        if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
            this.rowPrefetch = 1;
        }
        this.definesBatchSize = n2 = this.rowPrefetch;
        this.initializeDefineSubRanges();
        int n6 = n5 * n2;
        if (this.defineMetaData == null || this.defineMetaData.length < n6) {
            if (this.defineMetaData != null) {
                byArray2 = this.defineMetaData;
            }
            this.defineMetaData = new byte[n6];
        }
        this.cachedDefineByteSize = this.defineByteSubRange + n3 * n2;
        if (this.defineBytes == null || this.defineBytes.length < this.cachedDefineByteSize) {
            if (this.defineBytes != null) {
                byArray = this.defineBytes;
            }
            this.defineBytes = this.connection.getByteBuffer(this.cachedDefineByteSize);
        }
        this.defineByteSubRange += this.accessorByteOffset;
        this.cachedDefineCharSize = this.defineCharSubRange + n4 * n2;
        if ((this.defineChars == null || this.defineChars.length < this.cachedDefineCharSize) && this.cachedDefineCharSize > 0) {
            if (this.defineChars != null) {
                cArray = this.defineChars;
            }
            this.defineChars = this.connection.getCharBuffer(this.cachedDefineCharSize);
        }
        this.defineCharSubRange += this.accessorCharOffset;
        int n7 = this.numberOfDefinePositions * n2;
        int n8 = this.defineIndicatorSubRange + n7 + n7;
        if (this.defineIndicators == null || this.defineIndicators.length < n8) {
            if (this.defineIndicators != null) {
                sArray = this.defineIndicators;
            }
            this.defineIndicators = new short[n8];
        } else if (this.defineIndicators.length >= n8) {
            bl = true;
            sArray = this.defineIndicators;
        }
        this.defineIndicatorSubRange += this.accessorShortOffset;
        int n9 = this.defineIndicatorSubRange + n7;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            accessor = this.accessors[i2];
            accessor.lengthIndexLastRow = accessor.lengthIndex;
            accessor.indicatorIndexLastRow = accessor.indicatorIndex;
            accessor.columnIndexLastRow = accessor.columnIndex;
            accessor.setOffsets(n2);
            accessor.lengthIndex = n9;
            accessor.indicatorIndex = this.defineIndicatorSubRange;
            accessor.metaDataIndex = this.defineMetaDataSubRange;
            accessor.rowSpaceByte = this.defineBytes;
            accessor.rowSpaceChar = this.defineChars;
            accessor.rowSpaceIndicator = this.defineIndicators;
            accessor.rowSpaceMetaData = this.defineMetaData;
            this.defineIndicatorSubRange += n2;
            n9 += n2;
            this.defineMetaDataSubRange += n2 * 1;
        }
        this.prepareDefinePreambles();
        if (this.rowPrefetchInLastFetch != -1 && this.rowPrefetch != this.rowPrefetchInLastFetch) {
            if (cArray == null) {
                cArray = this.defineChars;
            }
            if (byArray == null) {
                byArray = this.defineBytes;
            }
            if (sArray == null) {
                sArray = this.defineIndicators;
            }
            this.saveDefineBuffersIfRequired(cArray, byArray, sArray, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAccessorsUsable() throws SQLException {
        int n2 = this.accessors.length;
        if (n2 < this.numberOfDefinePositions) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            Accessor accessor = this.accessors[i2];
            if (accessor == null || accessor.externalType == 0) {
                bl = false;
                continue;
            }
            bl2 = true;
        }
        if (bl) {
            bl3 = true;
        } else {
            if (bl2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.columnsDefinedByUser = false;
        }
        return bl3;
    }

    void executeMaybeDescribe() throws SQLException {
        boolean bl = true;
        if (this.rowPrefetchChanged) {
            if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
        if (!this.needToPrepareDefineBuffer) {
            if (this.accessors == null) {
                this.needToPrepareDefineBuffer = true;
            } else if (this.columnsDefinedByUser) {
                this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
            }
        }
        boolean bl2 = false;
        try {
            this.cancelLock.enterExecuting();
            if (this.needToPrepareDefineBuffer) {
                if (!this.columnsDefinedByUser) {
                    this.executeForDescribe();
                    bl2 = true;
                    if (this.aFetchWasDoneDuringDescribe) {
                        bl = false;
                    }
                }
                if (this.needToPrepareDefineBuffer) {
                    this.prepareAccessors();
                }
            }
            int n2 = this.accessors.length;
            for (int i2 = this.numberOfDefinePositions; i2 < n2; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                accessor.rowSpaceIndicator = null;
            }
            if (bl) {
                this.executeForRows(bl2);
            }
        }
        catch (SQLException sQLException) {
            this.needToParse = true;
            throw sQLException;
        }
        finally {
            this.cancelLock.exitExecuting();
        }
    }

    void adjustGotLastBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteWithTimeout() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Throwable throwable = new Throwable("No Error");
                OracleStatement.logger().log(Level.CONFIG, Integer.toHexString(this.hashCode()).toUpperCase() + " SQL: " + this.sqlObject.getOriginalSql(), throwable);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        long l2 = 0L;
        if (this.dmsExecute != null) {
            l2 = this.dmsExecute.start();
        }
        try {
            this.connection.updateSystemContext();
            if (this.connection.dmsUpdateSqlText()) {
                this.dmsSqlText.update((Object)this.sqlObject.toString());
            }
            this.cleanOldTempLobs();
            this.connection.registerHeartbeat();
            this.rowsProcessed = 0;
            if (this.sqlKind.isSELECT()) {
                if (this.connection.j2ee13Compliant && this.executionType == 2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 129);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.connection.needLine();
                if (!this.isOpen) {
                    this.connection.open(this);
                    this.isOpen = true;
                }
                if (this.queryTimeout != 0) {
                    try {
                        this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                        this.executeMaybeDescribe();
                    }
                    finally {
                        this.connection.getTimeout().cancelTimeout();
                    }
                } else {
                    this.executeMaybeDescribe();
                }
                this.checkValidRowsStatus();
                if (this.serverCursor) {
                    this.adjustGotLastBatch();
                }
            } else {
                if (this.connection.j2ee13Compliant && !this.sqlKind.isPlsqlOrCall() && this.executionType == 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 128);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ++this.currentRank;
                if (this.currentRank >= this.batch) {
                    try {
                        this.connection.needLine();
                        this.cancelLock.enterExecuting();
                        if (!this.isOpen) {
                            this.connection.open(this);
                            this.isOpen = true;
                        }
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                        }
                        this.executeForRows(false);
                    }
                    catch (SQLException sQLException) {
                        this.needToParse = true;
                        if (this.batch > 1) {
                            int n2;
                            int[] nArray;
                            this.clearBatch();
                            if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch < this.batch) {
                                nArray = new int[this.numberOfExecutedElementsInBatch];
                                for (n2 = 0; n2 < nArray.length; ++n2) {
                                    nArray[n2] = -2;
                                }
                            } else {
                                nArray = new int[this.batch];
                                for (n2 = 0; n2 < nArray.length; ++n2) {
                                    nArray[n2] = -3;
                                }
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + sQLException + nArray.length + nArray);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(sQLException, nArray.length, nArray);
                            batchUpdateException.fillInStackTrace();
                            throw batchUpdateException;
                        }
                        this.resetCurrentRowBinders();
                        throw sQLException;
                    }
                    finally {
                        if (this.queryTimeout != 0) {
                            this.connection.getTimeout().cancelTimeout();
                        }
                        this.currentRank = 0;
                        this.cancelLock.exitExecuting();
                        this.checkValidRowsStatus();
                    }
                }
            }
            if (this.connection.whichDMS == 1) {
                ExecutionContext.get().setECIDSequenceNumber((int)this.connection.endToEndECIDSequenceNumber);
            } else if (this.connection.whichDMS == 2) {
                ECForJDBC.finished();
            }
        }
        catch (SQLException sQLException) {
            this.connection.resetSystemContext();
            this.resetOnExceptionDuringExecute();
            throw sQLException;
        }
        finally {
            if (this.dmsExecute != null) {
                this.dmsExecute.stop(l2);
            }
        }
        this.connection.registerHeartbeat();
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void resetCurrentRowBinders() {
    }

    void open() throws SQLException {
        if (!this.isOpen) {
            this.connection.needLine();
            this.connection.open(this);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet oracleResultSet;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleResultSet oracleResultSet2 = null;
                try {
                    this.executionType = 1;
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.hasStream = false;
                    this.sqlObject.initialize(string);
                    this.sqlKind = this.sqlObject.getSqlKind();
                    this.needToParse = true;
                    this.prepareForNewResults(true, true);
                    if (this.userRsetType == 1) {
                        this.doExecuteWithTimeout();
                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        oracleResultSet2 = this.currentResultSet;
                    } else {
                        oracleResultSet2 = this.doScrollStmtExecuteQuery();
                        if (oracleResultSet2 == null) {
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                            oracleResultSet2 = this.currentResultSet;
                        }
                    }
                }
                finally {
                    this.executionType = (byte)-1;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleResultSet2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSet = oracleResultSet2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithKey(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.closeOrCache(null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    protected void closeOrCache(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.lifecycle == 2) {
            this.connection.needLineUnchecked();
        } else {
            this.connection.needLine();
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, string);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.hardClose();
        }
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean bl) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.removeStatement(this);
        this.cleanupDefines();
        if (this.isOpen && bl && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
            this.connection.registerHeartbeat();
            this.doClose();
            this.isOpen = false;
        }
        this.sqlObject = null;
        this.destroyDMSSensors();
    }

    protected void alwaysOnClose() throws SQLException {
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            OracleStatement oracleStatement2 = oracleStatement.nextChild;
            oracleStatement.close();
            oracleStatement = oracleStatement2;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.closed = true;
        if (this.connection.lifecycle == 1 || this.connection.lifecycle == 2) {
            if (this.currentResultSet != null) {
                this.currentResultSet.internal_close(false);
                this.currentResultSet = null;
            }
            if (this.scrollRset != null) {
                this.scrollRset.close();
                this.scrollRset = null;
            }
            if (this.returnResultSet != null) {
                this.returnResultSet.close();
                this.returnResultSet = null;
            }
        }
        this.clearWarnings();
        this.m_batchItems = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                return;
            }
            this.hardClose(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setNonAutoKey();
                int n3 = this.executeUpdateInternal(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeUpdateInternal(String string) throws SQLException {
        try {
            if (this.executionType == -1) {
                this.executionType = (byte)2;
            }
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true);
            if (this.userRsetType == 1) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            int n2 = this.validRows;
            return n2;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setNonAutoKey();
                boolean bl2 = this.executeInternal(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeInternal(String string) throws SQLException {
        try {
            this.executionType = (byte)3;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfJdbcBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(string);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true);
            if (this.userRsetType == 1) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            boolean bl = this.sqlKind.isSELECT();
            return bl;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfColumns() throws SQLException {
        this.ensureOpen();
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(false);
                this.described = true;
            }
        }
        return this.numberOfDefinePositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescription() throws SQLException {
        this.ensureOpen();
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(false);
                this.described = true;
            }
        }
        return this.accessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescriptionWithNames() throws SQLException {
        this.ensureOpen();
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        return this.accessors;
    }

    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        return this.sqlObject.getSqlKind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.freeLine();
                this.streamList = null;
                this.columnsDefinedByUser = false;
                this.needToPrepareDefineBuffer = true;
                this.numberOfDefinePositions = 0;
                this.definesBatchSize = 0;
                this.described = false;
                this.describedWithNames = false;
                this.cleanupDefines();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
    }

    void defineColumnTypeInternal(int n2, int n3, int n4, boolean bl, String string) throws SQLException {
        this.defineColumnTypeInternal(n2, n3, n4, (short)1, bl, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int n5;
        int n6;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n2 < 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 == 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n7 = n2 - 1;
        int n8 = n6 = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
        if (bl) {
            if (n3 == 1 || n3 == 12) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + "defineColumnType with a type that requires a length, but no length provided");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else {
            if (n4 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n6 == -1 && n4 > 0 || n6 > 0 && n4 < n6) {
                n6 = n4;
            }
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 28);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.columnsDefinedByUser) {
            this.clearDefines();
            this.columnsDefinedByUser = true;
        }
        if (this.numberOfDefinePositions < n2) {
            if (this.accessors == null || this.accessors.length < n2) {
                Accessor[] accessorArray = new Accessor[n2 << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, accessorArray, 0, this.numberOfDefinePositions);
                }
                this.accessors = accessorArray;
            }
            this.numberOfDefinePositions = n2;
        }
        if (!((n5 = this.getInternalType(n3)) != 109 && n5 != 111 || string != null && !string.equals(""))) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Invalid arguments");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = this.accessors[n7];
        boolean bl2 = true;
        if (accessor != null) {
            int n9 = accessor.useForDataAccessIfPossible(n5, n3, n6, string);
            if (n9 == 0) {
                s2 = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n9 == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n9 == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.needToPrepareDefineBuffer = true;
        }
        if (accessor == null) {
            this.accessors[n7] = this.allocateAccessor(n5, n3, n2, n6, s2, string, false);
            this.described = false;
            this.describedWithNames = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Accessor allocateAccessor(int var1_1, int var2_2, int var3_3, int var4_4, short var5_5, String var6_6, boolean var7_7) throws SQLException {
        switch (var1_1) {
            case 96: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl15
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_9 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_9.fillInStackTrace();
                throw var9_9;
lbl15:
                // 1 sources

                return new CharAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 8: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl29
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_10 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_10.fillInStackTrace();
                throw var9_10;
lbl29:
                // 1 sources

                if (!var7_7) {
                    return new LongAccessor(this, var3_3, var4_4, var5_5, var2_2);
                }
            }
            case 1: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl44
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_11 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_11.fillInStackTrace();
                throw var9_11;
lbl44:
                // 1 sources

                return new VarcharAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 2: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl58
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_12 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_12.fillInStackTrace();
                throw var9_12;
lbl58:
                // 1 sources

                return new NumberAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 6: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl72
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_13 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_13.fillInStackTrace();
                throw var9_13;
lbl72:
                // 1 sources

                return new VarnumAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 24: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl86
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_14 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_14.fillInStackTrace();
                throw var9_14;
lbl86:
                // 1 sources

                if (!var7_7) {
                    return new LongRawAccessor(this, var3_3, var4_4, var5_5, var2_2);
                }
            }
            case 23: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl101
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_15 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_15.fillInStackTrace();
                throw var9_15;
lbl101:
                // 1 sources

                if (var7_7) {
                    return new OutRawAccessor(this, var4_4, var5_5, var2_2);
                }
                return new RawAccessor(this, var4_4, var5_5, var2_2, false);
            }
            case 100: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl117
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_16 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_16.fillInStackTrace();
                throw var9_16;
lbl117:
                // 1 sources

                return new BinaryFloatAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 101: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl131
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_17 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_17.fillInStackTrace();
                throw var9_17;
lbl131:
                // 1 sources

                return new BinaryDoubleAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 104: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl145
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_18 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_18.fillInStackTrace();
                throw var9_18;
lbl145:
                // 1 sources

                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                    var4_4 = 18;
                    var8_44 = new VarcharAccessor(this, var4_4, var5_5, var2_2, var7_7);
                    var8_44.definedColumnType = -8;
                    return var8_44;
                }
                return new RowidAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 102: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl164
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_19 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_19.fillInStackTrace();
                throw var9_19;
lbl164:
                // 1 sources

                return new ResultSetAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 12: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl178
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_20 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_20.fillInStackTrace();
                throw var9_20;
lbl178:
                // 1 sources

                return new DateAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 113: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl192
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_21 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_21.fillInStackTrace();
                throw var9_21;
lbl192:
                // 1 sources

                var8_45 = new BlobAccessor(this, -1, var5_5, var2_2, var7_7);
                if (!var7_7) {
                    var8_45.lobPrefetchSizeForThisColumn = var4_4;
                }
                return var8_45;
            }
            case 112: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl209
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_22 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_22.fillInStackTrace();
                throw var9_22;
lbl209:
                // 1 sources

                var8_46 = new ClobAccessor(this, -1, var5_5, var2_2, var7_7);
                if (!var7_7) {
                    var8_46.lobPrefetchSizeForThisColumn = var4_4;
                }
                return var8_46;
            }
            case 114: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl226
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_23 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_23.fillInStackTrace();
                throw var9_23;
lbl226:
                // 1 sources

                var8_47 = new BfileAccessor(this, -1, var5_5, var2_2, var7_7);
                return var8_47;
            }
            case 109: {
                if (var6_6 != null) ** GOTO lbl253
                if (!var7_7) ** GOTO lbl242
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_24 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_24.fillInStackTrace();
                throw var9_24;
lbl242:
                // 1 sources

                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Unable to resolve type \"null\"");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_25 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                var9_25.fillInStackTrace();
                throw var9_25;
lbl253:
                // 1 sources

                var8_48 = new NamedTypeAccessor(this, var6_6, var5_5, var2_2, var7_7);
                var8_48.initMetadata();
                return var8_48;
            }
            case 111: {
                if (var6_6 != null) ** GOTO lbl281
                if (!var7_7) ** GOTO lbl270
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_26 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_26.fillInStackTrace();
                throw var9_26;
lbl270:
                // 1 sources

                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Unable to resolve type \"null\"");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_27 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                var9_27.fillInStackTrace();
                throw var9_27;
lbl281:
                // 1 sources

                var8_49 = new RefTypeAccessor(this, var6_6, var5_5, var2_2, var7_7);
                var8_49.initMetadata();
                return var8_49;
            }
            case 180: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl297
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_28 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_28.fillInStackTrace();
                throw var9_28;
lbl297:
                // 1 sources

                return new TimestampAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 181: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl311
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_29 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_29.fillInStackTrace();
                throw var9_29;
lbl311:
                // 1 sources

                return new TimestamptzAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 231: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl325
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_30 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_30.fillInStackTrace();
                throw var9_30;
lbl325:
                // 1 sources

                return new TimestampltzAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 182: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl339
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_31 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_31.fillInStackTrace();
                throw var9_31;
lbl339:
                // 1 sources

                return new IntervalymAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 183: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl353
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_32 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_32.fillInStackTrace();
                throw var9_32;
lbl353:
                // 1 sources

                return new IntervaldsAccessor(this, var4_4, var5_5, var2_2, var7_7);
            }
            case 995: {
                if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_33 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                var9_33.fillInStackTrace();
                throw var9_33;
            }
        }
        if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var9_34 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        var9_34.fillInStackTrace();
        throw var9_34;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnType(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.defineColumnTypeInternal(n2, n3, -1, true, null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnType(int n2, int n3, int n4) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.defineColumnTypeInternal(n2, n3, n4, false, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnType(int n2, int n3, int n4, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4) + ", " + OracleLog.argument(s2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.defineColumnTypeInternal(n2, n3, n4, s2, false, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnTypeBytes(int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + "call to defineColumnTypeBytes which is deprecated and may not behave as expected");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.defineColumnTypeInternal(n2, n3, n4, false, null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnTypeChars(int n2, int n3, int n4) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.defineColumnTypeInternal(n2, n3, n4, false, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnType(int n2, int n3, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.defineColumnTypeInternal(n2, n3, -1, true, string);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void setCursorId(int n2) throws SQLException {
        this.cursorId = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrefetchInternal(int n2, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n2 <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 20);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else {
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "setFetchSize");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 0) {
                n2 = this.connection.getDefaultRowPrefetch();
            }
        }
        if (bl2) {
            if (n2 != this.defaultRowPrefetch) {
                this.defaultRowPrefetch = n2;
                if (this.currentResultSet == null || this.currentResultSet.closed) {
                    this.rowPrefetchChanged = true;
                }
            }
        } else if (n2 != this.rowPrefetch && this.streamList == null) {
            this.rowPrefetch = n2;
            this.rowPrefetchChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowPrefetch(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setPrefetchInternal(n2, true, true);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLobPrefetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (n2 < -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 267);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.defaultLobPrefetchSize = n2;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobPrefetchSize() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultLobPrefetchSize);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.defaultLobPrefetchSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    int getPrefetchInternal(boolean bl) {
        int n2 = bl ? this.defaultRowPrefetch : this.rowPrefetch;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowPrefetch() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = this.getPrefetchInternal(true);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedString(boolean bl) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.fixedString = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFixedString() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fixedString);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.fixedString;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.rowPrefetchChanged) {
            if (this.streamList == null) {
                this.prepareAccessors();
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
    }

    void setDefinesInitialized(boolean bl) {
    }

    void printState(String string) throws SQLException {
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.validRows == -2) {
            this.validRows = 1;
            this.connection.holdLine(this);
            OracleInputStream oracleInputStream = this.streamList;
            while (oracleInputStream != null) {
                if (oracleInputStream.hasBeenOpen) {
                    oracleInputStream = oracleInputStream.accessor.initForNewRow();
                }
                oracleInputStream.closed = false;
                oracleInputStream.hasBeenOpen = true;
                oracleInputStream = oracleInputStream.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sqlKind.isSELECT()) {
            if (this.validRows < this.rowPrefetch) {
                this.gotLastBatch = true;
            }
        } else if (!this.sqlKind.isPlsqlOrCall()) {
            this.rowsProcessed = this.validRows;
        }
    }

    void cleanupDefines() {
        if (this.accessors != null) {
            for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                this.accessors[i2] = null;
            }
        }
        this.accessors = null;
        this.connection.cacheBuffer(this.defineBytes);
        this.defineBytes = null;
        this.connection.cacheBuffer(this.defineChars);
        this.defineChars = null;
        this.defineIndicators = null;
        this.defineMetaData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFieldSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxFieldSize);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.maxFieldSize;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (n2 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.maxFieldSize = n2;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRows() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxRows);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.maxRows;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (n2 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.maxRows = n2;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeProcessing(boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.processEscapes = bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryTimeout() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.queryTimeout);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.queryTimeout;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (n2 < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.queryTimeout = n2;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.doCancel();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancel() throws SQLException {
        boolean bl = false;
        if (this.closed) {
            return bl;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.cancelLock.enterCanceling()) {
            try {
                bl = true;
                this.connection.cancelOperationOnServer(true);
            }
            finally {
                this.cancelLock.exitCanceling();
            }
        } else {
            return bl;
        }
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            bl = bl || oracleStatement.doCancel();
            oracleStatement = oracleStatement.nextChild;
        }
        this.connection.releaseLineForCancel();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLWarning sQLWarning = this.sqlWarning;
            return sQLWarning;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sqlWarning = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foundPlsqlCompilerWarning() throws SQLException {
        SQLWarning sQLWarning = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
        if (this.sqlWarning != null) {
            this.sqlWarning.setNextWarning(sQLWarning);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + "found Plsql compile warning");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        } else {
            this.sqlWarning = sQLWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorName(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet getResultSet() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.userRsetType == 1) {
                    if (this.sqlKind.isSELECT()) {
                        if (this.currentResultSet == null) {
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentResultSet);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        OracleResultSetImpl oracleResultSetImpl = this.currentResultSet;
                        return oracleResultSetImpl;
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.scrollRset);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    OracleResultSet oracleResultSet = this.scrollRset;
                    return oracleResultSet;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ResultSet resultSet = null;
                return resultSet;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdateCount() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = -1;
                switch (this.sqlKind) {
                    case UNINITIALIZED: 
                    case SELECT_FOR_UPDATE: 
                    case SELECT: {
                        break;
                    }
                    case ALTER_SESSION: 
                    case OTHER: {
                        if (!this.noMoreUpdateCounts) {
                            n3 = this.rowsProcessed;
                        }
                        this.noMoreUpdateCounts = true;
                        break;
                    }
                    case PLSQL_BLOCK: 
                    case CALL_BLOCK: {
                        this.noMoreUpdateCounts = true;
                        break;
                    }
                    case DELETE: 
                    case INSERT: 
                    case MERGE: 
                    case UPDATE: {
                        if (!this.noMoreUpdateCounts) {
                            n3 = this.rowsProcessed;
                        }
                        this.noMoreUpdateCounts = true;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendBatch() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForNewResults(boolean bl, boolean bl2) throws SQLException {
        this.clearWarnings();
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (bl2) {
                OracleInputStream oracleInputStream = this.streamList;
                OracleInputStream oracleInputStream2 = null;
                this.streamList = null;
                while (oracleInputStream != null) {
                    if (!oracleInputStream.hasBeenOpen) {
                        if (oracleInputStream2 == null) {
                            this.streamList = oracleInputStream;
                        } else {
                            oracleInputStream2.nextStream = oracleInputStream;
                        }
                        oracleInputStream2 = oracleInputStream;
                    }
                    oracleInputStream = oracleInputStream.nextStream;
                }
            }
        }
        if (this.currentResultSet != null) {
            this.currentResultSet.internal_close(true);
            this.currentResultSet = null;
        }
        this.currentRow = -1;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.validRows = 0;
        if (bl) {
            this.totalRowsVisited = 0;
        }
        this.gotLastBatch = false;
        if (this.needToParse && !this.columnsDefinedByUser) {
            if (bl2 && this.numberOfDefinePositions != 0) {
                this.numberOfDefinePositions = 0;
            }
            this.needToPrepareDefineBuffer = true;
        }
        if (bl && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
            this.rowPrefetch = this.defaultRowPrefetch;
            this.rowPrefetchChanged = true;
        }
    }

    void reopenStreams() throws SQLException {
        OracleInputStream oracleInputStream = this.streamList;
        while (oracleInputStream != null) {
            if (oracleInputStream.hasBeenOpen) {
                oracleInputStream = oracleInputStream.accessor.initForNewRow();
            }
            oracleInputStream.closed = false;
            oracleInputStream.hasBeenOpen = true;
            oracleInputStream = oracleInputStream.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void endOfResultSet(boolean bl) throws SQLException {
        if (!bl) {
            this.prepareForNewResults(false, false);
        }
        this.clearDefines();
        this.rowPrefetchInLastFetch = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasNullValue() throws SQLException {
        if (this.lastIndex == 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 24);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.sqlKind.isSELECT()) {
            return this.accessors[this.lastIndex - 1].isNull(this.currentRow);
        }
        return this.outBindAccessors[this.lastIndex - 1].isNull(this.currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnIndex(String string) throws SQLException {
        Object object;
        this.ensureOpen();
        if (!this.describedWithNames) {
            object = this.connection;
            synchronized (object) {
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            if (!this.accessors[i2].columnName.equalsIgnoreCase(string)) continue;
            return i2 + 1;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    int getJDBCType(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case 6: {
                n3 = 2;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 96: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 12;
                break;
            }
            case 8: {
                n3 = -1;
                break;
            }
            case 12: {
                n3 = 91;
                break;
            }
            case 180: {
                n3 = 93;
                break;
            }
            case 181: {
                n3 = -101;
                break;
            }
            case 231: {
                n3 = -102;
                break;
            }
            case 182: {
                n3 = -103;
                break;
            }
            case 183: {
                n3 = -104;
                break;
            }
            case 23: {
                n3 = -2;
                break;
            }
            case 24: {
                n3 = -4;
                break;
            }
            case 104: {
                n3 = -8;
                break;
            }
            case 113: {
                n3 = 2004;
                break;
            }
            case 112: {
                n3 = 2005;
                break;
            }
            case 114: {
                n3 = -13;
                break;
            }
            case 102: {
                n3 = -10;
                break;
            }
            case 109: {
                n3 = 2002;
                break;
            }
            case 111: {
                n3 = 2006;
                break;
            }
            case 998: {
                n3 = -14;
                break;
            }
            case 995: {
                n3 = 0;
                break;
            }
            default: {
                n3 = n2;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInternalType(int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 100: {
                n3 = 100;
                break;
            }
            case 101: {
                n3 = 101;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 1: {
                n3 = 96;
                break;
            }
            case 12: {
                n3 = 1;
                break;
            }
            case -1: {
                n3 = 8;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case -100: 
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case -4: {
                n3 = 24;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case -10: {
                n3 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n3 = 109;
                break;
            }
            case 2006: {
                n3 = 111;
                break;
            }
            case -14: {
                n3 = 998;
                break;
            }
            case 70: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 995;
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + Integer.toString(n2));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString(n2));
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (!this.described) {
                this.doDescribe(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUsedStreams(int n2) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n2) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureOpen() throws SQLException {
        if (this.connection.lifecycle != 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void allocateTmpByteArray() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block24: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (n2 == 1000) {
                        this.defaultFetchDirection = n2;
                        break block24;
                    }
                    if (n2 == 1001 || n2 == 1002) {
                        this.defaultFetchDirection = 1000;
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                        break block24;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "setFetchDirection");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                finally {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultFetchDirection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.defaultFetchDirection;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setPrefetchInternal(n2, false, true);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.getPrefetchInternal(true);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetConcurrency() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ResultSetUtil.getUpdateConcurrency(this.userRsetType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ResultSetUtil.getScrollType(this.userRsetType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = this.connection.getWrapper();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleConnection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection2 = oracleConnection;
            return oracleConnection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSetCache(oracle.jdbc.OracleResultSetCache oracleResultSetCache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleResultSetCache));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                try {
                    if (oracleResultSetCache == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (this.rsetCache != null) {
                        this.rsetCache.close();
                    }
                    this.rsetCache = oracleResultSetCache;
                }
                catch (IOException iOException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleResultSetCache));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setResultSetCache((oracle.jdbc.OracleResultSetCache)oracleResultSetCache);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleResultSetCache getResultSetCache() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return (OracleResultSetCache)this.rsetCache;
        }
    }

    boolean isOracleBatchStyle() {
        return false;
    }

    void initBatch() {
    }

    int getBatchSize() {
        if (this.m_batchItems == null) {
            return 0;
        }
        return this.m_batchItems.size();
    }

    void addBatchItem(String string) {
        if (this.m_batchItems == null) {
            this.m_batchItems = new Vector();
        }
        this.m_batchItems.addElement(string);
    }

    String getBatchItem(int n2) {
        return (String)this.m_batchItems.elementAt(n2);
    }

    void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 81 + "batch must be either executed or cleared");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.addBatchItem(string);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.clearBatchItems();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.cleanOldTempLobs();
                int n3 = 0;
                int n2 = this.getBatchSize();
                this.checkSum = 0L;
                this.checkSumComputationFailure = false;
                if (n2 <= 0) {
                    int[] nArray = new int[]{};
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nArray);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int[] nArray2 = nArray;
                    return nArray2;
                }
                int[] nArray = new int[n2];
                long l2 = 0L;
                if (this.dmsExecute != null) {
                    l2 = this.dmsExecute.start();
                }
                try {
                    this.connection.updateSystemContext();
                    this.ensureOpen();
                    this.prepareForNewResults(true, true);
                    int n4 = this.numberOfDefinePositions;
                    String string = this.sqlObject.getOriginalSql();
                    OracleStatement.SqlKind sqlKind = this.sqlKind;
                    this.noMoreUpdateCounts = false;
                    int n5 = 0;
                    try {
                        this.connection.registerHeartbeat();
                        this.connection.needLine();
                        for (n3 = 0; n3 < n2; ++n3) {
                            this.sqlObject.initialize(this.getBatchItem(n3));
                            this.sqlKind = this.sqlObject.getSqlKind();
                            if (this.connection.dmsUpdateSqlText()) {
                                this.dmsSqlText.update((Object)this.sqlObject.toString());
                            }
                            this.needToParse = true;
                            this.numberOfDefinePositions = 0;
                            this.rowsProcessed = 0;
                            this.currentRank = 1;
                            if (this.sqlKind.isSELECT()) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + 80 + "invalid SELECT batch command " + n3 + n3 + nArray);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(80, "invalid SELECT batch command " + n3, n3, nArray);
                                batchUpdateException.fillInStackTrace();
                                throw batchUpdateException;
                            }
                            if (!this.isOpen) {
                                this.connection.open(this);
                                this.isOpen = true;
                            }
                            int n6 = -1;
                            try {
                                if (this.queryTimeout != 0) {
                                    this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                }
                                this.cancelLock.enterExecuting();
                                this.executeForRows(false);
                                if (this.validRows > 0) {
                                    n5 += this.validRows;
                                }
                                n6 = this.validRows;
                            }
                            catch (SQLException sQLException) {
                                this.needToParse = true;
                                this.resetCurrentRowBinders();
                                throw sQLException;
                            }
                            finally {
                                if (this.queryTimeout != 0) {
                                    this.connection.getTimeout().cancelTimeout();
                                }
                                this.validRows = n5;
                                this.cancelLock.exitExecuting();
                                this.checkValidRowsStatus();
                            }
                            nArray[n3] = n6;
                            if (nArray[n3] >= 0) continue;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + 81 + "command return value " + nArray[n3] + n3 + nArray);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, "command return value " + nArray[n3], n3, nArray);
                            batchUpdateException.fillInStackTrace();
                            throw batchUpdateException;
                        }
                    }
                    catch (SQLException sQLException) {
                        if (sQLException instanceof BatchUpdateException) {
                            throw sQLException;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + 81 + sQLException.getMessage() + n3 + nArray);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, sQLException.getMessage(), n3, nArray);
                        batchUpdateException.fillInStackTrace();
                        throw batchUpdateException;
                    }
                    finally {
                        this.clearBatchItems();
                        this.numberOfDefinePositions = n4;
                        if (string != null) {
                            this.sqlObject.initialize(string);
                            this.sqlKind = sqlKind;
                        }
                        this.currentRank = 0;
                    }
                    this.connection.registerHeartbeat();
                }
                finally {
                    if (this.dmsExecute != null) {
                        this.dmsExecute.stop(l2);
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int[] nArray3 = nArray;
                return nArray3;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    public int copyBinds(Statement statement, int n2) throws SQLException {
        return 0;
    }

    public void notifyCloseRset() throws SQLException {
        this.scrollRset = null;
        this.endOfResultSet(false);
    }

    public String getOriginalSql() throws SQLException {
        return this.sqlObject.getOriginalSql();
    }

    void doScrollExecuteCommon() throws SQLException {
        if (this.scrollRset != null) {
            this.scrollRset.close();
            this.scrollRset = null;
        }
        if (!this.sqlKind.isSELECT()) {
            this.doExecuteWithTimeout();
            return;
        }
        if (!this.needToAddIdentifier) {
            this.doExecuteWithTimeout();
            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
            this.realRsetType = this.userRsetType;
        } else {
            try {
                this.sqlObject.setIncludeRowid(true);
                this.needToParse = true;
                this.prepareForNewResults(true, false);
                if (this.columnsDefinedByUser) {
                    Accessor[] accessorArray = this.accessors;
                    if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                        this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                    }
                    if (accessorArray != null) {
                        for (int i2 = this.numberOfDefinePositions; i2 > 0; --i2) {
                            Accessor accessor;
                            this.accessors[i2] = accessor = accessorArray[i2 - 1];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i2);
                        }
                    }
                    this.allocateRowidAccessor();
                    ++this.numberOfDefinePositions;
                }
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.realRsetType = this.userRsetType;
            }
            catch (SQLException sQLException) {
                this.realRsetType = this.userRsetType > 3 ? 3 : 1;
                this.sqlObject.setIncludeRowid(false);
                this.needToParse = true;
                this.prepareForNewResults(true, false);
                if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = true;
                    --this.numberOfDefinePositions;
                    System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                    this.accessors[this.numberOfDefinePositions] = null;
                    for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                        Accessor accessor = this.accessors[i3];
                        if (!accessor.isColumnNumberAware) continue;
                        accessor.updateColumnNumber(i3);
                    }
                }
                this.moveAllTempLobsToFree();
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, sQLException.getMessage());
            }
        }
        this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.scrollRset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDmlReturningBind() throws SQLException {
        if (this.returnResultSet != null) {
            this.returnResultSet.close();
        }
        this.returnParamsFetched = false;
        this.returnParamRowBytes = 0;
        this.returnParamRowChars = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            Accessor accessor = this.returnParamAccessors[i2];
            if (accessor == null) continue;
            ++n2;
            if (accessor.charLength > 0) {
                this.returnParamRowChars += accessor.charLength;
                continue;
            }
            this.returnParamRowBytes += accessor.byteLength;
        }
        if (this.isAutoGeneratedKey) {
            this.numReturnParams = n2;
        } else {
            if (this.numReturnParams <= 0) {
                this.numReturnParams = this.sqlObject.getReturnParameterCount();
            }
            if (this.numReturnParams != n2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 173);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        this.returnParamMeta[0] = this.numReturnParams;
        this.returnParamMeta[1] = this.returnParamRowBytes;
        this.returnParamMeta[2] = this.returnParamRowChars;
    }

    void allocateDmlReturnStorage() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int n2 = this.returnParamRowBytes * this.rowsDmlReturned;
        int n3 = this.returnParamRowChars * this.rowsDmlReturned;
        int n4 = 2 * this.numReturnParams * this.rowsDmlReturned;
        this.returnParamBytes = new byte[n2];
        this.returnParamChars = new char[n3];
        this.returnParamIndicators = new short[n4];
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            Accessor accessor = this.returnParamAccessors[i2];
            if (accessor == null || accessor.internalType != 111 && accessor.internalType != 109) continue;
            TypeAccessor typeAccessor = (TypeAccessor)accessor;
            if (typeAccessor.pickledBytes != null && typeAccessor.pickledBytes.length >= this.rowsDmlReturned) continue;
            typeAccessor.pickledBytes = new byte[this.rowsDmlReturned][];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchDmlReturnParams() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void setupReturnParamAccessors() {
        if (this.rowsDmlReturned == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.numReturnParams * this.rowsDmlReturned;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            Accessor accessor = this.returnParamAccessors[i2];
            if (accessor == null) continue;
            if (accessor.charLength > 0) {
                accessor.rowSpaceChar = this.returnParamChars;
                accessor.columnIndex = n3;
                n3 += this.rowsDmlReturned * accessor.charLength;
            } else {
                accessor.rowSpaceByte = this.returnParamBytes;
                accessor.columnIndex = n2;
                n2 += this.rowsDmlReturned * accessor.byteLength;
            }
            accessor.rowSpaceIndicator = this.returnParamIndicators;
            accessor.indicatorIndex = n4;
            n4 += this.rowsDmlReturned;
            accessor.lengthIndex = n5;
            n5 += this.rowsDmlReturned;
        }
    }

    void registerReturnParameterInternal(int n2, int n3, int n4, int n5, short s2, String string) throws SQLException {
        if (this.returnParamAccessors == null) {
            this.returnParamAccessors = new Accessor[this.numberOfBindPositions];
        }
        if (this.returnParamMeta == null) {
            this.returnParamMeta = new int[3 + this.numberOfBindPositions * 4];
        }
        Accessor accessor = this.allocateAccessor(n3, n4, n2 + 1, n5, s2, string, true);
        accessor.isDMLReturnedParam = true;
        this.returnParamAccessors[n2] = accessor;
        boolean bl = accessor.charLength > 0;
        this.returnParamMeta[3 + n2 * 4 + 0] = accessor.defineType;
        this.returnParamMeta[3 + n2 * 4 + 1] = bl ? 1 : 0;
        this.returnParamMeta[3 + n2 * 4 + 2] = bl ? accessor.charLength : accessor.byteLength;
        this.returnParamMeta[3 + n2 * 4 + 3] = s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int creationState() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.creationState;
        }
    }

    public boolean isColumnSetNull(int n2) {
        return this.columnSetNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNCHAR(int n2) throws SQLException {
        try {
            boolean bl;
            int n3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.described) {
                this.describe();
            }
            if ((n3 = n2 - 1) < 0 || n3 >= this.numberOfDefinePositions) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = this.accessors[n3].formOfUse == 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void addChild(OracleStatement oracleStatement) {
        oracleStatement.nextChild = this.children;
        this.children = oracleStatement;
        oracleStatement.parent = this;
    }

    void removeChild(OracleStatement oracleStatement) {
        if (oracleStatement == this.children) {
            this.children = oracleStatement.nextChild;
        } else {
            OracleStatement oracleStatement2 = this.children;
            while (oracleStatement2.nextChild != oracleStatement) {
                oracleStatement2 = oracleStatement2.nextChild;
            }
            oracleStatement2.nextChild = oracleStatement.nextChild;
        }
        oracleStatement.parent = null;
        oracleStatement.nextChild = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isAutoGeneratedKey) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.returnParamAccessors == null || this.numReturnParams == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 144);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.returnResultSet == null) {
                this.returnResultSet = new OracleReturnResultSet(this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.returnResultSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleReturnResultSet oracleReturnResultSet = this.returnResultSet;
            return oracleReturnResultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.autoKeyInfo = new AutoKeyInfo(string);
            if (n2 == 2 || !this.autoKeyInfo.isInsertSqlStmt()) {
                this.autoKeyInfo = null;
                int n3 = this.executeUpdate(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n4 = n3;
                return n4;
            }
            if (n2 != 1) {
                this.autoKeyInfo = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                int n5 = this.executeUpdateInternal(string2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n5);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n6 = n5;
                return n6;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(nArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (nArray == null || nArray.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.autoKeyInfo = new AutoKeyInfo(string, nArray);
            if (!this.autoKeyInfo.isInsertSqlStmt()) {
                this.autoKeyInfo = null;
                int n2 = this.executeUpdate(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = n2;
                return n3;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = nArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                int n4 = this.executeUpdateInternal(string2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n4);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n5 = n4;
                return n5;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(stringArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
            if (!this.autoKeyInfo.isInsertSqlStmt()) {
                this.autoKeyInfo = null;
                int n2 = this.executeUpdate(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = n2;
                return n3;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = stringArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                int n4 = this.executeUpdateInternal(string2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n4);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n5 = n4;
                return n5;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.autoKeyInfo = new AutoKeyInfo(string);
            if (n2 == 2 || !this.autoKeyInfo.isInsertSqlStmt()) {
                this.autoKeyInfo = null;
                boolean bl = this.execute(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (n2 != 1) {
                this.autoKeyInfo = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                boolean bl = this.executeInternal(string2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl3 = bl;
                return bl3;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(nArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (nArray == null || nArray.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.autoKeyInfo = new AutoKeyInfo(string, nArray);
            if (!this.autoKeyInfo.isInsertSqlStmt()) {
                this.autoKeyInfo = null;
                boolean bl = this.execute(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = nArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                boolean bl = this.executeInternal(string2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl3 = bl;
                return bl3;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(stringArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.autoKeyInfo = new AutoKeyInfo(string, stringArray);
            if (!this.autoKeyInfo.isInsertSqlStmt()) {
                this.autoKeyInfo = null;
                boolean bl = this.execute(string);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.connection.doDescribeTable(this.autoKeyInfo);
                String string2 = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = stringArray.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                boolean bl = this.executeInternal(string2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl3 = bl;
                return bl3;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetHoldability() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public int getcacheState() {
        return this.cacheState;
    }

    public int getstatementType() {
        return this.statementType;
    }

    public boolean getserverCursor() {
        return this.serverCursor;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    private void autoKeyRegisterReturnParams() throws SQLException {
        this.initializeIndicatorSubRange();
        int n2 = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int n3 = n2 + 2 * this.numberOfBindPositions;
        this.bindIndicators = new short[n3];
        int n4 = this.bindIndicatorSubRange;
        this.bindIndicators[n4 + 0] = (short)this.numberOfBindPositions;
        this.bindIndicators[n4 + 1] = 0;
        this.bindIndicators[n4 + 2] = 1;
        this.bindIndicators[n4 + 3] = 0;
        this.bindIndicators[n4 + 4] = 1;
        n4 += 5;
        short[] sArray = this.autoKeyInfo.tableFormOfUses;
        int[] nArray = this.autoKeyInfo.columnIndexes;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            short s2;
            this.bindIndicators[n4 + 0] = 994;
            short s3 = s2 = this.connection.defaultnchar ? (short)2 : 1;
            if (sArray != null && nArray != null && sArray[nArray[i2] - 1] == 2) {
                this.bindIndicators[n4 + 9] = s2 = 2;
            }
            n4 += 10;
            this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[i2]);
            String string = null;
            if (this.autoKeyInfo.returnTypes[i2] == 111) {
                string = this.autoKeyInfo.tableTypeNames[nArray[i2] - 1];
            }
            this.registerReturnParameterInternal(i2, this.autoKeyInfo.returnTypes[i2], this.autoKeyInfo.returnTypes[i2], -1, s2, string);
        }
    }

    private final void setNonAutoKey() {
        this.isAutoGeneratedKey = false;
        this.numberOfBindPositions = 0;
        this.bindIndicators = null;
        this.returnParamMeta = null;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
        if (cArray != this.defineChars) {
            this.connection.cacheBuffer(cArray);
        }
        if (byArray != this.defineBytes) {
            this.connection.cacheBuffer(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkTypeForAutoKey(int n2) throws SQLException {
        if (n2 == 109) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 5);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 5);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void moveAllTempLobsToFree() {
        if (this.oldTempClobsToFree != null) {
            if (this.tempClobsToFree == null) {
                this.tempClobsToFree = this.oldTempClobsToFree;
            } else {
                this.tempClobsToFree.add(this.oldTempClobsToFree);
            }
            this.oldTempClobsToFree = null;
        }
        if (this.oldTempBlobsToFree != null) {
            if (this.tempBlobsToFree == null) {
                this.tempBlobsToFree = this.oldTempBlobsToFree;
            } else {
                this.tempBlobsToFree.add(this.oldTempBlobsToFree);
            }
            this.oldTempBlobsToFree = null;
        }
    }

    void moveTempLobsToFree(CLOB cLOB) {
        int n2;
        if (this.oldTempClobsToFree != null && (n2 = this.oldTempClobsToFree.indexOf(cLOB)) != -1) {
            this.addToTempLobsToFree(cLOB);
            this.oldTempClobsToFree.remove(n2);
        }
    }

    void moveTempLobsToFree(BLOB bLOB) {
        int n2;
        if (this.oldTempBlobsToFree != null && (n2 = this.oldTempBlobsToFree.indexOf(bLOB)) != -1) {
            this.addToTempLobsToFree(bLOB);
            this.oldTempBlobsToFree.remove(n2);
        }
    }

    void addToTempLobsToFree(CLOB cLOB) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(cLOB);
    }

    void addToTempLobsToFree(BLOB bLOB) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(bLOB);
    }

    void addToOldTempLobsToFree(CLOB cLOB) {
        if (this.oldTempClobsToFree == null) {
            this.oldTempClobsToFree = new ArrayList();
        }
        this.oldTempClobsToFree.add(cLOB);
    }

    void addToOldTempLobsToFree(BLOB bLOB) {
        if (this.oldTempBlobsToFree == null) {
            this.oldTempBlobsToFree = new ArrayList();
        }
        this.oldTempBlobsToFree.add(bLOB);
    }

    void cleanAllTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.tempClobsToFree = null;
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempBlobsToFree = null;
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.oldTempClobsToFree = null;
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempBlobsToFree = null;
    }

    void cleanOldTempLobs() {
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempClobsToFree = this.tempClobsToFree;
        this.tempClobsToFree = null;
        this.oldTempBlobsToFree = this.tempBlobsToFree;
        this.tempBlobsToFree = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    TimeZone getDefaultTimeZone() throws SQLException {
        return this.getDefaultTimeZone(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimeZone getDefaultTimeZone(boolean bl) throws SQLException {
        if (this.defaultTimeZone == null) {
            block7: {
                try {
                    this.defaultTimeZone = this.connection.getDefaultTimeZone();
                }
                catch (SQLException sQLException) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block7;
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception XXXXX " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (this.defaultTimeZone == null) {
                this.defaultTimeZone = TimeZone.getDefault();
            }
        }
        return this.defaultTimeZone;
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration databaseChangeRegistration) throws SQLException {
        this.registration = (NTFDCNRegistration)databaseChangeRegistration;
    }

    public String[] getRegisteredTableNames() throws SQLException {
        return this.dcnTableName;
    }

    public long getRegisteredQueryId() throws SQLException {
        return this.dcnQueryId;
    }

    Calendar getDefaultCalendar() throws SQLException {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone(), Locale.US);
        }
        return this.defaultCalendar;
    }

    void releaseBuffers() {
        this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
        this.cachedDefineMetaDataSize = this.defineMetaData != null ? this.defineMetaData.length : 0;
        this.connection.cacheBuffer(this.defineChars);
        this.defineChars = null;
        this.connection.cacheBuffer(this.defineBytes);
        this.defineBytes = null;
        this.defineIndicators = null;
        this.defineMetaData = null;
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    Calendar getGMTCalendar() {
        if (this.gmtCalendar == null) {
            this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        }
        return this.gmtCalendar;
    }

    void extractNioDefineBuffers(int n2) throws SQLException {
    }

    void processLobPrefetchMetaData(Object[] objectArray) {
    }

    void internalClose() throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.cleanupDefines();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.outBindAccessors = null;
        this.parameterStream = null;
        this.userStream = null;
        this.ibtBindBytes = null;
        this.ibtBindChars = null;
        this.ibtBindIndicators = null;
        this.lobPrefetchMetaData = null;
        this.tmpByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (this.wrapper != null) {
            this.wrapper.close();
        }
    }

    void calculateCheckSum() throws SQLException {
        if (!this.connection.calculateChecksum) {
            return;
        }
        this._checkSum = this.checkSum;
        if (this.accessors != null) {
            this.accessorChecksum(this.accessors);
        }
        if (this.outBindAccessors != null) {
            this.accessorChecksum(this.outBindAccessors);
        }
        if (this.returnParamAccessors != null && this.returnParamsFetched) {
            this.accessorChecksum(this.returnParamAccessors);
        }
        this.checkSum = this._checkSum = CRC64.updateChecksum(this._checkSum, this.validRows);
        this._checkSum = 0L;
    }

    void accessorChecksum(Accessor[] accessorArray) throws SQLException {
        int n2 = 0;
        boolean bl = false;
        block4: for (Accessor accessor : accessorArray) {
            if (accessor == null) continue;
            switch (accessor.internalType) {
                case 112: 
                case 113: 
                case 114: {
                    if (n2 != 0) continue block4;
                    bl = true;
                    continue block4;
                }
                case 8: 
                case 24: {
                    bl = false;
                    break block4;
                }
                default: {
                    bl = false;
                    ++n2;
                    for (int i2 = 0; i2 < this.validRows; ++i2) {
                        if (accessor.rowSpaceIndicator == null) continue;
                        this._checkSum = accessor.updateChecksum(this._checkSum, i2);
                    }
                }
            }
        }
        if (bl) {
            this.checkSumComputationFailure = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChecksum() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.checkSumComputationFailure) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            long l2 = this.checkSum;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = l2;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    static final byte convertSqlKindEnumToByte(OracleStatement.SqlKind sqlKind) {
        switch (sqlKind) {
            case DELETE: {
                return 2;
            }
            case INSERT: {
                return 4;
            }
            case MERGE: {
                return 8;
            }
            case UPDATE: {
                return 16;
            }
            case ALTER_SESSION: 
            case OTHER: {
                return -128;
            }
            case PLSQL_BLOCK: {
                return 32;
            }
            case CALL_BLOCK: {
                return 64;
            }
            case SELECT_FOR_UPDATE: 
            case SELECT: {
                return 1;
            }
        }
        if (sqlKind.isPlsqlOrCall()) {
            return 96;
        }
        if (sqlKind.isDML()) {
            return 30;
        }
        return 0;
    }

    static final OracleStatement.SqlKind convertSqlKindByteToEnum(byte by) {
        switch (by) {
            case 2: {
                return OracleStatement.SqlKind.DELETE;
            }
            case 4: {
                return OracleStatement.SqlKind.INSERT;
            }
            case 8: {
                return OracleStatement.SqlKind.MERGE;
            }
            case 16: {
                return OracleStatement.SqlKind.UPDATE;
            }
            case -128: {
                return OracleStatement.SqlKind.OTHER;
            }
            case 32: {
                return OracleStatement.SqlKind.PLSQL_BLOCK;
            }
            case 64: {
                return OracleStatement.SqlKind.CALL_BLOCK;
            }
            case 1: {
                return OracleStatement.SqlKind.SELECT;
            }
        }
        return OracleStatement.SqlKind.UNINITIALIZED;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

