/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

abstract class OracleInputStream
extends OracleBufferedStream {
    int columnIndex;
    Accessor accessor;
    OracleInputStream nextStream;
    boolean hasBeenOpen = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, oracleStatement.connection.getDefaultStreamChunkSize());
        this.closed = true;
        this.statement = oracleStatement;
        this.columnIndex = n2;
        this.accessor = accessor;
        this.nextStream = null;
        OracleInputStream oracleInputStream = this.statement.streamList;
        if (oracleInputStream == null || this.columnIndex < oracleInputStream.columnIndex) {
            this.nextStream = this.statement.streamList;
            this.statement.streamList = this;
        } else if (this.columnIndex == oracleInputStream.columnIndex) {
            this.nextStream = oracleInputStream.nextStream;
            oracleInputStream.nextStream = null;
            this.statement.streamList = this;
        } else {
            while (oracleInputStream.nextStream != null && this.columnIndex > oracleInputStream.nextStream.columnIndex) {
                oracleInputStream = oracleInputStream.nextStream;
            }
            if (oracleInputStream.nextStream != null && this.columnIndex == oracleInputStream.nextStream.columnIndex) {
                this.nextStream = oracleInputStream.nextStream.nextStream;
                oracleInputStream.nextStream.nextStream = null;
                oracleInputStream.nextStream = this;
            } else {
                this.nextStream = oracleInputStream.nextStream;
                oracleInputStream.nextStream = this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "OIS@" + Integer.toHexString(this.hashCode()) + "{" + "statement = " + this.statement + ", accessor = " + this.accessor + ", nextStream = " + this.nextStream + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needBytes(int n2) throws IOException {
        try {
            int n3;
            block47: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.pos >= this.count) {
                    if (n2 > this.currentBufferSize) {
                        this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                        this.resizableBuffer = new byte[this.currentBufferSize];
                    }
                    try {
                        n3 = this.getBytes(this.currentBufferSize);
                        this.pos = 0;
                        this.count = n3;
                        if (this.count != -1) break block47;
                        if (this.nextStream == null) {
                            this.statement.connection.releaseLine();
                        }
                        this.closed = true;
                        this.accessor.fetchNextColumns();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (SQLException sQLException) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        IOException iOException = DatabaseError.createIOException(sQLException);
                        iOException.fillInStackTrace();
                        throw iOException;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n3 = 1;
            return n3 != 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            try {
                bl = this.accessor.isNull(0);
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.closed);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.closed;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!this.closed && this.hasBeenOpen) {
                    while (this.statement.nextStream != this) {
                        this.statement.nextStream.close();
                        this.statement.nextStream = this.statement.nextStream.nextStream;
                    }
                    if (!this.isNull()) {
                        while (this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize))) {
                            this.pos = this.count;
                        }
                    }
                    this.closed = true;
                    this.resizableBuffer = null;
                    this.currentBufferSize = 0;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    public abstract int getBytes(int var1) throws IOException;

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

