/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    DateTimeCommonAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            TimeZone timeZone = this.statement.getDefaultTimeZone();
            if (timeZone != epochTimeZone) {
                epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(timeZone);
                epochTimeZone = timeZone;
            }
            time = new Time((long)this.oracleTime(n3) - epochTimeZoneOffset);
        }
        return time;
    }

    Date getDate(int n2) throws SQLException {
        return this.getDate(n2, this.statement.getDefaultCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date getDate(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getDate(n2);
        }
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = this.oracleYear(n3);
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.set(n4, this.oracleMonth(n3), this.oracleDay(n3), 0, 0, 0);
            calendar2.set(14, 0);
            if (n4 > 0 && calendar2.isSet(0)) {
                calendar2.set(0, 1);
            }
            date = new Date(calendar2.getTimeInMillis());
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Time getTime(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTime(n2);
        }
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = this.oracleYear(n3);
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.set(1, 1970);
            calendar2.set(2, 0);
            calendar2.set(5, 1);
            calendar2.set(11, this.oracleHour(n3));
            calendar2.set(12, this.oracleMin(n3));
            calendar2.set(13, this.oracleSec(n3));
            calendar2.set(14, 0);
            if (n4 > 0 && calendar2.isSet(0)) {
                calendar2.set(0, 1);
            }
            time = new Time(calendar2.getTimeInMillis());
        }
        return time;
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp(n2, this.statement.getDefaultCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestamp(n2);
        }
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = this.oracleYear(n3);
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.set(n4, this.oracleMonth(n3), this.oracleDay(n3), this.oracleHour(n3), this.oracleMin(n3), this.oracleSec(n3));
            calendar2.set(14, 0);
            if (n4 > 0 && calendar2.isSet(0)) {
                calendar2.set(0, 1);
            }
            timestamp = new Timestamp(calendar2.getTimeInMillis());
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            if (s2 >= 11) {
                timestamp.setNanos(this.oracleNanos(n3));
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[7];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, 7);
            dATE = new DATE(byArray);
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateTimeCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            tIMESTAMP = new TIMESTAMP(byArray);
        }
        return tIMESTAMP;
    }

    final int oracleYear(int n2) {
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        return n3 <= 0 ? n3 + 1 : n3;
    }

    final int oracleMonth(int n2) {
        return this.rowSpaceByte[2 + n2] - 1;
    }

    final int oracleDay(int n2) {
        return this.rowSpaceByte[3 + n2];
    }

    final int oracleHour(int n2) {
        return this.rowSpaceByte[4 + n2] - 1;
    }

    final int oracleMin(int n2) {
        return this.rowSpaceByte[5 + n2] - 1;
    }

    final int oracleSec(int n2) {
        return this.rowSpaceByte[6 + n2] - 1;
    }

    final int oracleTZ1(int n2) {
        return this.rowSpaceByte[11 + n2];
    }

    final int oracleTZ2(int n2) {
        return this.rowSpaceByte[12 + n2];
    }

    final int oracleTime(int n2) {
        int n3 = this.oracleHour(n2);
        n3 *= 60;
        n3 += this.oracleMin(n2);
        n3 *= 60;
        n3 += this.oracleSec(n2);
        return n3 *= 1000;
    }

    final int oracleNanos(int n2) {
        int n3 = (this.rowSpaceByte[7 + n2] & 0xFF) << 24;
        n3 |= (this.rowSpaceByte[8 + n2] & 0xFF) << 16;
        n3 |= (this.rowSpaceByte[9 + n2] & 0xFF) << 8;
        return n3 |= this.rowSpaceByte[10 + n2] & 0xFF & 0xFF;
    }

    static final long computeJulianDay(boolean bl, int n2, int n3, int n4) {
        boolean bl2 = n2 % 4 == 0;
        int n5 = n2 - 1;
        long l2 = 365L * (long)n5 + DateTimeCommonAccessor.floorDivide(n5, 4L) + 1721423L;
        if (bl) {
            bl2 = bl2 && (n2 % 100 != 0 || n2 % 400 == 0);
            l2 += DateTimeCommonAccessor.floorDivide(n5, 400L) - DateTimeCommonAccessor.floorDivide(n5, 100L) + 2L;
        }
        return l2 + (long)n4 + (long)(bl2 ? LEAP_NUM_DAYS[n3] : NUM_DAYS[n3]);
    }

    static final long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    static final long julianDayToMillis(long l2) {
        return (l2 - 2440588L) * 86400000L;
    }

    static final long zoneOffset(TimeZone timeZone, int n2, int n3, int n4, int n5, int n6) {
        return timeZone.getOffset(n2 < 0 ? 0 : 1, n2, n3, n4, n5, n6);
    }

    static long getMillis(int n2, int n3, int n4, int n5, TimeZone timeZone) {
        long l2;
        long l3;
        boolean bl = n2 >= 1582;
        if (bl != (l3 = ((l2 = DateTimeCommonAccessor.computeJulianDay(bl, n2, n3, n4)) - 2440588L) * 86400000L) >= -12219292800000L) {
            l2 = DateTimeCommonAccessor.computeJulianDay(!bl, n2, n3, n4);
            l3 = (l2 - 2440588L) * 86400000L;
        }
        return (l3 += (long)n5) - DateTimeCommonAccessor.zoneOffset(timeZone, n2, n3, n4, DateTimeCommonAccessor.julianDayToDayOfWeek(l2), n5);
    }

    static final int julianDayToDayOfWeek(long l2) {
        int n2;
        return n2 + ((n2 = (int)((l2 + 1L) % 7L)) < 0 ? 8 : 1);
    }

    static long calculateEpochOffset(TimeZone timeZone) {
        return DateTimeCommonAccessor.zoneOffset(timeZone, 1970, 0, 1, 5, 0);
    }

    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        return oracle.sql.TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, n8, string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DateTimeCommonAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

