/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Base64;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;

class WebSocket {
    private static final String OnsWebSockGUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final int OnsWebSockSizeBase = 2;
    private static final int OnsWebSockSizeExtS = 2;
    private static final int OnsWebSockSizeExtL = 8;
    private static final int OnsWebSockSizeMask = 4;
    private static final int OnsWebSockLenLimit = 125;
    private static final int OnsWebSockLenCodeExtS = 126;
    private static final int OnsWebSockLenCodeExtL = 127;
    private static final int OnsWebSockLenExtSLimit = 16383;
    private static final int OnsWebSockCtrl1Fin = 1;
    private static final int OnsWebSockCtrl1Reserved = 14;
    private static final int OnsWebSockCtrl1OpCode = 240;
    private static final int OnsWebSockCtrl2Mask = 1;
    private static final int OnsWebSockCtrl2Len = 254;
    private static final int OnsWebSockOpCodeText = 16;
    private static final int OnsWebSockOpCodeBinary = 32;
    private static final int OnsWebSockShiftLen = 1;
    private static final int OnsWebSockFrameNone = 0;
    private static final int OnsWebSockFrameCtrl1 = 1;
    private static final int OnsWebSockFrameCtrl2 = 2;
    private static final int OnsWebSockFrameExtS1 = 3;
    private static final int OnsWebSockFrameExtS2 = 4;
    private static final int OnsWebSockFrameExtL1 = 5;
    private static final int OnsWebSockFrameExtL2 = 6;
    private static final int OnsWebSockFrameExtL3 = 7;
    private static final int OnsWebSockFrameExtL4 = 8;
    private static final int OnsWebSockFrameExtL5 = 9;
    private static final int OnsWebSockFrameExtL6 = 10;
    private static final int OnsWebSockFrameExtL7 = 11;
    private static final int OnsWebSockFrameExtL8 = 12;
    private static final int OnsWebSockFrameMask1 = 13;
    private static final int OnsWebSockFrameMask2 = 14;
    private static final int OnsWebSockFrameMask3 = 15;
    private static final int OnsWebSockFrameMask4 = 16;
    private static final int OnsWebSockFrameDone = 17;
    private static final int ONS_FNV_1A_OFFSET = -2128831035;
    private static final String ONSOraProxyHost = "(http_proxy=";
    private static final String ONSOraProxyPort = "(http_proxy_port=";
    private static final String ONSOraProxyHostSSL = "(https_proxy=";
    private static final String ONSOraProxyPortSSL = "(https_proxy_port=";
    private static final String ONSOraProtocol = "(protocol=";
    private static final String ONSProtocolSuffix = "://";
    private static int stamp = 0;
    final boolean enabled;
    String proxyHostname;
    int proxyPort;
    boolean proxySSL;
    String key;
    String subjectCN = null;
    private int maskOut = 0;
    private int maskShiftOut = 0;
    private int maskIn = 0;
    private int maskShiftIn = 0;
    private int bytesRemainIn = 0;
    private int framePhaseIn = 0;
    private int frameSizeIn = 0;
    private int frameMaskIn = 0;
    private int frameCtrl1In = 0;
    private int frameCtrl2In = 0;
    int frameAvailIn = 0;

    WebSocket(boolean isEnabled) {
        this.proxyHostname = null;
        this.proxyPort = 0;
        this.proxySSL = false;
        this.enabled = isEnabled;
        if (isEnabled) {
            this.maskOut = WebSocket.getMask();
        }
    }

    WebSocket(String proxyConfig) {
        proxyConfig = proxyConfig.toLowerCase();
        int idx = proxyConfig.indexOf(40);
        if (idx != -1) {
            this.setProxyOra(proxyConfig);
        } else {
            idx = proxyConfig.indexOf(58);
            if (idx != -1) {
                this.setProxyUri(proxyConfig);
            } else {
                throw new IllegalArgumentException("Unknown syntax: " + proxyConfig);
            }
        }
        this.enabled = true;
        this.maskOut = WebSocket.getMask();
    }

    private void setProxyOra(String proxyConfig) {
        int end;
        boolean isSSL = false;
        int begin = (proxyConfig = proxyConfig.replaceAll("\\s", "")).indexOf(ONSOraProtocol);
        if (begin != -1) {
            end = proxyConfig.indexOf(41, begin += ONSOraProtocol.length());
            if (end == -1) {
                throw new IllegalArgumentException("Invalid protocol syntax");
            }
            String proto = proxyConfig.substring(begin, end);
            isSSL = WebSocket.parseProxyProto(proto);
        }
        this.proxySSL = isSSL;
        begin = proxyConfig.indexOf(ONSOraProxyHost);
        if (begin == -1) {
            begin = proxyConfig.indexOf(ONSOraProxyHostSSL);
            if (begin == -1) {
                throw new IllegalArgumentException("Missing host");
            }
            begin += ONSOraProxyHostSSL.length();
        } else {
            begin += ONSOraProxyHost.length();
        }
        end = proxyConfig.indexOf(41, begin);
        if (end == -1) {
            throw new IllegalArgumentException("Invalid host syntax");
        }
        this.proxyHostname = proxyConfig.substring(begin, end);
        begin = proxyConfig.indexOf(ONSOraProxyPort);
        if (begin == -1) {
            begin = proxyConfig.indexOf(ONSOraProxyPortSSL);
            if (begin == -1) {
                throw new IllegalArgumentException("Missing port");
            }
            begin += ONSOraProxyPortSSL.length();
        } else {
            begin += ONSOraProxyPort.length();
        }
        end = proxyConfig.indexOf(41, begin);
        if (end == -1) {
            throw new IllegalArgumentException("Invalid port syntax");
        }
        String port = proxyConfig.substring(begin, end);
        try {
            this.proxyPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid port value: " + port + ": " + nex.getMessage());
        }
    }

    private void setProxyUri(String proxyConfig) {
        int begin;
        boolean isSSL = false;
        int end = proxyConfig.indexOf(ONSProtocolSuffix);
        if (end != -1) {
            String proto = proxyConfig.substring(0, end);
            isSSL = WebSocket.parseProxyProto(proto);
            begin = end + ONSProtocolSuffix.length();
            end = proxyConfig.indexOf(58, begin);
        } else {
            begin = 0;
            end = proxyConfig.indexOf(58);
        }
        this.proxySSL = isSSL;
        if (end == -1) {
            throw new IllegalArgumentException("Missing port");
        }
        this.proxyHostname = proxyConfig.substring(begin, end);
        String port = proxyConfig.substring(++end);
        try {
            this.proxyPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException("Invalid port value: " + port + ": " + nex.getMessage());
        }
    }

    private static boolean parseProxyProto(String proto) {
        boolean isSSL = false;
        if (proto.equals("wss") || proto.equals("https") || proto.equals("tcps")) {
            isSSL = true;
        } else if (!(proto.equals("ws") || proto.equals("http") || proto.equals("tcp"))) {
            throw new IllegalArgumentException("Invalid protocol value: " + proto);
        }
        return isSSL;
    }

    private static int getMask() {
        long ms = System.currentTimeMillis();
        int shift = 0;
        int mVal = 0;
        while ((mVal = (int)(ms >>> shift & 0xFFFFFFFFFFFFFFFFL)) == 0 && (shift += 32) < 64) {
        }
        if (mVal == 0) {
            mVal = 16777619;
        }
        return mVal;
    }

    void setSubjectCN(String cn) {
        this.subjectCN = cn;
    }

    void setMaskOut() {
        this.maskOut *= -2128831035;
    }

    void createKey(NodeAddress address) {
        byte[] data = new byte[16];
        int index = 0;
        int hash = address.hashCode();
        data[index++] = (byte)(hash >>> 24 & 0xFF);
        data[index++] = (byte)(hash >>> 16 & 0xFF);
        data[index++] = (byte)(hash >>> 8 & 0xFF);
        data[index++] = (byte)(hash & 0xFF);
        hash = address.hostname.hashCode();
        data[index++] = (byte)(hash >>> 24 & 0xFF);
        data[index++] = (byte)(hash >>> 16 & 0xFF);
        data[index++] = (byte)(hash >>> 8 & 0xFF);
        data[index++] = (byte)(hash & 0xFF);
        hash = address.websocket.hashCode();
        data[index++] = (byte)(hash >>> 24 & 0xFF);
        data[index++] = (byte)(hash >>> 16 & 0xFF);
        data[index++] = (byte)(hash >>> 8 & 0xFF);
        data[index++] = (byte)(hash & 0xFF);
        hash = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
        data[index++] = (byte)(hash >>> 24 & 0xFF);
        data[index++] = (byte)(hash >>> 16 & 0xFF);
        data[index++] = (byte)(hash >>> 8 & 0xFF);
        data[index++] = (byte)(hash & 0xFF);
        byte[] digest = ONSConfiguration.getSha1Digest(data);
        this.key = Base64.getEncoder().encodeToString(digest);
    }

    String validateResponse(Notification resp) {
        if (this.key == null) {
            return "no recorded key";
        }
        String concatKey = this.key + OnsWebSockGUID;
        this.key = null;
        byte[] digest = ONSConfiguration.getSha1Digest(concatKey);
        String acceptKey = Base64.getEncoder().encodeToString(digest);
        String error = this.validateProp(resp, "Sec-WebSocket-Accept", acceptKey);
        if (error != null) {
            return error;
        }
        try {
            int code = Integer.parseInt(resp.getMethod());
            if (code != 101) {
                return "unexpected GET response: " + resp.getMethod();
            }
        }
        catch (NumberFormatException ex) {
            return "invalid GET response: " + resp.getMethod();
        }
        error = this.validateProp(resp, "Upgrade", "websocket");
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateProp(Notification resp, String name, String expected) {
        String value = resp.get(name);
        if (value == null) {
            return "response missing \"" + name + "\"";
        }
        if (!value.equals(expected)) {
            return "unexpected value for \"" + name + "\": " + value + "(" + expected + ")";
        }
        return null;
    }

    byte[] getFrame(int mSize) {
        int ctrl1 = 33;
        int ctrl2 = 1;
        int fSize = 6;
        this.maskShiftOut = 0;
        if (mSize <= 125) {
            ctrl2 |= mSize << 1 & 0xFE;
        } else if (mSize <= 16383) {
            ctrl2 |= 0xFC;
            fSize += 2;
        } else {
            ctrl2 |= 0xFE;
            fSize += 8;
        }
        byte[] frame = new byte[fSize];
        int index = 0;
        frame[index++] = (byte)(ctrl1 & 0xFF);
        frame[index++] = (byte)(ctrl2 & 0xFF);
        if (mSize > 125) {
            if (mSize <= 16383) {
                frame[index++] = (byte)(mSize >>> 8 & 0xFF);
                frame[index++] = (byte)(mSize & 0xFF);
            } else {
                frame[index++] = 0;
                frame[index++] = 0;
                frame[index++] = 0;
                frame[index++] = 0;
                frame[index++] = (byte)(mSize >>> 24 & 0xFF);
                frame[index++] = (byte)(mSize >>> 16 & 0xFF);
                frame[index++] = (byte)(mSize >>> 8 & 0xFF);
                frame[index++] = (byte)(mSize & 0xFF);
            }
        }
        frame[index++] = (byte)(this.maskOut >>> 24 & 0xFF);
        frame[index++] = (byte)(this.maskOut >>> 16 & 0xFF);
        frame[index++] = (byte)(this.maskOut >>> 8 & 0xFF);
        frame[index++] = (byte)(this.maskOut & 0xFF);
        return frame;
    }

    int parseFrame(byte[] buffer, int pos, int bend) {
        if (this.framePhaseIn != 17) {
            this.frameAvailIn = 0;
            pos = this.parseFrameHeader(buffer, pos, bend);
        }
        if (pos != bend) {
            int remain = bend - pos;
            if (remain >= this.bytesRemainIn) {
                this.frameAvailIn = this.bytesRemainIn;
                this.bytesRemainIn = 0;
                this.framePhaseIn = 0;
            } else {
                this.frameAvailIn = remain;
                this.bytesRemainIn -= remain;
            }
            if (this.maskIn != 0) {
                this.maskShiftIn = WebSocket.applyMask(buffer, pos, this.frameAvailIn, this.maskIn, this.maskShiftIn);
            }
        }
        return pos;
    }

    private int parseFrameHeader(byte[] buffer, int pos, int bend) {
        while (pos < bend && this.framePhaseIn != 17) {
            ++this.framePhaseIn;
            switch (this.framePhaseIn) {
                case 1: {
                    this.maskIn = 0;
                    this.maskShiftIn = 0;
                    this.bytesRemainIn = 0;
                    this.frameSizeIn = 0;
                    this.frameMaskIn = 0;
                    this.frameCtrl1In = buffer[pos] & 0xFF;
                    break;
                }
                case 2: {
                    this.frameCtrl2In = buffer[pos] & 0xFF;
                    int frameSize = this.frameCtrl2In >>> 1 & 0x7F;
                    if (frameSize <= 125) {
                        this.frameSizeIn = frameSize;
                        if ((this.frameCtrl2In & 1) != 0) {
                            this.framePhaseIn = 12;
                            break;
                        }
                        this.framePhaseIn = 16;
                        break;
                    }
                    if (frameSize == 126) {
                        this.framePhaseIn = 2;
                        break;
                    }
                    this.framePhaseIn = 4;
                    break;
                }
                case 3: {
                    this.frameSizeIn = buffer[pos] << 8 & 0xFF00;
                    break;
                }
                case 4: {
                    this.frameSizeIn |= buffer[pos] & 0xFF;
                    if ((this.frameCtrl2In & 1) != 0) {
                        this.framePhaseIn = 12;
                        break;
                    }
                    this.framePhaseIn = 16;
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.frameSizeIn = buffer[pos] << 24 & 0xFF000000;
                    break;
                }
                case 10: {
                    this.frameSizeIn |= buffer[pos] << 16 & 0xFF0000;
                    break;
                }
                case 11: {
                    this.frameSizeIn |= buffer[pos] << 8 & 0xFF00;
                    break;
                }
                case 12: {
                    this.frameSizeIn |= buffer[pos] & 0xFF;
                    if ((this.frameCtrl2In & 1) != 0) break;
                    this.framePhaseIn = 16;
                    break;
                }
                case 13: {
                    this.frameMaskIn = buffer[pos] << 24 & 0xFF000000;
                    break;
                }
                case 14: {
                    this.frameMaskIn |= buffer[pos] << 16 & 0xFF0000;
                    break;
                }
                case 15: {
                    this.frameMaskIn |= buffer[pos] << 8 & 0xFF00;
                    break;
                }
                case 16: {
                    this.frameMaskIn |= buffer[pos] & 0xFF;
                    break;
                }
                case 17: {
                    this.bytesRemainIn = this.frameSizeIn;
                    this.maskIn = this.frameMaskIn;
                    return pos;
                }
            }
            ++pos;
        }
        return pos;
    }

    String putString(String source) {
        long tick = Instant.now().getEpochSecond();
        int kCode = this.hashCode();
        int kStamp = WebSocket.getStamp();
        String key = String.format("%d%d%x", kStamp, kCode, tick);
        byte[] digest = ONSConfiguration.getSha1Digest(key);
        int pad = WebSocket.getPadLength(digest);
        int mask = WebSocket.getKeyMask(digest) * -2128831035;
        ByteBuffer bBuf = ByteBuffer.allocate(8);
        bBuf.putLong(tick);
        byte[] tickBytes = bBuf.array();
        WebSocket.applyMask(tickBytes, 0, 8, mask, 0);
        int bLen = digest.length + tickBytes.length + pad;
        byte[] sourceBytes = source.getBytes();
        byte[] base = new byte[bLen + sourceBytes.length];
        int bIndex = 0;
        System.arraycopy(digest, 0, base, bIndex, digest.length);
        System.arraycopy(tickBytes, 0, base, bIndex += digest.length, tickBytes.length);
        bIndex += tickBytes.length;
        if (pad != 0) {
            byte[] padBytes = new byte[]{(byte)(tick >>> 8 & 0xFFL), (byte)(tick >>> 16 & 0xFFL), (byte)(tick & 0xFFL), (byte)(tick >>> 24 & 0xFFL), (byte)((kCode *= kStamp + 1) >>> 24 & 0xFF), (byte)(kCode >>> 16 & 0xFF), (byte)(kCode >>> 8 & 0xFF), (byte)(kCode & 0xFF)};
            System.arraycopy(padBytes, 0, base, bIndex, pad);
            bIndex += pad;
        }
        System.arraycopy(sourceBytes, 0, base, bIndex, sourceBytes.length);
        WebSocket.extMaskApply(base, bIndex, base, bLen, pad);
        return Base64.getEncoder().encodeToString(base);
    }

    void applyMaskOut(byte[] data) {
        this.maskShiftOut = WebSocket.applyMask(data, 0, data.length, this.maskOut, this.maskShiftOut);
    }

    private static int applyMask(byte[] data, int pos, int length, int mask, int begin) {
        int mShift = begin;
        for (int index = pos; index < length; ++index) {
            int value = data[index] & 0xFF;
            data[index] = (byte)((value ^= mask >>> mShift & 0xFF) & 0xFF);
            if ((mShift += 8) <= 24) continue;
            mShift = 0;
        }
        return mShift;
    }

    private static int getKeyMask(byte[] digest) {
        int d1 = digest[1] & 0xFF;
        int d5 = digest[5] & 0xFF;
        int d6 = digest[6] & 0xFF;
        int d8 = digest[8] & 0xFF;
        int d9 = digest[9] & 0xFF;
        int d14 = digest[14] & 0xFF;
        int d16 = digest[16] & 0xFF;
        int d19 = digest[19] & 0xFF;
        return d5 ^ d19 | (d8 ^ d9) << 8 | (d6 ^ d16) << 16 | (d1 ^ d14) << 24;
    }

    private static int getPadLength(byte[] digest) {
        int d0 = digest[0] & 0xFF;
        int d12 = digest[12] & 0xFF;
        return (d0 ^ d12) & 7;
    }

    private static void extMaskApply(byte[] data, int dStart, byte[] mask, int mSize, int offset) {
        int index1 = 0;
        int index2 = offset + 1;
        for (int indexD = dStart; indexD < data.length; ++indexD) {
            if (++index1 == mSize) {
                index1 = 0;
                ++index2;
            }
            if (++index2 >= mSize) {
                index2 = 0;
            }
            for (int count = 0; mask[index1] == mask[index2] && count < mSize; ++count) {
                if (++index2 != mSize) continue;
                index2 = 0;
            }
            int bMask = (mask[index1] ^ mask[index2]) & 0xFF;
            int value = data[indexD] & 0xFF;
            data[indexD] = (byte)((value ^= bMask) & 0xFF);
        }
    }

    private static synchronized int getStamp() {
        return ++stamp;
    }

    public int hashCode() {
        if (this.proxyHostname != null) {
            return this.proxyHostname.hashCode() + this.proxyPort * 28952557 + 6263;
        }
        if (this.enabled) {
            return 6263;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        WebSocket other;
        WebSocket webSocket = other = obj instanceof WebSocket ? (WebSocket)obj : null;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.proxyHostname == null && other.proxyHostname == null) {
            return true;
        }
        if (this.proxyHostname == null || other.proxyHostname == null) {
            return false;
        }
        return this.proxyPort == other.proxyPort && this.proxyHostname.equals(other.proxyHostname);
    }

    public String toString() {
        if (this.proxyHostname != null) {
            return String.format("%s:%d enabled", this.proxyHostname, this.proxyPort);
        }
        if (this.enabled) {
            return "enabled";
        }
        return "disabled";
    }
}

