/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.ons.CallBack;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Cli {
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private ONSConfiguration defaultONSConfig = null;
    private String defaultComponent = "";
    static final Pattern valuePairPrefix = Pattern.compile("^[a-zA-Z0-9\\-_]+=.*");
    static final Pattern propertyPrefix = Pattern.compile("^[a-zA-Z0-9\\-_]+:.*");
    private final Map<String, String> paramCache = new HashMap<String, String>();
    AtomicInteger processedEvents = new AtomicInteger(0);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private int generateId = 1;
    final Logger logger = Logger.getLogger(ONS.class.getCanonicalName());
    private final Map<String, Object> commandMap = new HashMap<String, Object>();

    public String[] unquoteParams(String cmd) {
        char[] buf = cmd.toCharArray();
        int state = 0;
        int start = 0;
        int save_state = 0;
        StringBuilder last = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        char qstate = '\u0000';
        block11: for (int i = 0; i < buf.length; ++i) {
            char c = buf[i];
            switch (state) {
                case 0: {
                    if (Character.isLetterOrDigit(c)) continue block11;
                    if (Character.isSpaceChar(c)) {
                        if (i - start > 0) {
                            if (last.length() > 0) {
                                last.append(buf, start, i - start);
                            } else {
                                result.add(new String(buf, start, i - start));
                            }
                        }
                        if (last.length() > 0) {
                            result.add(last.toString());
                            last = new StringBuilder();
                        }
                        start = i + 1;
                        continue block11;
                    }
                }
                case 1: {
                    if (c == '\"' || c == '\'') {
                        if (qstate == c) {
                            last.append(buf, start, i - start);
                            state = 0;
                            qstate = '\u0000';
                        } else {
                            qstate = c;
                            state = 1;
                        }
                        start = i + 1;
                        continue block11;
                    }
                    if (c != '\\') continue block11;
                    last.append(buf, start, i - start);
                    save_state = state;
                    state = 2;
                    continue block11;
                }
                case 2: {
                    state = save_state;
                    switch (c) {
                        case '\n': {
                            break;
                        }
                        case 'n': {
                            last.append('\n');
                            break;
                        }
                        case 'r': {
                            last.append('\r');
                            break;
                        }
                        case 't': {
                            last.append('\t');
                            break;
                        }
                        default: {
                            last.append(c);
                        }
                    }
                    start = i + 1;
                }
            }
        }
        if (buf.length - start > 0) {
            last.append(buf, start, buf.length - start);
        }
        if (last.length() > 0) {
            result.add(last.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private String getParam(String[] p, int i, String name, String defaultValue) throws CommandException {
        if (name != null) {
            String candidate;
            if (this.paramCache.isEmpty()) {
                for (String x : p) {
                    if (!valuePairPrefix.matcher(x).matches()) continue;
                    String[] pair = x.split("=", 2);
                    this.paramCache.put(pair[0].toLowerCase(), pair[1]);
                }
            }
            if ((candidate = this.paramCache.get(name.toLowerCase())) != null) {
                return candidate;
            }
        }
        if (i == -1) {
            if (defaultValue == null) {
                throw new CommandException(String.format("Parameter %s not found", name));
            }
            return defaultValue;
        }
        if (p.length <= i && defaultValue == null) {
            throw new CommandException(String.format("Parameter %d (%s) not found", i, name));
        }
        return p.length > i ? p[i] : defaultValue;
    }

    public Cli(String[] args) {
        this.commandMap.put("server", new CommandConnect());
        this.commandMap.put("connect", new CommandConnect());
        this.commandMap.put("delete", new CommandDeleteObject());
        this.commandMap.put("subscribe", new CommandCreateSubscriber());
        this.commandMap.put("publish", new CommandPublish());
        this.commandMap.put("test", new CommandTest());
        this.commandMap.put("help", new CommandHelp());
        HashMap<String, ICommand> subtree = new HashMap<String, ICommand>();
        this.commandMap.put("set", subtree);
        subtree.put("logger", new CommandSetLogger());
        subtree = new HashMap();
        this.commandMap.put("show", subtree);
        subtree.put("loggers", new CommandShowLoggers());
    }

    private ICommand getCommand(String[] line) throws CommandException {
        Object x = this.commandMap;
        int i = 0;
        while (x != null && x instanceof Map && line.length > i) {
            Map<String, Object> nx = x;
            x = nx.get(line[i++]);
        }
        if (x == null || !(x instanceof ICommand)) {
            throw new CommandException("Command not found");
        }
        return (ICommand)x;
    }

    private void execute(String[] params) throws CommandException {
        if (params.length == 0) {
            return;
        }
        this.getCommand(params).exec(params);
    }

    private void run() throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder commandAccumulator = null;
        new Timer("Statistic counter", true).scheduleAtFixedRate((TimerTask)new StatTask(), 1000L, 1000L);
        while (true) {
            String command;
            System.out.print("onscli>");
            String commandBit = input.readLine();
            if (commandBit == null) {
                System.out.println();
                break;
            }
            if (commandBit.equalsIgnoreCase("exit") || commandBit.equalsIgnoreCase("logout")) break;
            if (commandAccumulator != null) {
                commandAccumulator.append(commandBit);
            }
            if (commandBit.endsWith("\\")) {
                if (commandAccumulator != null) continue;
                commandAccumulator = new StringBuilder(commandBit);
                continue;
            }
            if (commandAccumulator != null) {
                command = commandAccumulator.toString();
                commandAccumulator = null;
            } else {
                command = commandBit;
            }
            this.paramCache.clear();
            try {
                this.execute(this.unquoteParams(command));
            }
            catch (CommandException e) {
                System.err.println(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            new Cli(args).run();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public class StatTask
    extends TimerTask {
        int oldcount = 0;

        @Override
        public void run() {
            int pe = Cli.this.processedEvents.get();
            if (pe != this.oldcount) {
                System.out.println(String.format("Processed %d events", pe - this.oldcount));
                this.oldcount = pe;
            }
        }
    }

    private class CommandShowLoggers
    implements ICommand {
        private CommandShowLoggers() {
        }

        @Override
        public void info(CommandHelp info) {
        }

        @Override
        public void exec(String[] params) throws CommandException {
            Enumeration<String> lst = LogManager.getLogManager().getLoggerNames();
            while (lst.hasMoreElements()) {
                Logger logger;
                String x = lst.nextElement();
                if (x == null || (logger = Logger.getLogger(x)) == null) continue;
                Level level = logger.getLevel();
                if (level == null) {
                    level = Level.ALL;
                }
                System.out.println(String.format("%s.level = %s", x, level.toString()));
            }
        }
    }

    private class CommandSetLogger
    implements ICommand {
        private CommandSetLogger() {
        }

        @Override
        public void info(CommandHelp info) {
        }

        @Override
        public void exec(String[] params) throws CommandException {
            String p = Cli.this.getParam(params, -1, "Level", "");
            if (!p.isEmpty()) {
                Level x = Level.parse(p.toUpperCase());
                Cli.this.logger.setLevel(x);
                if (Cli.this.logger.getHandlers().length == 0) {
                    Cli.this.logger.addHandler(new ConsoleHandler());
                }
                for (Handler h : Cli.this.logger.getHandlers()) {
                    h.setLevel(x);
                    System.out.println(h.getClass());
                }
            }
        }
    }

    private class CommandTest
    implements ICommand {
        private CommandTest() {
        }

        @Override
        public void info(CommandHelp info) {
        }

        @Override
        public void exec(String[] params) throws CommandException {
            for (String s : params) {
                System.out.println(s);
            }
        }
    }

    private class CommandMute
    implements ICommand {
        private CommandMute() {
        }

        @Override
        public void info(CommandHelp info) {
        }

        @Override
        public void exec(String[] params) throws CommandException {
        }
    }

    private class CommandConnect
    implements ICommand {
        private CommandConnect() {
        }

        @Override
        public void info(CommandHelp info) {
            info.root().item("name").text("connect");
            info.root().item("syntax").text("connect ConnectionString");
            info.root().item("info").text("Create an ONS configuration connection");
            info.root().item("parameter").push(info.item("name").text("ConnectionString")).push(info.item("desc").text("ONS configuration string, by default local ORACLE_HOME configuration is used"));
            info.root().item("example").push(info.item("text").text("connect \"nodes=127.0.0.1:4243\"")).push(info.item("desc").text("Connect to the given node"));
        }

        @Override
        public void exec(String[] params) throws CommandException {
            ONSConfiguration config;
            String connectString = Cli.this.getParam(params, 1, "ConnectionString", "local");
            if (connectString.toLowerCase().equals("local")) {
                config = ONSConfiguration.initDefaultConfig();
            } else if (connectString.toLowerCase().equals("home")) {
                String home = Cli.this.getParam(params, 2, "Home", System.getenv("ORACLE_HOME"));
                config = ONSConfiguration.getRemoteConfigFromHome(home);
            } else {
                config = ONSConfiguration.getRemoteConfigFromString(connectString);
            }
            NotificationNetwork network = config.getNetwork();
            network.lazyDemand();
            try {
                network.waitUntilOnline();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            String connectionId = Integer.toString(Cli.this.generateId++);
            Cli.this.objects.put(connectionId, config);
            Cli.this.defaultONSConfig = config;
            System.err.println(String.format("ONS configuration %s added", connectionId));
        }
    }

    private class CommandPublish
    implements ICommand {
        private CommandPublish() {
        }

        @Override
        public void info(CommandHelp info) {
            info.root().item("name").text("publish");
            info.root().item("syntax").text("publish *Verb {Parameters}");
            info.root().item("info").text("Create an ONS Notification and publishes it with the given configuration");
            info.root().item("parameter").push(info.item("name").text("Verb")).push(info.item("desc").text("(required) ONS message type (Should be 'event' for notifications)"));
            info.root().item("parameter").push(info.item("name").text("Component")).push(info.item("desc").text("Component name to use. Empty by default"));
            info.root().item("parameter").push(info.item("name").text("Body")).push(info.item("desc").text("Message payload, ASCII only currently supported"));
            info.root().item("parameter").push(info.item("name").text("ONS")).push(info.item("desc").text("ONS configuration to use, by default local ORACLE_HOME configuration is used"));
            info.root().item("example").push(info.item("text").text("publish event p1:34 Body=HELLOWORLD ons=2 component=onsTestComponent")).push(info.item("desc").text("publish an event with parameter p1=34 and given body from ons config 2"));
        }

        @Override
        public void exec(String[] params) throws CommandException {
            Publisher p;
            ONSConfiguration config;
            String configName = Cli.this.getParam(params, -1, "ONS", "default");
            String componentName = Cli.this.getParam(params, -1, "Component", Cli.this.defaultComponent);
            String body = Cli.this.getParam(params, -1, "Body", "");
            String verb = Cli.this.getParam(params, 1, null, null);
            Object pobj = Cli.this.objects.get(configName);
            ONSConfiguration oNSConfiguration = configName.equals("default") ? Cli.this.defaultONSConfig : (config = pobj instanceof ONSConfiguration ? (ONSConfiguration)pobj : null);
            if (config == null) {
                System.err.println("WARNING: using local home configuration");
                p = new Publisher(componentName);
            } else {
                p = new Publisher(config.getNetwork(), componentName);
            }
            Notification notification = body.isEmpty() ? new Notification(verb) : new Notification(verb, null, null, body.getBytes());
            for (String x : params) {
                if (!propertyPrefix.matcher(x).matches()) continue;
                String[] pair = x.split(":", 2);
                notification.put(pair[0].toLowerCase(), pair[1]);
            }
            p.publish(notification);
            p.close();
        }
    }

    private class CommandDeleteObject
    implements ICommand {
        private CommandDeleteObject() {
        }

        @Override
        public void info(CommandHelp info) {
        }

        @Override
        public void exec(String[] params) throws CommandException {
            String connectionId = Cli.this.getParam(params, 1, null, null);
            Object obj = Cli.this.objects.get(connectionId);
            if (obj == null) {
                throw new CommandException("Object not found");
            }
            Cli.this.objects.remove(connectionId);
            if (obj instanceof SubscriberHolder) {
                ((SubscriberHolder)obj).s.close();
            }
        }
    }

    private class CommandCreateSubscriber
    implements ICommand {
        private CommandCreateSubscriber() {
        }

        @Override
        public void info(CommandHelp info) {
            info.root().item("name").text("subscribe");
            info.root().item("syntax").text("subscribe {Subscription}");
            info.root().item("info").text("Create an ONS Subscriber with the given subscription string");
            info.root().item("parameter").push(info.item("name").text("Subscription")).push(info.item("desc").text("Subscription string (transitive)"));
            info.root().item("parameter").push(info.item("name").text("Output")).push(info.item("desc").text("URL of the container to output notifications. '-' (default) stands for standard output. Note, that stdout will affect command input."));
            info.root().item("parameter").push(info.item("name").text("ONS")).push(info.item("desc").text("ONS configuration to use, by default local ORACLE_HOME configuration is used"));
            info.root().item("parameter").push(info.item("name").text("Connect")).push(info.item("desc").text("ONS Connection string"));
            info.root().item("example").push(info.item("text").text("subscribe \\'xevent\\' ons=2 component=onsTestComponent")).push(info.item("desc").text("subscribe to notifications with eventType=xevent to "));
            info.root().item("example").push(info.item("text").text("subscribe ons=2 component=onsTestComponent subscribe=\\'xevent\\'")).push(info.item("desc").text("alternative syntax for the latter"));
            info.root().item("example").push(info.item("text").text("subscribe subscribe=\\'event-1\\' output=file:out.txt")).push(info.item("desc").text("Subscribe to event-1 and send all the output to out.txt"));
        }

        @Override
        public void exec(String[] params) throws CommandException {
            String subscriptionString = Cli.this.getParam(params, 1, "Subscription", null);
            String configName = Cli.this.getParam(params, -1, "ONS", "default");
            String connect = Cli.this.getParam(params, -1, "Connect", "");
            String output = Cli.this.getParam(params, -1, "Output", "-");
            Boolean async = Boolean.parseBoolean(Cli.this.getParam(params, -1, "Async", "false"));
            Boolean system = Boolean.parseBoolean(Cli.this.getParam(params, -1, "System", "false"));
            Boolean dobody = Boolean.parseBoolean(Cli.this.getParam(params, -1, "ShowBody", "false"));
            ONSConfiguration config = null;
            if (connect.isEmpty()) {
                Object pobj = Cli.this.objects.get(configName);
                config = configName.equals("default") ? Cli.this.defaultONSConfig : (pobj instanceof ONSConfiguration ? (ONSConfiguration)pobj : null);
            }
            SubscriberHolder obj = new SubscriberHolder();
            obj.showBody = dobody;
            if (output.equals("-")) {
                obj.output = new OutputStreamWriter(System.out);
            } else {
                try {
                    URL outputUrl = new URL(output);
                    obj.output = outputUrl.getProtocol().toLowerCase().equals("file") ? new OutputStreamWriter(new FileOutputStream(outputUrl.getFile())) : new OutputStreamWriter(outputUrl.openConnection().getOutputStream());
                }
                catch (IOException e) {
                    throw new CommandException("Could not open output stream : " + e.getMessage());
                }
            }
            if (config == null && connect.isEmpty()) {
                System.err.println("WARNING: using local home configuration");
                config = ONSConfiguration.getDefaultConfig();
            }
            if (async.booleanValue()) {
                obj.s = connect.isEmpty() ? Subscriber.backgroundSubscriber(config, subscriptionString, (CallBack)obj) : Subscriber.backgroundSubscriber(connect, subscriptionString, (CallBack)obj);
                obj.s.setWantSystemNotifications(system);
            } else {
                if (!connect.isEmpty()) {
                    config = new ONSConfiguration(connect);
                }
                obj.s = new Subscriber(config, subscriptionString, obj);
                obj.s.setWantSystemNotifications(system);
                try {
                    obj.s.waitUntilRegistered();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            String connectionId = Integer.toString(Cli.this.generateId++);
            Cli.this.objects.put(connectionId, obj);
            System.err.println(String.format("Subscriber %s added", connectionId));
        }
    }

    private class CommandHelp
    implements ICommand {
        Document doc;
        Element root;
        DocumentBuilder docBuilder;

        void newContext() {
            try {
                this.docBuilder = factory.newDocumentBuilder();
                this.doc = this.docBuilder.newDocument();
                this.root = this.doc.createElement("help");
                this.doc.appendChild(this.root);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private CommandHelp() {
            this.newContext();
        }

        public NodeBuilder root() {
            return new NodeBuilder(this.root);
        }

        public NodeBuilder item(String name) {
            return new NodeBuilder(this.doc.createElement(name));
        }

        @Override
        public void info(CommandHelp info) {
            info.root().item("name").text("help");
            info.root().item("syntax").text("help [command]");
            info.root().item("info").text("Prints help message on command and it's parameters");
        }

        public void printCommands(Map<String, Object> tree) {
            for (Map.Entry<String, Object> x : tree.entrySet()) {
                if (x.getValue() instanceof Map) {
                    Map value = (Map)x.getValue();
                    this.printCommands(value);
                    continue;
                }
                if (!(x.getValue() instanceof ICommand)) continue;
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                this.newContext();
                ((ICommand)x.getValue()).info(this);
                System.out.print("  ");
                System.out.print(x.getKey());
                System.out.print("\n    ");
                try {
                    this.printFormatted(xPath.evaluate("/help/info/text()", this.doc));
                }
                catch (XPathExpressionException e) {
                    throw new RuntimeException(e);
                }
                System.out.println();
            }
        }

        private List<Node> toSet(Object nodesin) {
            NodeList nodes = (NodeList)nodesin;
            ArrayList<Node> result = new ArrayList<Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i));
            }
            return result;
        }

        private void printFormatted(String string) {
            StringTokenizer tokenizer = new StringTokenizer(string);
            int len = 0;
            while (tokenizer.hasMoreTokens()) {
                String x = tokenizer.nextToken();
                len += x.length();
                System.out.print(x);
                if (!tokenizer.hasMoreTokens()) continue;
                if (len > 80) {
                    System.out.println();
                    len = 0;
                    continue;
                }
                System.out.print(' ');
            }
        }

        @Override
        public void exec(String[] params) throws CommandException {
            if (params.length == 1) {
                System.out.print("ONS Java Client v 2.0 CLI\nThe list of available commands: \n");
                this.printCommands(Cli.this.commandMap);
                System.out.print("\nTo get help on any command, execute \"help [command name]\"\n\n");
            } else {
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                try {
                    params = Arrays.copyOfRange(params, 1, params.length);
                    this.newContext();
                    Cli.this.getCommand(params).info(this);
                    System.out.print("Command : ");
                    System.out.println(xPath.evaluate("/help/name/text()", this.doc));
                    System.out.print("Syntax : ");
                    System.out.println(xPath.evaluate("/help/syntax/text()", this.doc));
                    System.out.print("Description : \n  ");
                    this.printFormatted(xPath.evaluate("/help/info/text()", this.doc));
                    System.out.println("\n");
                    System.out.println("Parameters :");
                    for (Node n : this.toSet(xPath.evaluate("/help/parameter", this.doc, XPathConstants.NODESET))) {
                        System.out.println("  " + xPath.evaluate("./name/text()", n));
                        this.printFormatted("    " + xPath.evaluate("./desc/text()", n));
                        System.out.println("\n");
                    }
                    System.out.println("Examples :");
                    for (Node n : this.toSet(xPath.evaluate("/help/example", this.doc, XPathConstants.NODESET))) {
                        System.out.println("  " + xPath.evaluate("./text/text()", n));
                        this.printFormatted("    " + xPath.evaluate("./desc/text()", n));
                        System.out.println("\n");
                    }
                }
                catch (CommandException e) {
                    System.err.println(e.getMessage());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public class NodeBuilder {
            Element x;

            NodeBuilder(Element x) {
                this.x = x;
            }

            NodeBuilder item(String name) {
                Element y = CommandHelp.this.doc.createElement(name);
                this.x.appendChild(y);
                return new NodeBuilder(y);
            }

            NodeBuilder text(String text) {
                this.x.appendChild(CommandHelp.this.doc.createTextNode(text));
                return this;
            }

            NodeBuilder push(NodeBuilder builder) {
                this.x.appendChild(builder.x);
                return this;
            }
        }
    }

    private class SubscriberHolder
    implements CallBack {
        Subscriber s = null;
        Writer output = null;
        boolean showBody = false;

        private SubscriberHolder() {
        }

        @Override
        public void notification_callback(Notification n) {
            try {
                this.output.write(n.toNiceString());
                if (this.showBody) {
                    this.output.write(new String(n.body()));
                }
                this.output.write("\n");
                this.output.flush();
                Cli.this.processedEvents.incrementAndGet();
            }
            catch (IOException e) {
                System.err.println("Could not write to a file");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static interface ICommand {
        public void info(CommandHelp var1);

        public void exec(String[] var1) throws CommandException;
    }

    static class CommandException
    extends Exception {
        public CommandException(String x) {
            super(x);
        }
    }
}

