/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.CreatePermission;
import oracle.ons.Message;
import oracle.ons.NoServersAvailable;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationException;
import oracle.ons.NotificationManager;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionProxy;

public class NotificationNetwork {
    protected ONSConfiguration config;
    protected NotificationManager master;
    protected volatile int messageReceived = 0;
    protected volatile int messagePublished = 0;
    protected volatile int messageDropped = 0;
    private static final int STATE_NETWORK_DOWN = 0;
    private static final int STATE_STARTING_UP = 1;
    private static final int STATE_NETWORK_UP = 2;
    private static final long CONNECTION_SCAN = 15000L;
    private static final long FAILOVER_COOLDOWN = 3000L;
    private AtomicInteger state = new AtomicInteger(0);
    private final AtomicInteger usageCount = new AtomicInteger(0);
    protected Logger logger;
    private final Semaphore networkStatusLock = new Semaphore(0, false);
    protected final List<ONSConfiguration.NodeList> nodeLists = new ArrayList<ONSConfiguration.NodeList>();
    private final Set<Node> nodes = new HashSet<Node>();
    private RefreshConnectionsTask localRefreshTask = new RefreshConnectionsTask();
    private final Map<String, SubscriptionProxy> networkSubscriptions = new HashMap<String, SubscriptionProxy>();

    Iterable<? extends Node> getNodes() {
        return this.nodes;
    }

    NotificationNetwork(ONSConfiguration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission("ONSUser"));
        }
        this.master = NotificationManager.getNotificationManager();
        this.config = configuration;
        this.logger = this.master.logger;
        this.nodeLists.addAll(configuration.getTopologies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilOnline(long timeout, boolean throwOnTimeout) throws ONSException, InterruptedException {
        if (this.networkStatusLock.availablePermits() > 0) {
            NotificationNetwork notificationNetwork = this;
            synchronized (notificationNetwork) {
                return !this.nodes.isEmpty();
            }
        }
        if (this.networkStatusLock.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
            this.networkStatusLock.release();
        } else {
            this.state.compareAndSet(1, 0);
            if (throwOnTimeout) {
                throw new NoServersAvailable("Server time out");
            }
        }
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            return !this.nodes.isEmpty();
        }
    }

    public boolean waitUntilOnline() throws ONSException, InterruptedException {
        return this.waitUntilOnline(this.config.getSocketTimeout(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            for (Node n : this.nodes) {
                n.ping(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(long timeout) throws InterruptedException {
        LinkedBlockingQueue<Node> answers = new LinkedBlockingQueue<Node>();
        this.lazyDemand();
        if (!this.waitUntilOnline(timeout, false)) {
            return false;
        }
        HashSet<Node> activeNodeSet = new HashSet<Node>();
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            for (Node n : this.nodes) {
                if (!activeNodeSet.add(n)) continue;
                n.ping(answers);
            }
        }
        while (!activeNodeSet.isEmpty()) {
            Node n = (Node)answers.poll(timeout, TimeUnit.MILLISECONDS);
            if (n == null) {
                return false;
            }
            activeNodeSet.remove(n);
        }
        return true;
    }

    protected void checkPublisherPerimission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission("ONSUser"));
        }
    }

    public Publisher getPublisher(String component) {
        return new Publisher(this, component);
    }

    public synchronized boolean publish(Message message) {
        this.checkPublisherPerimission();
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Iterator<Node> iterator = this.nodes.iterator();
        if (iterator.hasNext()) {
            Node n = iterator.next();
            n.publish(message);
            return true;
        }
        return false;
    }

    public synchronized boolean publishNotification(Notification notification, Publisher author) {
        boolean status = false;
        this.checkPublisherPerimission();
        if (notification.deliveryTime != -1L) {
            throw new NotificationException("Received notifications cannot be published");
        }
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Message v4 = null;
        Message v5 = null;
        for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
            Iterator<Node> iterator = nodeList.connected.iterator();
            if (!iterator.hasNext()) continue;
            Node n = iterator.next();
            try {
                if (n.getProtocolVersion() >= 5) {
                    n.publish(v5 != null ? v5 : notification.toMessage(author));
                } else {
                    n.publish(v4 != null ? v4 : notification.toMessageVersion4(author));
                }
                status = true;
            }
            catch (IOException e) {
                throw new ONSException("Notification publish failed for client internal error");
            }
        }
        return status;
    }

    void scanExpandNodeList(Collection<NodeAddress> nodeListIn, Collection<NodeAddress> nodeListOut) {
        if (this.config.ignoreScan) {
            nodeListIn.stream().map(naddr -> new NodeAddress((NodeAddress)naddr)).forEachOrdered(nodeListOut::add);
        } else {
            for (NodeAddress hp : nodeListIn) {
                try {
                    for (InetAddress address : InetAddress.getAllByName(hp.hostname)) {
                        NodeAddress nhp = new NodeAddress(address.getHostAddress(), hp.port, this.config.getKeyFile(), this.config.getWebSocket());
                        this.logger.finest(String.format("%s resolves to %s", hp.toString(), nhp.toString()));
                        nodeListOut.add(nhp);
                    }
                }
                catch (UnknownHostException e) {
                    NotificationManager.getNotificationManager().logger.warning(String.format("ONS failed to resolve host : %s", hp.toString()));
                }
            }
        }
    }

    synchronized void onNodeUp(Node node) {
        if (node.isConnected()) {
            for (SubscriptionProxy proxy : this.networkSubscriptions.values()) {
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, proxy));
            }
            this.nodes.add(node);
            for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
                if (!nodeList.pending.contains(node)) continue;
                nodeList.pending.remove(node);
                nodeList.connected.add(node);
                nodeList.connectFails = 0;
            }
            this.state.set(2);
            this.networkStatusLock.release();
        }
    }

    synchronized void onNodeDown(Node node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
            for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
                nodeList.pending.remove(node);
                nodeList.connected.remove(node);
            }
            if (this.nodes.isEmpty()) {
                this.state.compareAndSet(2, 1);
            }
            if (!this.networkStatusLock.tryAcquire()) {
                this.logger.severe("Node consistency broken");
            }
        } else {
            for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
                if (!nodeList.pending.contains(node)) continue;
                nodeList.pending.remove(node);
                ++nodeList.connectFails;
            }
        }
        if (this.state.get() != 0) {
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    private synchronized void shutdown() {
        this.logger.log(Level.FINE, "ONS network real shutdown");
        for (Node n : this.nodes) {
            n.unregister(this);
            this.networkStatusLock.tryAcquire();
        }
        this.nodes.clear();
        this.state.set(0);
    }

    void release() {
        if (this.usageCount.decrementAndGet() == 0) {
            this.shutdown();
            this.master.onNetworkDown(this);
        }
        this.logger.log(Level.FINE, "ONS network down request : " + this.usageCount.toString());
    }

    NotificationNetwork demand() {
        this.logger.log(Level.FINE, "ONS network up request : " + this.usageCount.toString());
        if (this.usageCount.getAndIncrement() == 0) {
            this.startup();
        }
        return this;
    }

    public NotificationNetwork lazyDemand() {
        this.startup();
        return this;
    }

    public void releaseIfUnused() {
        if (this.usageCount.get() == 0) {
            this.shutdown();
            this.master.onNetworkDown(this);
        }
    }

    private void startup() {
        if (this.state.compareAndSet(0, 1)) {
            this.master.onNetworkUp(this);
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    synchronized void registerSubscriber(Subscriber subscriber) {
        String key = subscriber.getSubscriptionKey();
        SubscriptionProxy proxy = this.networkSubscriptions.get(key);
        if (proxy == null) {
            proxy = new SubscriptionProxy(this, subscriber);
            this.networkSubscriptions.put(key, proxy);
            for (Node node : this.getNodes()) {
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, proxy));
            }
        } else {
            proxy.add(subscriber);
        }
    }

    synchronized void unregisterSubscriber(Subscriber subscriber) {
        String key = subscriber.getSubscriptionKey();
        SubscriptionProxy proxy = this.networkSubscriptions.get(key);
        proxy.remove(subscriber);
        if (proxy.isEmpty()) {
            this.networkSubscriptions.remove(key);
            for (Node node : this.getNodes()) {
                this.master.getWorkloadManager().schedule(new RemoveSubscriptionTask(node, proxy));
            }
        }
    }

    private class RemoveSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RemoveSubscriptionTask(Node node, SubscriptionProxy proxy) {
            this.node = node;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            try {
                this.node.removeSubscriber(this.proxy);
            }
            catch (Exception e) {
                NotificationNetwork.this.master.logger.finest(e.getLocalizedMessage());
            }
        }
    }

    private class RegisterSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RegisterSubscriptionTask(Node node, SubscriptionProxy proxy) {
            this.node = node;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            try {
                this.node.addSubscriber(this.proxy);
            }
            catch (Exception e) {
                NotificationNetwork.this.master.logger.warning(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    private class RefreshConnectionsTask
    implements Runnable {
        private volatile long lastRun = 0L;
        private volatile boolean scheduled = false;

        private RefreshConnectionsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RefreshConnectionsTask refreshConnectionsTask = this;
            synchronized (refreshConnectionsTask) {
                long tNow = System.currentTimeMillis();
                long dT = tNow - this.lastRun;
                if (3000L > dT) {
                    if (!this.scheduled) {
                        NotificationNetwork.this.master.getWorkloadManager().scheduleDelayed(this, 3000L - dT);
                        this.scheduled = true;
                    }
                    return;
                }
                this.scheduled = false;
                long schedTime = 15000L;
                boolean doSched = false;
                for (ONSConfiguration.NodeList nl : NotificationNetwork.this.nodeLists) {
                    HashSet<NodeAddress> localAddresses = new HashSet<NodeAddress>();
                    NotificationNetwork.this.scanExpandNodeList(nl.addresses, localAddresses);
                    int maxConnections = Math.min(nl.maxConnections, localAddresses.size());
                    int cCount = nl.pending.size() + nl.connected.size();
                    if (!nl.active) {
                        if (nl.failedFrom == null) continue;
                        if (cCount < maxConnections) {
                            NotificationNetwork.this.master.connect(nl, localAddresses, maxConnections, NotificationNetwork.this);
                        }
                        doSched = true;
                        continue;
                    }
                    if (nl.connected.size() >= maxConnections && nl.failedTo == null) continue;
                    NotificationNetwork.this.master.connect(nl, localAddresses, maxConnections, NotificationNetwork.this);
                    cCount = nl.pending.size() + nl.connected.size();
                    if (nl.failedTo != null && nl.connected.size() != 0) {
                        ONSConfiguration.NodeList failOver = nl.failedTo;
                        nl.failedTo = null;
                        failOver.failedFrom = null;
                        HashSet<Object> foNodes = new HashSet<Object>();
                        NotificationNetwork notificationNetwork = NotificationNetwork.this;
                        synchronized (notificationNetwork) {
                            Object node;
                            Iterator<Node> iterator = failOver.pending.iterator();
                            while (iterator.hasNext()) {
                                node = iterator.next();
                                foNodes.add(node);
                                iterator.remove();
                            }
                            iterator = failOver.connected.iterator();
                            while (iterator.hasNext()) {
                                node = iterator.next();
                                foNodes.add(node);
                                iterator.remove();
                            }
                            for (Node node2 : foNodes) {
                                if (!NotificationNetwork.this.nodes.contains(node2)) continue;
                                NotificationNetwork.this.nodes.remove(node2);
                                node2.unregister(NotificationNetwork.this);
                            }
                        }
                        if (cCount < maxConnections) {
                            NotificationNetwork.this.master.connect(nl, localAddresses, maxConnections, NotificationNetwork.this);
                            cCount = nl.pending.size() + nl.connected.size();
                        }
                        schedTime = 3000L;
                        doSched = true;
                    } else if (nl.connected.size() == 0 && nl.connectFails > maxConnections && nl.failedTo == null) {
                        for (ONSConfiguration.NodeList fnl : NotificationNetwork.this.nodeLists) {
                            if (fnl.active || fnl.failedFrom != null) continue;
                            HashSet<NodeAddress> fnlAddresses = new HashSet<NodeAddress>();
                            NotificationNetwork.this.scanExpandNodeList(fnl.addresses, fnlAddresses);
                            int fnlMax = Math.min(fnl.maxConnections, fnlAddresses.size());
                            NotificationNetwork.this.master.connect(fnl, fnlAddresses, fnlMax, NotificationNetwork.this);
                            int fnlCount = fnl.pending.size() + fnl.connected.size();
                            if (fnlCount == 0) continue;
                            nl.failedTo = fnl;
                            fnl.failedFrom = nl;
                            cCount = fnlCount;
                            maxConnections = fnlMax;
                            break;
                        }
                    } else if (nl.connected.size() == 0 && nl.failedTo == null) {
                        schedTime = 3000L;
                    }
                    if (cCount >= maxConnections) continue;
                    doSched = true;
                }
                this.lastRun = System.currentTimeMillis();
                if (doSched && !this.scheduled) {
                    NotificationNetwork.this.master.getWorkloadManager().scheduleDelayed(this, schedTime);
                    this.scheduled = true;
                }
            }
        }
    }
}

