/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.opmn;

import oracle.ons.BodyElement;
import oracle.ons.BodySegment;
import oracle.ons.opmn.ProcReadyObj;

public final class ProcReadyPort
extends ProcReadyObj {
    static final String hostStr = "host";
    static final String portStr = "port";
    static final String descStr = "desc";
    static final String protocolStr = "protocol";
    protected static final String PORT_SEG_NAME = "opmn_connect";
    private static final String DMS_NAME = "opmn_connect@";
    private static final String[] compatPorts = new String[]{"rmi", "ajp", "ajps", "http", "https", "jms", "iiop", "iiops"};
    private boolean isBackCompat = false;

    public ProcReadyPort(String name, String host, String port, String desc) {
        this(name, host, port, desc, name);
    }

    public ProcReadyPort(String name, String host, String port, String desc, String protocol) {
        super(name);
        if (host == null) {
            throw new NullPointerException("host was passed into the constructor as null");
        }
        if (port == null) {
            throw new NullPointerException("port was passed into the constructor as null");
        }
        if (desc == null) {
            throw new NullPointerException("desc was passed into the constructor as null");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol was passed into the constructor as null");
        }
        this.dataElements.put(hostStr, host);
        this.dataElements.put(portStr, port);
        this.dataElements.put(descStr, desc);
        this.dataElements.put(protocolStr, protocol);
        for (int iter = 0; iter < compatPorts.length; ++iter) {
            if (!protocol.equals(compatPorts[iter])) continue;
            this.isBackCompat = true;
            break;
        }
    }

    boolean addOldFormat(BodySegment dmsSegment) {
        if ("DMS".equals(dmsSegment.getName())) {
            StringBuffer compatStrs = new StringBuffer(32);
            compatStrs.append(DMS_NAME);
            compatStrs.append(this.dataElements.get(protocolStr));
            compatStrs.append('/');
            compatStrs.append(hostStr);
            dmsSegment.addElement(new BodyElement(compatStrs.toString(), (String)this.dataElements.get(hostStr)));
            int repB = compatStrs.length() - hostStr.length();
            compatStrs.replace(repB, repB + portStr.length(), portStr);
            dmsSegment.addElement(new BodyElement(compatStrs.toString(), (String)this.dataElements.get(portStr)));
            repB = compatStrs.length() - portStr.length();
            compatStrs.replace(compatStrs.length() - portStr.length(), repB + descStr.length(), descStr);
            dmsSegment.addElement(new BodyElement(compatStrs.toString(), (String)this.dataElements.get(descStr)));
            return true;
        }
        return false;
    }

    boolean addToPortSegment(BodySegment portSegment) {
        if (PORT_SEG_NAME.equals(portSegment.getName())) {
            BodySegment newPort = new BodySegment(this.prName);
            for (String curKey : this.dataElements.keySet()) {
                newPort.addElement(new BodyElement(curKey, (String)this.dataElements.get(curKey)));
            }
            portSegment.addSegment(newPort);
            return true;
        }
        return false;
    }

    boolean isCompatibilityPort() {
        return this.isBackCompat;
    }
}

