/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.client.RemotePgqlResultSetBuffer;
import oracle.pgx.client.RemotePgqlResultsIterator;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.marshalers.GenericCollectionMarshaler;
import oracle.pgx.common.pojo.GraphConfigContainer;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.GraphConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePgqlResultSetProxy
implements PgqlResultSetProxy {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePgqlResultSetProxy.class);
    private final Executor httpExecutor;
    private final String url;
    private final String resultSetProxyId;
    private final PgxId graphId;
    private final int prefetchSize;
    private final long numResults;
    private final RemotePgqlResultSetBuffer resultSetBuffer;
    private final URI baseUri;
    private final GraphConfig graphConfig;
    private List<PgqlResultElement> elements;

    public RemotePgqlResultSetProxy(Executor httpExecutor, String path, String sessionId, String resultSetProxyId, PgxId graphId, int prefetchSize, long numResults, GraphConfigContainer container) {
        this.httpExecutor = httpExecutor;
        this.url = RemoteUtils.stripTrailingSlash(path);
        this.resultSetProxyId = resultSetProxyId;
        this.graphId = graphId;
        this.prefetchSize = prefetchSize;
        this.numResults = numResults;
        this.resultSetBuffer = new RemotePgqlResultSetBuffer(prefetchSize, numResults, httpExecutor, this.url + "/results", resultSetProxyId, this.getResultElements());
        this.baseUri = URI.create(ClientConfig.Field.BASE_URL.toString());
        this.graphConfig = container == null ? null : container.getGraphConfig(sessionId);
    }

    public String getId() {
        return this.resultSetProxyId;
    }

    public PgxId getGraphId() {
        return this.graphId;
    }

    public long getNumResults() {
        return this.numResults;
    }

    public GraphConfig getCreatePropertyGraphConfig() {
        return this.graphConfig;
    }

    public List<PgqlResultElement> getResultElements() {
        if (this.elements == null) {
            try {
                Request req = Request.Get((String)(this.url + "/elements"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Requesting {}", (Object)req);
                }
                req.addHeader("x-proxy-id", this.resultSetProxyId);
                String responseContent = RemoteUtils.getResponseContent(this.httpExecutor.execute(req));
                GenericCollectionMarshaler marshaler = new GenericCollectionMarshaler(ArrayList.class, PgqlResultElement.class);
                this.elements = (List)marshaler.unmarshal(responseContent);
            }
            catch (IOException | RemoteUtils.RequestPendingException e) {
                throw new ProxyException("could not get result elements", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ProxyException(e.getCause());
            }
        }
        return this.elements;
    }

    public Iterable<List<Object>> getResults() {
        return new RemotePgqlResultsIterable(this.httpExecutor, this.url + "/results", this.resultSetProxyId, this.prefetchSize, this.getResultElements());
    }

    public List<Object> getResultRow(long cursor) throws PgqlException {
        return this.resultSetBuffer.getResultRow(cursor);
    }

    public Collection<List<Object>> getNextElements(int start, int size) {
        throw new RuntimeException("Not yet implemented");
    }

    private static class RemotePgqlResultsIterable
    implements Iterable<List<Object>> {
        private final Executor httpExecutor;
        private final String requestUrl;
        private final String proxyId;
        private final int prefetchSize;
        private final List<PgqlResultElement> elements;

        RemotePgqlResultsIterable(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize, List<PgqlResultElement> elements) {
            this.httpExecutor = httpExecutor;
            this.requestUrl = requestUrl;
            this.proxyId = proxyId;
            this.prefetchSize = prefetchSize;
            this.elements = elements;
        }

        @Override
        public Iterator<List<Object>> iterator() {
            return new RemotePgqlResultsIterator(this.httpExecutor, this.requestUrl, this.proxyId, this.prefetchSize, this.elements);
        }
    }
}

