/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.net.URI;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.MapProxy;
import oracle.pgx.client.RemoteMapProxy;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.RemoteMapProxyFactory;
import oracle.pgx.config.LinkTemplate;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;

public class RemoteMapProxyFactoryImpl
implements RemoteMapProxyFactory {
    private final ClientContext context;
    private final URI baseUri;

    public RemoteMapProxyFactoryImpl(ClientContext context, URI baseUri) {
        this.context = context;
        this.baseUri = baseUri;
    }

    public <K, V> MapProxy<K, V> createRemoteMapProxy(SessionContext sessionContext, String mapProxyUUID, int size, PropertyType keyType, IdType keyNodeEdgeValueType, PropertyType valueType, IdType valueNodeEdgeValueType, String mapName) {
        String url = LinkTemplate.MAP_PROXY_SELF.generateUrl(this.baseUri, new Object[0]);
        HttpClient httpClient = this.context.getHttpClient();
        Executor executor = RemoteUtils.newHttpExecutor(httpClient, url, sessionContext, this.context.getCsrfToken(), this.context.getClientStickyCookie());
        return new RemoteMapProxy(executor, url, this.baseUri, size, this.context.getConfig().getPrefetchSize(), keyType, keyNodeEdgeValueType, valueType, valueNodeEdgeValueType, mapName, mapProxyUUID);
    }
}

