/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.client.AbstractRemoteIterator;
import oracle.pgx.common.Entry;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import org.apache.http.client.fluent.Executor;

public abstract class AbstractRemoteEntryIterator<K, V>
extends AbstractRemoteIterator<Map.Entry<K, V>> {
    private final PropertyType keyType;
    private final IdType keyNodeEdgeValueType;
    private final PropertyType valueType;
    private final IdType valueNodeEdgeValueType;
    private final int dimension;

    public AbstractRemoteEntryIterator(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize, PropertyType keyType, IdType keyNodeEdgeValueType, PropertyType valueType, IdType valueNodeEdgeValueType) {
        this(httpExecutor, requestUrl, proxyId, prefetchSize, keyType, keyNodeEdgeValueType, valueType, valueNodeEdgeValueType, 0);
    }

    public AbstractRemoteEntryIterator(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize, PropertyType keyType, IdType keyNodeEdgeValueType, PropertyType valueType, IdType valueNodeEdgeValueType, int dimension) {
        super(httpExecutor, requestUrl, proxyId, prefetchSize);
        if (valueType == null) {
            throw new IllegalArgumentException("value type cannot be null");
        }
        this.keyType = keyType;
        this.keyNodeEdgeValueType = keyNodeEdgeValueType;
        this.valueType = valueType;
        this.valueNodeEdgeValueType = valueNodeEdgeValueType;
        this.dimension = dimension;
    }

    @Override
    protected Collection<Map.Entry<K, V>> parseResults(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
        JsonNode isKeyWrappedNode = node.get("keyWrapped");
        boolean isKeyWrapped = false;
        if (isKeyWrappedNode != null) {
            isKeyWrapped = Boolean.TRUE.equals(JsonUtil.fromJsonNode((JsonNode)isKeyWrappedNode, Boolean.class));
        }
        JsonNode isValueWrappedNode = node.get("valueWrapped");
        boolean isValueWrapped = false;
        if (isValueWrappedNode != null) {
            isValueWrapped = Boolean.TRUE.equals(JsonUtil.fromJsonNode((JsonNode)isValueWrappedNode, Boolean.class));
        }
        Class keyTypeClass = this.getTypeClass(isKeyWrapped, this.keyType, this.keyNodeEdgeValueType, 0);
        Class valueTypeClass = this.getTypeClass(isValueWrapped, this.valueType, this.valueNodeEdgeValueType, this.dimension);
        TypeFactory typeFactory = JsonUtil.getTypeFactory();
        JavaType entryClass = typeFactory.constructParametricType(Entry.class, new Class[]{keyTypeClass, valueTypeClass});
        CollectionType collectionClass = typeFactory.constructCollectionType(ArrayList.class, entryClass);
        JsonParser items = JsonUtil.getValues((JsonNode)node, (String)"items");
        ArrayList fetchedValues = (ArrayList)JsonUtil.readValue((JsonParser)items, (JavaType)collectionClass);
        return fetchedValues;
    }

    private Class getTypeClass(boolean isValueWrapped, PropertyType type, IdType nodeEdgeKeyType, int dimension) {
        if (isValueWrapped) {
            if (type == PropertyType.VERTEX) {
                return Vertex.class;
            }
            return Edge.class;
        }
        if (dimension <= 0) {
            if (type == null) {
                return nodeEdgeKeyType.getTypeClass();
            }
            return type.isNodeOrEdge() ? nodeEdgeKeyType.getTypeClass() : type.getTypeClass();
        }
        Class<PgxVect> valueTypeClass = PgxVect.class;
        return valueTypeClass;
    }
}

