/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import oracle.pgx.common.PgxSensitiveDataLogger;
import oracle.pgx.common.auth.TokenProvider;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableAuthHeader
implements Header {
    private static final Logger LOG = LoggerFactory.getLogger(MutableAuthHeader.class);
    private static final HeaderElement[] EMPTY_HEADER_ELEMENTS = new HeaderElement[0];
    private final TokenProvider authTokenProvider;

    MutableAuthHeader(TokenProvider authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
    }

    public HeaderElement[] getElements() throws ParseException {
        String value = this.getValue();
        if (value != null) {
            return BasicHeaderValueParser.parseElements((String)value, null);
        }
        return EMPTY_HEADER_ELEMENTS;
    }

    public String getName() {
        return "Authorization";
    }

    public String getValue() {
        String token = this.authTokenProvider.getToken();
        if (token == null) {
            return null;
        }
        String headerValue = "Bearer " + token;
        PgxSensitiveDataLogger.trace((Logger)LOG, (String)"setting {} header to {}", (Object)this.getName(), (Object)headerValue);
        return headerValue;
    }
}

