/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import oracle.pgx.common.auth.PgxGeneralPermission;
import oracle.pgx.common.auth.PgxGenericPermission;
import oracle.pgx.common.auth.PgxResourcePermission;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;

public class PgxGenericPermissionSetMarshaler
implements Marshaler<Set<PgxGenericPermission>> {
    @Override
    public String marshal(Set<PgxGenericPermission> object) throws IOException {
        return JsonUtil.toJson(object);
    }

    @Override
    public Set<PgxGenericPermission> unmarshal(String content) throws IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)content);
        HashSet<PgxGenericPermission> permissionSet = new HashSet<PgxGenericPermission>();
        node.forEach(permissionNode -> permissionSet.add(PgxGenericPermissionSetMarshaler.unmarshalGenericPermission(permissionNode)));
        return permissionSet;
    }

    private static PgxGenericPermission unmarshalGenericPermission(JsonNode node) {
        boolean isFileLocationPermission = node.get("fileLocationPermission").asBoolean();
        if (isFileLocationPermission) {
            String location = node.get("location").textValue();
            String permissionText = node.get("resourcePermission").textValue();
            return new PgxGenericPermission(location, PgxResourcePermission.valueOf((String)permissionText));
        }
        String generalPermissionText = node.get("generalPermission").textValue();
        return new PgxGenericPermission(PgxGeneralPermission.valueOf((String)generalPermissionText));
    }
}

