/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.AllPathsProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.AllPathsProxyResponse;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemoteAllPathsProxyFactory;

public class AllPathsProxyMarshaler
implements Marshaler<AllPathsProxy> {
    private final SessionContext sessionContext;
    private final RemoteAllPathsProxyFactory allPathsProxyFactory;

    public AllPathsProxyMarshaler(SessionContext sessionContext, RemoteAllPathsProxyFactory factory) {
        this.sessionContext = sessionContext;
        this.allPathsProxyFactory = factory;
    }

    public AllPathsProxyMarshaler() {
        this(null, null);
    }

    @Override
    public AllPathsProxy unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.allPathsProxyFactory == null) {
            throw new IllegalStateException("allPaths proxy factory is not set");
        }
        if (this.sessionContext.getSessionId() == null) {
            throw new IllegalStateException("session is not set");
        }
        AllPathsProxyResponse response = (AllPathsProxyResponse)((Object)JsonUtil.readTopLevelJson((String)jsonString, AllPathsProxyResponse.class));
        AllPathsProxy ret = this.allPathsProxyFactory.createRemoteAllPathsProxy(this.sessionContext, response.proxyId);
        return ret;
    }

    @Override
    public String marshal(AllPathsProxy proxy) throws JsonGenerationException, JsonMappingException, IOException {
        String proxyUUID = proxy.getId();
        AllPathsProxyResponse response = new AllPathsProxyResponse(proxyUUID);
        response.proxyId = proxyUUID;
        String jsonString = JsonUtil.toJson((Object)((Object)response));
        return jsonString;
    }
}

