/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.SupervisedGraphWiseModelMetadata;
import oracle.pgx.api.mllib.GraphWiseModelBuilder;
import oracle.pgx.api.mllib.SupervisedGraphWiseModel;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWisePredictionLayerConfig;
import oracle.pgx.config.mllib.SupervisedGraphWiseModelConfig;
import oracle.pgx.config.mllib.batchgenerator.BatchGenerator;
import oracle.pgx.config.mllib.loss.LossFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisedGraphWiseModelBuilder
extends GraphWiseModelBuilder<SupervisedGraphWiseModel, SupervisedGraphWiseModelConfig, SupervisedGraphWiseModelBuilder> {
    static final Logger LOG = LoggerFactory.getLogger(SupervisedGraphWiseModelBuilder.class);
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final BiFunction<PgxSession, Graph, PgxGraph> graphConstructor;

    public SupervisedGraphWiseModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.modelConfig = new SupervisedGraphWiseModelConfig();
        this.graphConstructor = graphConstructor;
    }

    public SupervisedGraphWiseModelBuilder setVertexTargetPropertyName(String propertyName) {
        ((SupervisedGraphWiseModelConfig)this.modelConfig).setVertexTargetPropertyName(propertyName);
        return this;
    }

    public SupervisedGraphWiseModelBuilder setPredictionLayerConfigs(GraphWisePredictionLayerConfig ... layerConfigs) {
        ((SupervisedGraphWiseModelConfig)this.modelConfig).setPredictionLayerConfigs(layerConfigs);
        return this;
    }

    public SupervisedGraphWiseModelBuilder setClassWeights(Map<?, Float> classWeights) {
        ((SupervisedGraphWiseModelConfig)this.modelConfig).setClassWeights(classWeights);
        return this;
    }

    @Deprecated
    public SupervisedGraphWiseModelBuilder setLossFunction(SupervisedGraphWiseModelConfig.LossFunction lossFunction) {
        ((SupervisedGraphWiseModelConfig)this.modelConfig).setLossFunction(lossFunction);
        return this;
    }

    public SupervisedGraphWiseModelBuilder setLossFunction(LossFunction lossFunction) {
        ((SupervisedGraphWiseModelConfig)this.modelConfig).setLossFunctionClass(lossFunction);
        return this;
    }

    public SupervisedGraphWiseModelBuilder setBatchGenerator(BatchGenerator batchGenerator) {
        ((SupervisedGraphWiseModelConfig)this.modelConfig).setBatchGenerator(batchGenerator);
        return this;
    }

    private void validatePredLayerConfigs() {
        if (((SupervisedGraphWiseModelConfig)this.modelConfig).getPredictionLayerConfigs() != null && ((SupervisedGraphWiseModelConfig)this.modelConfig).getPredictionLayerConfigs().length == 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PREDICTION_LAYERS", (Object[])new Object[0]));
        }
    }

    private void validateClassWeights() {
        if (((SupervisedGraphWiseModelConfig)this.modelConfig).getClassWeights() != null) {
            if (((SupervisedGraphWiseModelConfig)this.modelConfig).getClassWeights().size() == 0) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EMPTY_CLASS_WEIGHTS", (Object[])new Object[0]));
            }
            Object firstKey = ((SupervisedGraphWiseModelConfig)this.modelConfig).getClassWeights().keySet().iterator().next();
            if (firstKey instanceof String) {
                ((SupervisedGraphWiseModelConfig)this.modelConfig).setLabelType(PropertyType.STRING);
            } else if (firstKey instanceof Integer) {
                ((SupervisedGraphWiseModelConfig)this.modelConfig).setLabelType(PropertyType.INTEGER);
            } else if (firstKey instanceof Long) {
                ((SupervisedGraphWiseModelConfig)this.modelConfig).setLabelType(PropertyType.LONG);
            } else if (firstKey instanceof Boolean) {
                ((SupervisedGraphWiseModelConfig)this.modelConfig).setLabelType(PropertyType.BOOLEAN);
            } else {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_CLASS_WEIGHTS_KEY_TYPE", (Object[])new Object[]{firstKey.getClass()}));
            }
            for (Map.Entry entry : ((SupervisedGraphWiseModelConfig)this.modelConfig).getClassWeights().entrySet()) {
                if (entry.getKey().getClass() == firstKey.getClass()) continue;
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INCONSISTENT_CLASS_WEIGHTS_KEY_TYPES", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public SupervisedGraphWiseModel build() throws InterruptedException, ExecutionException {
        super.validateAll();
        this.validateClassWeights();
        this.validatePredLayerConfigs();
        if (((SupervisedGraphWiseModelConfig)this.modelConfig).getVertexTargetPropertyName() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NO_TARGET_PROPERTY", (Object[])new Object[0]));
        }
        LOG.debug("Building Model...");
        SupervisedGraphWiseModelMetadata metadata = new SupervisedGraphWiseModelMetadata(null, (SupervisedGraphWiseModelConfig)this.modelConfig);
        return (SupervisedGraphWiseModel)((PgxFuture)this.core.createSupervisedGraphWiseModel(this.session.getSessionContext(), metadata).thenApply(metaData -> new SupervisedGraphWiseModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, this.graphConstructor, (SupervisedGraphWiseModelMetadata)((Object)metaData)))).get();
    }

    @Override
    protected SupervisedGraphWiseModelBuilder getThis() {
        return this;
    }
}

