/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.internal.EdgeTable;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.Property;
import oracle.pgx.api.internal.VertexTable;
import oracle.pgx.common.Link;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.PrettyPrint;

public class HomogeneousGraph
extends Self {
    private Graph graph;

    public HomogeneousGraph() {
        this(new Graph());
        this.graph.setVertexTables(HomogeneousGraph.getForgedVertexTables(true));
        this.graph.setEdgeTables(HomogeneousGraph.getForgedEdgeTables(true));
    }

    public HomogeneousGraph(Graph simpleGraph) {
        this.graph = simpleGraph;
    }

    public HomogeneousGraph(PgxId graphId, String graphName, boolean transientFlag) {
        this(new Graph(graphId, graphName, new GraphMetaData(IdType.INTEGER, IdType.LONG), transientFlag));
        this.graph.setVertexTables(HomogeneousGraph.getForgedVertexTables(true));
        this.graph.setEdgeTables(HomogeneousGraph.getForgedEdgeTables(true));
    }

    public HomogeneousGraph(PgxId graphId, String graphName, GraphMetaData metaData, boolean transientFlag) {
        this(new Graph(graphId, graphName, metaData, transientFlag));
        this.graph.setVertexTables(HomogeneousGraph.getForgedVertexTables(true));
        this.graph.setEdgeTables(HomogeneousGraph.getForgedEdgeTables(true));
    }

    private static Map<String, VertexTable> getForgedVertexTables(boolean transientFlag) {
        HashMap<String, VertexTable> forgedVertexTables = new HashMap<String, VertexTable>();
        forgedVertexTables.put("V", new VertexTable("V", transientFlag, null, null, false));
        return forgedVertexTables;
    }

    private static Map<String, EdgeTable> getForgedEdgeTables(boolean transientFlag) {
        HashMap<String, EdgeTable> forgedEdgeTables = new HashMap<String, EdgeTable>();
        forgedEdgeTables.put("E", new EdgeTable("E", "V", "V", transientFlag, null, null, false));
        return forgedEdgeTables;
    }

    @JsonIgnore
    public Graph getResult() {
        return this.graph;
    }

    public long getAgeMs() {
        return this.graph.getAgeMs();
    }

    public void setAgeMs(long ageMs) {
        this.graph.setAgeMs(ageMs);
    }

    public boolean isTransient() {
        return this.graph.isTransient();
    }

    public void setTransient(boolean transientFlag) {
        this.graph.setTransient(transientFlag);
    }

    public String getGraphName() {
        return this.graph.getGraphName();
    }

    public void setGraphName(String graphName) {
        this.graph.setGraphName(graphName);
    }

    public GraphMetaData getMetaData() {
        return this.graph.getMetaData();
    }

    public void setMetaData(GraphMetaData metaData) {
        this.graph.setMetaData(metaData);
    }

    public String toString() {
        return PrettyPrint.prettify((Object)this);
    }

    public LinkedHashMap<PgxId, Property> getNodeProperties() {
        return this.graph.getMainVertexTable().getVertexProperties();
    }

    public void setNodeProperties(LinkedHashMap<PgxId, Property> nodeProps) {
        this.graph.getMainVertexTable().setVertexProperties(nodeProps);
    }

    public void addNodeProperty(PgxId id, Property property) {
        this.graph.getMainVertexTable().addVertexProperty(id, property);
    }

    @JsonIgnore
    public Set<String> getEdgePropertyNames() {
        return this.graph.getMainEdgeTable().getEdgePropertyNames();
    }

    public LinkedHashMap<PgxId, Property> getEdgeProperties() {
        return this.graph.getMainEdgeTable().getEdgeProperties();
    }

    public void setEdgeProperties(LinkedHashMap<PgxId, Property> edgeProps) {
        this.graph.getMainEdgeTable().setEdgeProperties(edgeProps);
    }

    public void addEdgeProperty(PgxId id, Property property) {
        this.graph.getMainEdgeTable().addEdgeProperty(id, property);
    }

    public Property getVertexLabels() {
        return this.graph.getMainVertexTable().getVertexLabels();
    }

    public void setVertexLabels(Property property) {
        this.graph.getMainVertexTable().setVertexLabels(property);
    }

    public Property getEdgeLabel() {
        return this.graph.getMainEdgeTable().getEdgeLabel();
    }

    public void setEdgeLabel(Property property) {
        this.graph.getMainEdgeTable().setEdgeLabel(property);
    }

    public List<Link> getLinks() {
        return this.graph.getLinks();
    }

    public String getId() {
        return this.graph.getGraphId().toString();
    }

    public void setId(String id) {
        this.graph.setId(id);
    }
}

