/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.Destroyable;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.schema.ColumnDescriptor;
import oracle.pgx.api.frames.schema.internal.DataTypeInternalUtils;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.common.PgxId;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfigBuilder;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.ProviderFormat;

public class PgxFrameBuilder
extends Destroyable {
    private final PgxId serverBuilderId;
    private final SessionContext sessionContext;
    private final Core core;
    private final Function<FrameMetaData, PgxFrame> buildCallback;

    public PgxFrameBuilder(SessionContext sessionContext, Core core, List<ColumnDescriptor> schema, Function<FrameMetaData, PgxFrame> buildCallback) throws ExecutionException, InterruptedException {
        if (schema == null || schema.isEmpty()) {
            throw new IllegalArgumentException("FRAME_BUILDER_INVALID_SCHEMA");
        }
        this.sessionContext = sessionContext;
        this.core = core;
        this.buildCallback = buildCallback;
        FileEntityProviderConfigBuilder configBuilder = new FileEntityProviderConfigBuilder(ProviderFormat.CSV);
        ((FileEntityProviderConfigBuilder)configBuilder.setName("name")).addUri("");
        for (ColumnDescriptor columnDescriptor : schema) {
            GraphPropertyConfig prop = DataTypeInternalUtils.toPropertyConfig(columnDescriptor.getColumnName(), columnDescriptor.getColumnType());
            configBuilder.addVectorProperty(prop.getName(), prop.getType(), prop.getDimension().intValue());
        }
        EntityProviderConfig config = configBuilder.build();
        this.serverBuilderId = core.createFrameBuilder(sessionContext, config).get();
    }

    public PgxFrameBuilder addRows(Map<String, Iterable<?>> rows) throws ExecutionException, InterruptedException {
        return this.addRowsAsync(rows).get();
    }

    public PgxFuture<PgxFrameBuilder> addRowsAsync(Map<String, Iterable<?>> rows) {
        return this.core.addRowsToFrameBuilder(this.sessionContext, this.serverBuilderId, rows).thenReturn(this);
    }

    public PgxFrame build(String frameName) throws ExecutionException, InterruptedException {
        return this.buildAsync(frameName).get();
    }

    public PgxFuture<PgxFrame> buildAsync(String frameName) {
        return this.core.buildFrame(this.sessionContext, this.serverBuilderId, frameName).thenApply(this.buildCallback);
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyFrameBuilder(this.sessionContext, this.serverBuilderId);
    }
}

