/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Collection;
import oracle.pgx.api.PgxCollection;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.VertexCollection;
import oracle.pgx.api.VertexSet;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.util.ErrorMessages;

public class ComponentCollection<ID>
extends VertexCollection<ID> {
    private final long id;
    private final PgxGraph graph;

    public ComponentCollection(PgxGraph graph, PgxId collectionNamespace, long id) {
        super(graph, collectionNamespace, collectionNamespace.toString(), CollectionType.SET);
        this.id = id;
        this.graph = graph;
    }

    @Override
    public PgxFuture<PgxCollection<PgxVertex<ID>, ID>> cloneAsync(String newName) {
        return this.toMutableAsync(newName);
    }

    protected VertexCollection<ID> createCollection(PgxId collectionId, String name) {
        return new VertexSet(this.graph, collectionId, name);
    }

    @Override
    public PgxFuture<Void> addAllElementsAsync(Collection<PgxVertex<ID>> source) {
        throw new IllegalStateException(ErrorMessages.getMessage((String)"IMMUTABLE_COLLECTION", (Object[])new Object[0]));
    }

    @Override
    public PgxFuture<Void> removeAllElementsAsync(Collection<PgxVertex<ID>> source) {
        throw new IllegalStateException(ErrorMessages.getMessage((String)"IMMUTABLE_COLLECTION", (Object[])new Object[0]));
    }

    @Override
    public PgxFuture<Void> clearAsync() {
        throw new IllegalStateException(ErrorMessages.getMessage((String)"IMMUTABLE_COLLECTION", (Object[])new Object[0]));
    }

    @Override
    protected PgxFuture<CollectionProxy> getProxyAsync() {
        return this.core.getComponentCollectionProxy(this.getSessionContext(), this.getId(), this.id);
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyWrappedCollection(this.getSessionContext(), this.getId());
    }

    @Deprecated
    public PgxFuture<Void> destroyAsync(boolean ignoreNotFound) {
        return this.core.destroyWrappedCollection(this.getSessionContext(), this.getId(), ignoreNotFound);
    }

    @Override
    public PgxFuture<PgxCollection<PgxVertex<ID>, ID>> toMutableAsync(String newName) {
        return this.core.createCollectionFromComponent(this.getSessionContext(), this.getId(), this.id, newName).thenApply(collectionInfo -> this.createCollection(collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    @Override
    public PgxFuture<Boolean> isMutableAsync() {
        return PgxFuture.completedFuture(false);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public PgxFuture<Boolean> containsAsync(PgxVertex<ID> element) {
        return this.core.containsElementWrappedCollection(this.getSessionContext(), this.getId(), this.id, element.getId());
    }
}

