/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir.modify;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.modify.Insertion;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;

public abstract class AbstractInsertion
implements Insertion {
    protected List<QueryExpression> labels;
    protected List<SetPropertyExpression> properties;

    public AbstractInsertion(List<QueryExpression> labels, List<SetPropertyExpression> properties) {
        this.labels = labels;
        this.properties = properties;
    }

    public List<QueryExpression> getLabels() {
        return this.labels;
    }

    public void setLabels(List<QueryExpression> labels) {
        this.labels = labels;
    }

    public List<SetPropertyExpression> getProperties() {
        return this.properties;
    }

    public void setProperties(List<SetPropertyExpression> properties) {
        this.properties = properties;
    }

    protected String printLabels() {
        if (this.labels.isEmpty()) {
            return "";
        }
        return " LABELS ( " + this.labels.stream().map(x -> PgqlUtils.printIdentifier((String)((QueryExpression.Constant.ConstString)x).getValue(), false)).collect(Collectors.joining(", ")) + " )";
    }

    protected String printProperties() {
        if (this.properties.isEmpty()) {
            return "";
        }
        return " PROPERTIES ( " + this.properties.stream().map(x -> x.toString()).collect(Collectors.joining(", ")) + " )";
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInsertion other = (AbstractInsertion)obj;
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

