/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.providers;

import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.coherence.rest.providers.EntryWriter;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

@Provider
@Produces(value={"application/xml"})
public class XmlCollectionWriter
implements MessageBodyWriter<Collection<?>> {
    @Inject
    protected MarshallerRegistry m_marshallerRegistry;

    public XmlCollectionWriter() {
    }

    public XmlCollectionWriter(MarshallerRegistry registry) {
        this.m_marshallerRegistry = registry;
    }

    public boolean isWriteable(Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        return Collection.class.isAssignableFrom(clz);
    }

    public long getSize(Collection<?> col, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<?> oCol, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream stream) throws IOException, WebApplicationException {
        MarshallerRegistry registry = this.m_marshallerRegistry;
        if (registry == null) {
            throw new IllegalStateException("MarshallerRegistry not configured");
        }
        EntryWriter entryWriter = new EntryWriter(registry);
        PrintStream out = new PrintStream(stream);
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.print("<collection>");
        for (Object o : oCol) {
            if (o instanceof Map.Entry) {
                entryWriter.writeTo(o, o.getClass(), null, null, mediaType, null, stream);
                continue;
            }
            if (o == null) continue;
            Marshaller marshaller = registry.getMarshaller(o.getClass(), mediaType);
            marshaller.marshalAsFragment(o, stream, httpHeaders);
        }
        out.print("</collection>");
    }
}

