/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.oracle.coherence.common.base.Logger;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class RestHelper {
    public static Map<String, Object> getQueryParameters(UriInfo uriInfo) {
        MultivaluedMap mapQueryParams = uriInfo.getQueryParameters();
        HashMap<String, Object> mapParams = new HashMap<String, Object>(mapQueryParams.size());
        Iterator iterator = mapQueryParams.keySet().iterator();
        while (iterator.hasNext()) {
            String sKey;
            List listValues = (List)mapQueryParams.get((Object)(sKey = (String)iterator.next()));
            mapParams.put(sKey, listValues.size() == 1 ? listValues.get(0) : listValues);
        }
        return mapParams;
    }

    public static int resolveMaxResults(int cParamMax, int cQueryMax, int cResourceMax) {
        int cMax = cResourceMax;
        if (cQueryMax >= 0) {
            cMax = cQueryMax;
        }
        if (cParamMax >= 0) {
            cMax = cMax >= 0 ? Math.min(cParamMax, cMax) : cParamMax;
        }
        return cMax;
    }

    public static void log(Exception ex) {
        if (ex instanceof RuntimeException && ex.getMessage().contains("unknown user type")) {
            throw (RuntimeException)ex;
        }
        Logger.finer(() -> {
            Throwable exCause = ex.getCause();
            String sCause = exCause == null ? null : String.format(" Cause: " + exCause.getClass().getName() + " : " + exCause.getLocalizedMessage(), new Object[0]);
            return "Rest Server exception: " + ex.getClass().getName() + " : " + ex.getLocalizedMessage() + sCause;
        });
    }
}

