/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.providers;

import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.util.SubList;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
public class ObjectWriter
implements MessageBodyWriter<Object> {
    @Inject
    private MarshallerRegistry m_marshallerRegistry;

    public ObjectWriter() {
    }

    public ObjectWriter(MarshallerRegistry registry) {
        this.m_marshallerRegistry = registry;
    }

    public boolean isWriteable(Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        if (SubList.class.isAssignableFrom(clz)) {
            return false;
        }
        return this.m_marshallerRegistry.getMarshaller(clz, mediaType) != null;
    }

    public long getSize(Object obj, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object obj, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream stream) throws IOException, WebApplicationException {
        Marshaller marshaller = this.m_marshallerRegistry.getMarshaller(obj == null ? clz : obj.getClass(), mediaType);
        marshaller.marshal(obj, stream, httpHeaders);
    }
}

