/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest;

import com.tangosol.coherence.rest.util.PropertySet;
import com.tangosol.coherence.rest.util.aggregator.AggregatorRegistry;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.processor.ConditionalRemove;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EntrySetResource {
    protected NamedCache m_cache;
    protected Set m_setKeys;
    protected Class m_clzValue;
    @Inject
    protected AggregatorRegistry m_aggregatorRegistry;
    @Inject
    protected ProcessorRegistry m_processorRegistry;

    public EntrySetResource(NamedCache cache, Set setKeys, Class clzValue) {
        this.m_cache = cache;
        this.m_setKeys = setKeys;
        this.m_clzValue = clzValue;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/octet-stream"})
    public Response getValues(@MatrixParam(value="p") PropertySet propertySet) {
        Collection<Object> colValues = this.values();
        return Response.ok((Object)(propertySet == null ? colValues : propertySet.extract(colValues))).build();
    }

    @GET
    @Path(value="entries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response getEntries(@MatrixParam(value="p") PropertySet propertySet) {
        Map mapResults = this.m_cache.getAll((Collection)this.m_setKeys);
        Collection colResults = mapResults.entrySet().stream().map(entry -> propertySet == null ? entry : new SimpleMapEntry(entry.getKey(), propertySet.extract(entry.getValue()))).collect(Collectors.toList());
        return Response.ok((Object)colResults).build();
    }

    @GET
    @Path(value="{aggr: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response aggregate(@PathParam(value="aggr") String sAggr) {
        InvocableMap.EntryAggregator aggr = this.m_aggregatorRegistry.getAggregator(sAggr);
        Object oResult = this.m_cache.aggregate((Collection)this.m_setKeys, aggr);
        return Response.ok((Object)oResult).build();
    }

    @POST
    @Path(value="{proc: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml"})
    public Response process(@PathParam(value="proc") String sProc) {
        InvocableMap.EntryProcessor proc = this.m_processorRegistry.getProcessor(sProc);
        Map mapResult = this.m_cache.invokeAll((Collection)this.m_setKeys, proc);
        return Response.ok((Object)mapResult).build();
    }

    @DELETE
    public Response delete() {
        this.remove();
        return Response.ok().build();
    }

    protected Collection values() {
        return this.m_cache.getAll((Collection)this.m_setKeys).values();
    }

    protected void remove() {
        this.m_cache.invokeAll((Collection)this.m_setKeys, (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)AlwaysFilter.INSTANCE));
    }
}

