/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.providers;

import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/xml", "application/json"})
public class EntryWriter
implements MessageBodyWriter<Object> {
    @Inject
    private MarshallerRegistry m_marshallerRegistry;

    public EntryWriter() {
    }

    public EntryWriter(MarshallerRegistry registry) {
        this.m_marshallerRegistry = registry;
    }

    public boolean isWriteable(Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        return Map.Entry.class.isAssignableFrom(clz);
    }

    public long getSize(Object entry, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object oEntry, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream stream) throws IOException, WebApplicationException {
        Map.Entry entry = (Map.Entry)oEntry;
        Object oKey = entry.getKey();
        Object oValue = entry.getValue();
        Marshaller keyMarshaller = this.m_marshallerRegistry.getMarshaller(oKey.getClass(), mediaType);
        Marshaller valueMarshaller = this.m_marshallerRegistry.getMarshaller(oValue.getClass(), mediaType);
        PrintStream out = new PrintStream(stream);
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            out.print("{\"key\":");
            keyMarshaller.marshalAsFragment(oKey, stream, httpHeaders);
            out.print(",\"value\":");
            valueMarshaller.marshalAsFragment(oValue, stream, httpHeaders);
            out.print("}");
        } else if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            out.print("<entry><key>");
            keyMarshaller.marshalAsFragment(oKey, stream, httpHeaders);
            out.print("</key><value>");
            valueMarshaller.marshalAsFragment(oValue, stream, httpHeaders);
            out.print("</value></entry>");
        }
    }
}

