/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.server;

import com.tangosol.coherence.rest.DefaultRootResource;
import com.tangosol.coherence.rest.providers.EntryWriter;
import com.tangosol.coherence.rest.providers.JacksonMapperProvider;
import com.tangosol.coherence.rest.providers.JsonCollectionWriter;
import com.tangosol.coherence.rest.providers.ObjectWriter;
import com.tangosol.coherence.rest.providers.SecurityExceptionMapper;
import com.tangosol.coherence.rest.providers.SecurityFilter;
import com.tangosol.coherence.rest.providers.XmlCollectionWriter;
import com.tangosol.coherence.rest.providers.XmlKeysWriter;
import com.tangosol.coherence.rest.providers.XmlMapWriter;
import com.tangosol.coherence.rest.server.InjectionBinder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.sse.SseFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.UriConnegFilter;

@ApplicationPath(value="/api")
public class DefaultResourceConfig
extends ResourceConfig {
    public DefaultResourceConfig() {
        this((String[])null);
    }

    public DefaultResourceConfig(Class<?> classes) {
        super(new Class[]{classes});
        this.registerProviders();
        this.registerRootResource();
        this.registerContainerRequestFilters();
        this.registerContainerResponseFilters();
        this.registerResourceFilterFactories();
    }

    public DefaultResourceConfig(String ... asPackages) {
        if (asPackages != null && asPackages.length > 0) {
            this.packages(asPackages);
        }
        this.registerProviders();
        this.registerRootResource();
        this.registerContainerRequestFilters();
        this.registerContainerResponseFilters();
        this.registerResourceFilterFactories();
    }

    public String toString() {
        return "DefaultResourceConfig";
    }

    protected void registerRootResource() {
        this.register(DefaultRootResource.class);
    }

    protected void registerProviders() {
        this.register((Object)new InjectionBinder(this.isRunningInContainer()));
        this.register(SecurityExceptionMapper.class);
        this.register(XmlKeysWriter.class);
        this.register(JsonCollectionWriter.class);
        this.register(XmlCollectionWriter.class);
        this.register(XmlMapWriter.class);
        this.register(EntryWriter.class);
        this.register(ObjectWriter.class);
        this.register(SecurityFilter.class);
        this.register(JacksonMapperProvider.class);
        this.register(JacksonFeature.class);
        this.register(SseFeature.class);
    }

    protected void registerContainerRequestFilters() {
        this.register(new UriConnegFilter(DefaultResourceConfig.getExtensionsMap(), new LinkedHashMap()));
    }

    protected void registerContainerResponseFilters() {
    }

    protected void registerResourceFilterFactories() {
    }

    protected boolean isRunningInContainer() {
        return false;
    }

    protected static Map<String, MediaType> getExtensionsMap() {
        LinkedHashMap<String, MediaType> map = new LinkedHashMap<String, MediaType>(4);
        map.put("txt", MediaType.TEXT_PLAIN_TYPE);
        map.put("bin", MediaType.APPLICATION_OCTET_STREAM_TYPE);
        map.put("xml", MediaType.APPLICATION_XML_TYPE);
        map.put("json", MediaType.APPLICATION_JSON_TYPE);
        return map;
    }
}

