/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.providers;

import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/xml"})
public class XmlKeysWriter
implements MessageBodyWriter<Set> {
    @Inject
    protected MarshallerRegistry m_marshallerRegistry;

    public XmlKeysWriter() {
    }

    public XmlKeysWriter(MarshallerRegistry registry) {
        this.m_marshallerRegistry = registry;
    }

    public boolean isWriteable(Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        for (Annotation anno : aAnnotation) {
            if (!Path.class.equals(anno.annotationType()) || !"keys".equals(((Path)anno).value())) continue;
            return true;
        }
        return false;
    }

    public long getSize(Set set, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Set set, Class<?> clz, Type type, Annotation[] aAnnotation, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream stream) throws IOException, WebApplicationException {
        MarshallerRegistry registry = this.m_marshallerRegistry;
        if (registry == null) {
            throw new IllegalStateException("MarshallerRegistry not configured");
        }
        PrintStream out = new PrintStream(stream);
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.print("<keys>");
        for (Object o : set) {
            if (o == null) continue;
            out.print("<key>");
            Marshaller marshaller = registry.getMarshaller(o.getClass(), mediaType);
            marshaller.marshalAsFragment(o, stream, httpHeaders);
            out.print("</key>");
        }
        out.print("</keys>");
    }
}

