/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.io;

import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.util.StaticContent;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class StaticContentMarshaller
implements Marshaller<StaticContent> {
    @Override
    public void marshal(StaticContent value, OutputStream out, MultivaluedMap<String, Object> httpHeaders) throws IOException {
        httpHeaders.putSingle((Object)"Content-Type", (Object)value.getMediaType());
        value.getContent().writeTo(out);
    }

    @Override
    public StaticContent unmarshal(InputStream in, MediaType mediaType) throws IOException {
        Binary binContent = Binary.readBinary((InputStream)in);
        String sMediaType = mediaType.getType() + "/" + mediaType.getSubtype();
        return new StaticContent(binContent, sMediaType);
    }
}

