/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest;

import com.tangosol.coherence.rest.config.NamedQuery;
import com.tangosol.coherence.rest.events.MapEventOutput;
import com.tangosol.coherence.rest.query.Query;
import com.tangosol.coherence.rest.query.QueryEngine;
import com.tangosol.coherence.rest.query.QueryEngineRegistry;
import com.tangosol.coherence.rest.util.PropertySet;
import com.tangosol.coherence.rest.util.RestHelper;
import com.tangosol.coherence.rest.util.aggregator.AggregatorRegistry;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.QueryHelper;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.ValueExtractor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class NamedQueryResource {
    protected NamedCache m_cache;
    protected NamedQuery m_query;
    protected int m_cMaxResults;
    @Inject
    protected QueryEngineRegistry m_registry;
    @Inject
    protected AggregatorRegistry m_aggregatorRegistry;
    @Inject
    protected ProcessorRegistry m_processorRegistry;

    public NamedQueryResource(NamedCache cache, NamedQuery query, int cMaxResults) {
        this.m_cache = cache;
        this.m_query = query;
        this.m_cMaxResults = cMaxResults;
    }

    @GET
    @Path(value="{aggr: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response aggregate(@Context UriInfo uriInfo, @PathParam(value="aggr") String sAggr) {
        InvocableMap.EntryAggregator aggregator;
        try {
            aggregator = this.m_aggregatorRegistry.getAggregator(sAggr);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set colKeys = this.keys(uriInfo);
        Object oResult = this.m_cache.aggregate((Collection)colKeys, aggregator);
        return Response.ok((Object)oResult).build();
    }

    @POST
    @Path(value="{proc: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml"})
    public Response process(@Context UriInfo uriInfo, @PathParam(value="proc") String sProc) {
        InvocableMap.EntryProcessor processor;
        try {
            processor = this.m_processorRegistry.getProcessor(sProc);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An exception occurred while processing the request.").build();
        }
        Set colKeys = this.keys(uriInfo);
        Map mapResult = this.m_cache.invokeAll((Collection)colKeys, processor);
        return Response.ok((Object)mapResult).build();
    }

    @GET
    public Response getValues(@Context UriInfo uriInfo, @MatrixParam(value="start") @DefaultValue(value="0") int nStart, @MatrixParam(value="count") @DefaultValue(value="-1") int cResults, @MatrixParam(value="sort") String sSort, @MatrixParam(value="p") PropertySet propertySet) {
        ValueExtractor extractor = Map.Entry::getValue;
        if (propertySet != null) {
            extractor = extractor.andThen((ValueExtractor)propertySet);
        }
        try {
            return Response.ok((Object)this.executeQuery(uriInfo, extractor, nStart, cResults, sSort)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An exception occurred while processing the request.").build();
        }
    }

    @GET
    @Path(value="entries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response getEntries(@Context UriInfo uriInfo, @MatrixParam(value="start") @DefaultValue(value="0") int nStart, @MatrixParam(value="count") @DefaultValue(value="-1") int cResults, @MatrixParam(value="sort") String sSort, @MatrixParam(value="p") PropertySet propertySet) {
        ValueExtractor & Serializable extractor = propertySet == null ? ValueExtractor.identity() : (ValueExtractor & Serializable)entry -> new SimpleMapEntry(entry.getKey(), propertySet.extract(entry.getValue()));
        try {
            return Response.ok((Object)this.executeQuery(uriInfo, extractor, nStart, cResults, sSort)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"An exception occurred while processing the request.").build();
        }
    }

    @GET
    @Path(value="keys")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response getKeys(@Context UriInfo uriInfo) {
        Set setKeys = this.keys(uriInfo);
        return Response.ok((Object)setKeys).build();
    }

    @GET
    @Produces(value={"text/event-stream"})
    public MapEventOutput addListener(@MatrixParam(value="lite") boolean fLite, @Context UriInfo uriInfo) {
        if ("DEFAULT".equals(this.m_query.getQueryEngineName())) {
            Map<String, Object> mapParams = RestHelper.getQueryParameters(uriInfo);
            MapEventOutput eventOutput = new MapEventOutput(this.m_cache, fLite);
            eventOutput.setFilter(QueryHelper.createFilter((String)this.m_query.getExpression(), mapParams));
            eventOutput.register();
            return eventOutput;
        }
        return null;
    }

    protected Collection executeQuery(UriInfo uriInfo, ValueExtractor<Map.Entry, ?> extractor, int nStart, int cResults, String sSort) {
        NamedQuery namedQuery = this.m_query;
        String sQueryEngine = namedQuery.getQueryEngineName();
        QueryEngine queryEngine = this.m_registry.getQueryEngine(sQueryEngine);
        Map<String, Object> mapParams = RestHelper.getQueryParameters(uriInfo);
        int cMaxResults = RestHelper.resolveMaxResults(cResults, namedQuery.getMaxResults(), this.m_cMaxResults);
        Query query = queryEngine.prepareQuery(namedQuery.getExpression(), mapParams);
        return query.execute(this.m_cache, extractor, sSort, nStart, cMaxResults);
    }

    protected Set keys(UriInfo uriInfo) {
        NamedQuery namedQuery = this.m_query;
        String sQueryEngine = namedQuery.getQueryEngineName();
        QueryEngine queryEngine = this.m_registry.getQueryEngine(sQueryEngine);
        Map<String, Object> mapParams = RestHelper.getQueryParameters(uriInfo);
        Query query = queryEngine.prepareQuery(namedQuery.getExpression(), mapParams);
        return query.keySet(this.m_cache);
    }
}

