/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class LineMapper {
    private char[] expr;
    private ArrayList<Node> lineMapping;
    private Set<Integer> lines;

    public LineMapper(char[] expr) {
        this.expr = expr;
    }

    public LineLookup map() {
        int cursor;
        this.lineMapping = new ArrayList();
        this.lines = new TreeSet<Integer>();
        int start = 0;
        int line = 1;
        for (cursor = 0; cursor < this.expr.length; ++cursor) {
            switch (this.expr[cursor]) {
                case '\n': {
                    this.lines.add(line);
                    this.lineMapping.add(new Node(start, cursor, line++));
                    start = cursor + 1;
                }
            }
        }
        if (cursor > start) {
            this.lines.add(line);
            this.lineMapping.add(new Node(start, cursor, line));
        }
        return new LineLookup(){

            @Override
            public int getLineFromCursor(int cursor) {
                for (Node n : LineMapper.this.lineMapping) {
                    if (!n.isInRange(cursor)) continue;
                    return n.getLine();
                }
                return -1;
            }

            @Override
            public boolean hasLine(int line) {
                return LineMapper.this.lines.contains(line);
            }
        };
    }

    private static class Node
    implements Comparable<Node> {
        private int cursorStart;
        private int cursorEnd;
        private int line;

        private Node(int cursorStart, int cursorEnd, int line) {
            this.cursorStart = cursorStart;
            this.cursorEnd = cursorEnd;
            this.line = line;
        }

        public int getLine() {
            return this.line;
        }

        public boolean isInRange(int cursor) {
            return cursor >= this.cursorStart && cursor <= this.cursorEnd;
        }

        @Override
        public int compareTo(Node node) {
            if (node.cursorStart >= this.cursorEnd) {
                return 1;
            }
            if (node.cursorEnd < this.cursorStart) {
                return -1;
            }
            return 0;
        }
    }

    public static interface LineLookup {
        public int getLineFromCursor(int var1);

        public boolean hasLine(int var1);
    }
}

