/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.server;

import com.tangosol.coherence.rest.config.RestConfig;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.coherence.rest.query.QueryEngineRegistry;
import com.tangosol.coherence.rest.util.aggregator.AggregatorRegistry;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;

public class InjectionBinder
extends AbstractBinder {
    protected final boolean m_fContainer;

    public InjectionBinder(boolean fContainer) {
        this.m_fContainer = fContainer;
    }

    protected void configure() {
        if (this.m_fContainer) {
            this.bind(Session.create((Session.Option[])new Session.Option[]{WithClassLoader.autoDetect()})).to(Session.class);
        }
        ((SupplierClassBinding)this.bindFactory(RestConfigFactory.class).to(RestConfig.class)).in(Singleton.class);
        ((SupplierClassBinding)this.bindFactory(MarshallerRegistryFactory.class).to(MarshallerRegistry.class)).in(Singleton.class);
        ((SupplierClassBinding)this.bindFactory(ProcessorRegistryFactory.class).to(ProcessorRegistry.class)).in(Singleton.class);
        ((SupplierClassBinding)this.bindFactory(AggregatorRegistryFactory.class).to(AggregatorRegistry.class)).in(Singleton.class);
        ((SupplierClassBinding)this.bindFactory(QueryEngineRegistryFactory.class).to(QueryEngineRegistry.class)).in(Singleton.class);
    }

    public static <T> T inject(T resource, ServiceLocator locator) {
        locator.inject(resource);
        locator.postConstruct(resource);
        return resource;
    }

    private static class RestConfigFactory
    implements Supplier<RestConfig> {
        private RestConfigFactory() {
        }

        @Override
        public RestConfig get() {
            return RestConfig.create();
        }
    }

    private static class MarshallerRegistryFactory
    implements Supplier<MarshallerRegistry> {
        @Inject
        private RestConfig m_config;

        private MarshallerRegistryFactory() {
        }

        @Override
        public MarshallerRegistry get() {
            return this.m_config != null ? this.m_config.getMarshallerRegistry() : new MarshallerRegistry();
        }
    }

    private static class ProcessorRegistryFactory
    implements Supplier<ProcessorRegistry> {
        @Inject
        private RestConfig m_config;

        private ProcessorRegistryFactory() {
        }

        @Override
        public ProcessorRegistry get() {
            return this.m_config != null ? this.m_config.getProcessorRegistry() : new ProcessorRegistry();
        }
    }

    private static class AggregatorRegistryFactory
    implements Supplier<AggregatorRegistry> {
        @Inject
        private RestConfig m_config;

        private AggregatorRegistryFactory() {
        }

        @Override
        public AggregatorRegistry get() {
            return this.m_config != null ? this.m_config.getAggregatorRegistry() : new AggregatorRegistry();
        }
    }

    private static class QueryEngineRegistryFactory
    implements Supplier<QueryEngineRegistry> {
        @Inject
        private RestConfig m_config;

        private QueryEngineRegistryFactory() {
        }

        @Override
        public QueryEngineRegistry get() {
            return this.m_config != null ? this.m_config.getQueryEngineRegistry() : new QueryEngineRegistry();
        }
    }
}

