/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.metrics;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.net.metrics.MetricsRegistryAdapter;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MpMetricsRegistryAdapter
implements MetricsRegistryAdapter {
    private final MetricRegistry f_vendorRegistry;
    private final MetricRegistry f_appRegistry;

    @Inject
    MpMetricsRegistryAdapter(@RegistryType(type=MetricRegistry.Type.VENDOR) MetricRegistry vendorRegistry, @RegistryType(type=MetricRegistry.Type.APPLICATION) MetricRegistry appRegistry) {
        this.f_vendorRegistry = Objects.requireNonNull(vendorRegistry);
        this.f_appRegistry = Objects.requireNonNull(appRegistry);
    }

    public synchronized void register(MBeanMetric metric) {
        String sName = metric.getName();
        String sDescription = this.getDescription(metric);
        Tag[] aTags = this.getTags(metric.getIdentifier());
        MetricID id = new MetricID(sName, aTags);
        Metadata metadata = Metadata.builder().withName(sName).withDescription(sDescription).withType(MetricType.GAUGE).build();
        MBeanMetricGauge gauge = new MBeanMetricGauge(metric);
        switch (metric.getScope()) {
            case VENDOR: {
                if (this.f_vendorRegistry.getGauges().containsKey(id)) break;
                this.f_vendorRegistry.register(metadata, (Metric)gauge, aTags);
                break;
            }
            case APPLICATION: {
                if (this.f_appRegistry.getGauges().containsKey(id)) break;
                this.f_appRegistry.register(metadata, (Metric)gauge, aTags);
                break;
            }
        }
    }

    public void remove(MBeanMetric.Identifier identifier) {
        Tag[] aTags = this.getTags(identifier);
        MetricID id = new MetricID(identifier.getName(), aTags);
        switch (identifier.getScope()) {
            case VENDOR: {
                if (!this.f_vendorRegistry.getGauges().containsKey(id)) break;
                this.f_vendorRegistry.remove(id);
                break;
            }
            case APPLICATION: {
                if (!this.f_appRegistry.getGauges().containsKey(id)) break;
                this.f_appRegistry.remove(id);
                break;
            }
        }
    }

    Tag[] getTags(MBeanMetric.Identifier identifier) {
        String sName = identifier.getName();
        return (Tag[])identifier.getTags().entrySet().stream().map(e -> this.toTag(sName, (Map.Entry<String, String>)e)).filter(Objects::nonNull).toArray(Tag[]::new);
    }

    Tag toTag(String sName, Map.Entry<String, String> entry) {
        String sKey = entry.getKey();
        String sValue = String.valueOf(entry.getValue());
        try {
            return new Tag(sKey, sValue);
        }
        catch (Throwable e) {
            CacheFactory.err((String)String.format("Metric '%s' tag '%s' = '%s' is invalid and will be ignored due to: %s", sName, sKey, sValue, e.getMessage()));
            return null;
        }
    }

    String getDescription(MBeanMetric metric) {
        int nPos;
        String sDescription = metric.getDescription();
        if (sDescription != null && (nPos = sDescription.indexOf(" (MBean '")) > 0) {
            sDescription = sDescription.substring(0, nPos);
        }
        return sDescription;
    }

    private static class MBeanMetricGauge
    implements Gauge<Object> {
        private final MBeanMetric metric;

        private MBeanMetricGauge(MBeanMetric metric) {
            this.metric = metric;
        }

        public Object getValue() {
            Object value = this.metric.getValue();
            return value == null ? Integer.valueOf(0) : value;
        }
    }
}

