/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class CoherenceDefaultsConfigSource
implements ConfigSource {
    private static final String SERVICE_NAME = "coherence.service.name";
    private static final String LOG_DESTINATION = "coherence.log";
    private static final String LOG_LOGGER_NAME = "coherence.log.logger";
    private static final String LOG_MESSAGE_FORMAT = "coherence.log.format";
    private final Map<String, String> f_mapProperties;

    public CoherenceDefaultsConfigSource() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SERVICE_NAME, "${service.name}");
        map.put(LOG_DESTINATION, "jdk");
        map.put(LOG_LOGGER_NAME, "coherence");
        map.put(LOG_MESSAGE_FORMAT, "(thread={thread}, member={member}, up={uptime}): {text}");
        this.f_mapProperties = Collections.unmodifiableMap(map);
    }

    public Map<String, String> getProperties() {
        return this.f_mapProperties;
    }

    public int getOrdinal() {
        return 0;
    }

    public String getValue(String propertyName) {
        return this.f_mapProperties.get(propertyName);
    }

    public String getName() {
        return "CoherenceDefaultsConfigSource";
    }
}

