/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.config;

import com.oracle.coherence.common.base.Logger;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class CdiConfigSourceProvider
implements ConfigSourceProvider {
    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        try {
            Instance sources = CDI.current().select(ConfigSource.class, new Annotation[0]);
            if (sources.isUnsatisfied()) {
                Logger.config((String)"No CDI-managed configuration sources were discovered");
            } else {
                String sSourceNames = sources.stream().map(ConfigSource::getName).collect(Collectors.joining(", "));
                Logger.config((String)("Registering CDI-managed configuration sources: " + sSourceNames));
            }
            return sources;
        }
        catch (IllegalStateException cdiNotAvailable) {
            Logger.info((String)"CDI is not available. No CDI-managed configuration sources will be used.");
            return Collections.emptySet();
        }
    }
}

