/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.management.MapJsonBodyHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class JacksonMapJsonBodyHandler
implements MapJsonBodyHandler {
    private volatile MapJsonBodyHandler m_delegate;

    public void write(Map<String, Object> body, OutputStream out) {
        this.ensureDelegate().write(body, out);
    }

    public Map<String, Object> readMap(InputStream in) {
        return this.ensureDelegate().readMap(in);
    }

    public boolean isEnabled() {
        return this.ensureDelegate().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapJsonBodyHandler ensureDelegate() {
        if (this.m_delegate == null) {
            JacksonMapJsonBodyHandler jacksonMapJsonBodyHandler = this;
            synchronized (jacksonMapJsonBodyHandler) {
                if (this.m_delegate == null) {
                    try {
                        this.m_delegate = new JacksonDelegate();
                    }
                    catch (Throwable t) {
                        Logger.finest((String)("Disabling " + String.valueOf(this.getClass()) + " due to " + t.getMessage()));
                        this.m_delegate = new DisabledDelegate();
                    }
                }
            }
        }
        return this.m_delegate;
    }

    private static class JacksonDelegate
    implements MapJsonBodyHandler {
        private final ObjectMapper f_mapper = JacksonDelegate.createDefaultMapper();

        public void write(Map<String, Object> body, OutputStream out) {
            try {
                this.f_mapper.writeValue(out, body);
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }

        public Map<String, Object> readMap(InputStream in) {
            try {
                return (Map)this.f_mapper.readValue(in, LinkedHashMap.class);
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }

        private static ObjectMapper createDefaultMapper() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
            mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            mapper.configure(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, true);
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
            mapper.configure(MapperFeature.USE_GETTERS_AS_SETTERS, false);
            mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            return mapper;
        }
    }

    private static class DisabledDelegate
    implements MapJsonBodyHandler {
        private DisabledDelegate() {
        }

        public boolean isEnabled() {
            return false;
        }

        public void write(Map<String, Object> body, OutputStream out) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> readMap(InputStream in) {
            throw new UnsupportedOperationException();
        }
    }
}

