/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

public class PersistenceResource
extends AbstractManagementResource {
    public static String[] LINKS = new String[]{"snapshots", "archives"};

    public PersistenceResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        return this.response(this.getResponseEntityForMbean(this.getQuery(), LINKS));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="snapshots")
    public Response getSnapshots() {
        Filter<String> filterAttributes = this.getAttributesFilter("snapshots", this.getExcludeList(null));
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery();
        return this.response(this.getResponseEntityForMbean(bldrQuery, this.getParentUri(), this.getCurrentUri(), filterAttributes, this.getLinksFilter(), new String[0]));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="archives")
    public Response getArchive() {
        return this.response(this.getResponseFromMBeanOperation(this.getQuery(), "archives", "listArchivedSnapshots"));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="archiveStores/{snapshotName}")
    public Response getArchiveStores(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.response(this.getResponseFromMBeanOperation(this.getQuery(), "archiveStores", "listArchivedSnapshotStores", aoArguments, asSignature));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="forceRecovery")
    public Response forceRecovery() {
        return this.executeMBeanOperation(this.getQuery(), "forceRecovery", null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="snapshots/{snapshotName}")
    public Response executeSnapshotOperation(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(this.getQuery(), "createSnapshot", aoArguments, asSignature);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="snapshots/{snapshotName}/recover")
    public Response recoverSnapshot(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(this.getQuery(), "recoverSnapshot", aoArguments, asSignature);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="archives/{snapshotName}")
    public Response executeArchiveOperation(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(this.getQuery(), "archiveSnapshot", aoArguments, asSignature);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="archives/{snapshotName}/retrieve")
    public Response retrieveArchivedSnapshot(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(this.getQuery(), "retrieveArchivedSnapshot", aoArguments, asSignature);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="snapshots/{snapshotName}")
    public Response deleteSnapshot(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(this.getQuery(), "removeSnapshot", aoArguments, asSignature);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="archives/{snapshotName}")
    public Response deleteArchive(@PathParam(value="snapshotName") String sSnapshotName) {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(this.getQuery(), "removeArchivedSnapshot", aoArguments, asSignature);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        URI uriSelf = PersistenceResource.getSubUri(uriParent, "persistence");
        return this.getResponseEntityForMbean(this.getQuery(), uriParent, uriSelf, mapQuery, LINKS);
    }

    protected MBeanAccessor.QueryBuilder getQuery() {
        return this.createQueryBuilder().withBaseQuery(":type=Persistence,responsibility=PersistenceCoordinator").withService(this.getService());
    }
}

