/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class ClusterMemberResource
extends AbstractManagementResource {
    public static final String MEMBER_DUMP_HEAP = "dumpHeap";
    public static final String DIAGNOSTIC_CMD = "diagnostic-cmd";
    public static String[] CHILD_LINKS = null;

    public ClusterMemberResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="memberKey") String sMemberKey) {
        return this.response(this.getResponseEntityForMbean(this.getQuery(sMemberKey), CHILD_LINKS));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="platform/{platformMBean}")
    public Response getPlatformMBeanResponse(@PathParam(value="memberKey") String sMemberKey, @PathParam(value="platformMBean") String sPlatformMBeanType) {
        String sBaseQuery = (String)MAP_PLATFORM_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType);
        if (sBaseQuery == null && (sBaseQuery = (String)MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null && (sBaseQuery = (String)MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(sBaseQuery).withMember(sMemberKey);
        return this.response(this.getResponseEntityForMbean(bldrQuery, new String[0]));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{networkStats}")
    public Response getPointToPointResponse(@PathParam(value="memberKey") String sMemberKey) {
        return this.response(this.getResponseEntityForMbean(this.getPointToPointMBeanQuery(sMemberKey), new String[0]));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="state")
    public Response getStateResponse(@PathParam(value="memberKey") String sMemberKey) throws Exception {
        return this.response(this.getResponseFromMBeanOperation(this.getQuery(sMemberKey), "state", "reportNodeState"));
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(@PathParam(value="memberKey") String sMemberKey, Map<String, Object> entity) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sMemberKey);
        return this.update(entity, bldrQuery);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{operationName:shutdown|resetStatistics}")
    public Response executeOperation(@PathParam(value="memberKey") String sMemberKey, @PathParam(value="operationName") String sOperationName) {
        return this.executeMBeanOperation(this.getQuery(sMemberKey), sOperationName, null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="logMemberState")
    public Response logMemberState(@PathParam(value="memberKey") String sMemberKey) throws Exception {
        return this.executeMBeanOperation(this.getQuery(sMemberKey), "logNodeState", null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="dumpHeap")
    public Response dumpHeap(@PathParam(value="memberKey") String sMemberKey) throws Exception {
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{null};
        return this.executeMBeanOperation(this.getQuery(sMemberKey), MEMBER_DUMP_HEAP, aoArguments, asSignature);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="networkStats/trackWeakest")
    public Response trackWeakestMember(@PathParam(value="memberKey") String sMemberKey) {
        return this.executeMBeanOperation(this.getPointToPointMBeanQuery(sMemberKey), "trackWeakest", null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="diagnostic-cmd/{jfrCmd}")
    public Response diagnosticCmd(@PathParam(value="memberKey") String sMemberKey, @PathParam(value="jfrCmd") String sCmd, @QueryParam(value="options") String sOptions) throws Exception {
        String[] stringArray;
        Object[] objectArray;
        String sBaseQuery = ":type=DiagnosticCommand,Domain=com.sun.management,subType=DiagnosticCommand";
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(sBaseQuery).withMember(sMemberKey);
        if (sOptions == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = sOptions.split(",");
        }
        Object[] aoArguments = objectArray;
        if (sOptions == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String[].class.getName();
        }
        String[] signature = stringArray;
        return this.response(this.getResponseFromMBeanOperation(bldrQuery, "status", sCmd, aoArguments, signature));
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        String sMemberKey = mapArguments.get("memberKey");
        Object oChildren = this.getChildrenQuery(mapQuery);
        URI uriSelf = ClusterMemberResource.getSubUri(uriParent, sMemberKey);
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(uriParent, uriSelf, this.getLinksFilter(mapQuery), CHILD_LINKS);
        Map<String, Object> mapResponse = response.getEntity();
        if (oChildren != null && oChildren instanceof Map) {
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildMbeanQueryResult("networkStats", this.getPointToPointMBeanQuery(sMemberKey), mapResponse, mapChildrenQuery, new String[0]);
            this.addPlatformMBeansQueryResult(sMemberKey, mapResponse, mapChildrenQuery);
        }
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sMemberKey) {
        return this.createQueryBuilder().withBaseQuery(":type=Node").withMember(sMemberKey);
    }

    protected MBeanAccessor.QueryBuilder getPointToPointMBeanQuery(String sMemberKey) {
        return this.createQueryBuilder().withBaseQuery(":type=PointToPoint").withMember(sMemberKey);
    }

    protected Object getPlatformChildrenQueryMap(Map mapQuery) {
        Object oPlatformQuery = mapQuery.get("platform");
        Object oChildrenQueryObject = null;
        if (oPlatformQuery != null && oPlatformQuery instanceof Map) {
            oChildrenQueryObject = ((Map)oPlatformQuery).get("children");
        }
        return oChildrenQueryObject;
    }

    protected void addPlatformMBeansQueryResult(String sMemberId, Map<String, Object> mapResponse, Map mapQuery) {
        Object oChildrenQueryObject = this.getPlatformChildrenQueryMap(mapQuery);
        if (oChildrenQueryObject != null && oChildrenQueryObject instanceof Map) {
            MBeanAccessor.QueryBuilder bldrQuery;
            String sPlatformMBeanKey;
            LinkedHashMap<String, Object> mapPlatform = new LinkedHashMap<String, Object>();
            Map mapPlatformChildrenQueryMap = (Map)oChildrenQueryObject;
            for (Map.Entry entry : MAP_PLATFORM_URL_TO_MBEAN_QUERY.entrySet()) {
                sPlatformMBeanKey = (String)entry.getKey();
                bldrQuery = this.createQueryBuilder().withBaseQuery((String)entry.getValue()).withMember(sMemberId);
                this.addChildMbeanQueryResult(sPlatformMBeanKey, bldrQuery, mapPlatform, mapPlatformChildrenQueryMap, new String[0]);
            }
            for (Map.Entry entry : MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.entrySet()) {
                sPlatformMBeanKey = (String)entry.getKey();
                bldrQuery = this.createQueryBuilder().withBaseQuery((String)entry.getValue()).withMember(sMemberId);
                this.addChildMbeanQueryResult(sPlatformMBeanKey, bldrQuery, mapPlatform, mapPlatformChildrenQueryMap, new String[0]);
            }
            for (Map.Entry entry : MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.entrySet()) {
                sPlatformMBeanKey = (String)entry.getKey();
                bldrQuery = this.createQueryBuilder().withBaseQuery((String)entry.getValue()).withMember(sMemberId);
                this.addChildMbeanQueryResult(sPlatformMBeanKey, bldrQuery, mapPlatform, mapPlatformChildrenQueryMap, new String[0]);
            }
            mapResponse.put("platform", mapPlatform);
        }
    }

    static {
        ArrayList<String> listChildLinks = new ArrayList<String>();
        listChildLinks.addAll(MAP_PLATFORM_URL_TO_MBEAN_QUERY.keySet().stream().map(s -> "platform/" + s).collect(Collectors.toSet()));
        listChildLinks.addAll(MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.keySet().stream().map(s -> "platform/" + s).collect(Collectors.toSet()));
        listChildLinks.addAll(MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.keySet().stream().map(s -> "platform/" + s).collect(Collectors.toSet()));
        listChildLinks.add("networkStats");
        CHILD_LINKS = listChildLinks.toArray(new String[0]);
    }
}

