/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.Converter;
import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class StorageManagerResource
extends AbstractManagementResource {
    public StorageManagerResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="cacheName") String sCacheName, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(sCacheName);
        Set setObjectNames = this.getMBeanAccessor().queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        EntityMBeanResponse responseEntity = this.createResponse(this.getParentUri(), this.getCurrentUri(), this.getLinksFilter());
        this.addObjectNamesToResponse(setObjectNames, responseEntity);
        Map<String, Object> mapResponse = responseEntity.toJson();
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, queryBuilder, mapResponse);
        return this.response(mapResponse);
    }

    @POST
    @Produces(value={"application/json"})
    public Response resetStatistics(@PathParam(value="cacheName") String sCacheName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sCacheName);
        return this.executeMBeanOperation(bldrQuery, "resetStatistics", null, null);
    }

    @POST
    @Path(value="clear")
    @Produces(value={"application/json"})
    public Response clearCache(@PathParam(value="cacheName") String sCacheName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sCacheName);
        return this.executeMBeanOperation(bldrQuery, "clearCache", null, null);
    }

    @POST
    @Path(value="truncate")
    @Produces(value={"application/json"})
    public Response truncateCache(@PathParam(value="cacheName") String sCacheName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sCacheName);
        return this.executeMBeanOperation(bldrQuery, "truncateCache", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        String sCacheName = mapArguments.get("cache");
        URI uriSelf = StorageManagerResource.getSubUri(uriParent, sCacheName);
        Filter<String> filterLinks = this.getLinksFilter(mapQuery);
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sCacheName);
        Set setObjectNames = this.getMBeanAccessor().queryKeys(bldrQuery.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return null;
        }
        EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
        this.addObjectNamesToResponse(setObjectNames, responseEntity);
        Map<String, Object> mapEntity = responseEntity.getEntity();
        this.addAggregatedMetricsToResponseMap("*", null, bldrQuery, mapEntity);
        return responseEntity;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sCacheName) {
        return this.createQueryBuilder().withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService());
    }

    protected void addObjectNamesToResponse(Set<String> setObjectNames, EntityMBeanResponse responseEntity) {
        Filter<String> filterAttributes = this.getAttributesFilter();
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        if (filterAttributes instanceof AlwaysFilter) {
            filterAttributes = this.getAttributesFilter(String.join((CharSequence)",", "cache", "service", "nodeId"), null);
        }
        for (String sName : setObjectNames) {
            try {
                ObjectName objectName = new ObjectName(sName);
                for (String sKey : objectName.getKeyPropertyList().keySet()) {
                    if (!filterAttributes.evaluate((Object)sKey)) continue;
                    Object oValue = Converter.convert(objectName.getKeyProperty(sKey));
                    Object oCurrent = mapAttributes.get(sKey);
                    if (oCurrent == null) {
                        mapAttributes.put(sKey, oValue);
                        continue;
                    }
                    if (oCurrent instanceof Set) {
                        ((Set)oCurrent).add(oValue);
                        continue;
                    }
                    if (Objects.equals(oCurrent, oValue)) continue;
                    HashSet<Object> values = new HashSet<Object>();
                    values.add(oCurrent);
                    values.add(oValue);
                    mapAttributes.put(sKey, values);
                }
            }
            catch (MalformedObjectNameException e) {
                CacheFactory.log((String)("Exception occurred while creating an ObjectName " + sName + "\n" + CacheFactory.getStackTrace((Throwable)e)));
            }
        }
        responseEntity.setEntity(mapAttributes);
    }
}

