/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.CachesResource;
import com.tangosol.coherence.management.internal.resources.PersistenceResource;
import com.tangosol.coherence.management.internal.resources.ServiceMembersResource;
import com.tangosol.coherence.management.internal.resources.StorageManagersResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class ServiceResource
extends AbstractManagementResource {
    public static final String SCHEDULED_DISTRIBUTIONS = "scheduledDistributions";
    public static String[] CHILD_LINKS = new String[]{"caches", "members", "partition", "storage"};

    public ServiceResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="serviceName") String sServiceName, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sServiceName);
        Filter<String> filterAttributes = this.getAttributesFilter("name,type,domainPartition", this.getExcludeList(null));
        EntityMBeanResponse response = this.getResponseEntityForMbean(bldrQuery, this.getParentUri(), this.getCurrentUri(), filterAttributes, this.getLinksFilter(), CHILD_LINKS);
        if (response == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, bldrQuery, responseMap);
        return this.response(responseMap);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="partition")
    public Response getPartitionAssignment(@PathParam(value="serviceName") String sServiceName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getPartitionAssignmentQuery(sServiceName);
        return this.response(this.getResponseEntityForMbean(bldrQuery, SCHEDULED_DISTRIBUTIONS));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="partition/scheduledDistributions")
    public Response getScheduledDistributions(@PathParam(value="serviceName") String sServiceName, @QueryParam(value="verbose") Boolean fVerbose) {
        String[] asSignature = new String[]{Boolean.TYPE.getName()};
        Object[] aoArguments = new Object[]{fVerbose != null ? fVerbose : false};
        MBeanAccessor.QueryBuilder bldrQuery = this.getPartitionAssignmentQuery(sServiceName);
        return this.response(this.getResponseFromMBeanOperation(bldrQuery, SCHEDULED_DISTRIBUTIONS, "reportScheduledDistributions", aoArguments, asSignature));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="proxy")
    public Response getAggregatedProxyMetricsResponse(@PathParam(value="serviceName") String sServiceName, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        EntityMBeanResponse responseEntity = this.getLinksOnlyResponseBody(this.getParentUri(), this.getCurrentUri(), new String[0]);
        Map<String, Object> responseMap = responseEntity.toJson();
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(":type=ConnectionManager,name=" + sServiceName);
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, bldrQuery, responseMap);
        return this.response(responseMap);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="description")
    public Response getServiceDescription(@PathParam(value="serviceName") String sServiceName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sServiceName);
        return this.response(this.getResponseFromMBeanOperation(bldrQuery, "description", "getServiceDescription"));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="suspend")
    public Response suspendService(@PathParam(value="serviceName") String sServiceName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(":type=Cluster");
        return this.executeMBeanOperation(bldrQuery, "suspendService", new Object[]{sServiceName}, new String[]{String.class.getName()});
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="resume")
    public Response resumeService(@PathParam(value="serviceName") String sServiceName) {
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(":type=Cluster");
        return this.executeMBeanOperation(bldrQuery, "resumeService", new Object[]{sServiceName}, new String[]{String.class.getName()});
    }

    @Path(value="members")
    public Object getMembersResource() {
        return new ServiceMembersResource(this);
    }

    @Path(value="caches")
    public Object getCachesResource() {
        return new CachesResource(this);
    }

    @Path(value="persistence")
    public Object getPersistenceResource() {
        return new PersistenceResource(this);
    }

    @Path(value="storage")
    public Object getStorageManagersResource() {
        return new StorageManagersResource(this);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        Filter<String> filterAttributes;
        String sServiceName = MBeanHelper.safeUnquote((String)mapArguments.get("name"));
        URI uriSelf = ServiceResource.getSubUri(uriParent, sServiceName);
        Filter<String> filterLinks = this.getLinksFilter(mapQuery);
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sServiceName);
        EntityMBeanResponse response = this.getResponseEntityForMbean(bldrQuery, uriParent, uriSelf, filterAttributes = this.getAttributesFilter("name,type,domainPartition", this.getExcludeList(mapQuery)), filterLinks, CHILD_LINKS);
        if (response != null) {
            Object oChildren = this.getChildrenQuery(mapQuery);
            Map<String, Object> mapEntity = response.getEntity();
            this.addAggregatedMetricsToResponseMap("*", null, bldrQuery, mapEntity);
            if (oChildren != null && oChildren instanceof Map) {
                Map mapChildrenQuery = (Map)oChildren;
                bldrQuery = this.getQuery(sServiceName);
                this.addChildMbeanQueryResult("partition", bldrQuery, mapEntity, mapChildrenQuery, new String[0]);
                mapArguments = Collections.singletonMap("serviceName", sServiceName);
                this.addChildResourceQueryResult(new ServiceMembersResource(this), "members", mapEntity, mapChildrenQuery, mapArguments, uriSelf);
                this.addChildResourceQueryResult(new CachesResource(this), "caches", mapEntity, mapChildrenQuery, mapArguments, uriSelf);
                this.addChildResourceQueryResult(new PersistenceResource(this), "persistence", mapEntity, mapChildrenQuery, mapArguments, uriSelf);
            }
        }
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sServiceName) {
        return this.createQueryBuilder().withBaseQuery(":type=Service,name=" + sServiceName);
    }

    protected MBeanAccessor.QueryBuilder getPartitionAssignmentQuery(String sServiceName) {
        return this.createQueryBuilder().withBaseQuery(":type=PartitionAssignment").withService(sServiceName);
    }
}

