/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.CWebResource;
import com.tangosol.coherence.management.internal.resources.CachesResource;
import com.tangosol.coherence.management.internal.resources.ClusterMembersResource;
import com.tangosol.coherence.management.internal.resources.JournalResource;
import com.tangosol.coherence.management.internal.resources.ReportersResource;
import com.tangosol.coherence.management.internal.resources.ServicesResource;
import com.tangosol.coherence.management.internal.resources.StorageManagersResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ClusterResource
extends AbstractManagementResource {
    public static final String DUMP_CLUSTER_HEAP = "dumpClusterHeap";
    public static final String CONFIGURE_TRACING = "configureTracing";
    public static final String GET_CLUSTER_CONFIG = "getClusterConfig";
    public static final String ROLE = "role";
    public static final String TRACING_RATIO = "tracingRatio";
    public static final String[] CHILD_LINKS = new String[]{"services", "caches", "members", "management", "journal", "reporters", "webApplications", "storage"};

    public ClusterResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json", "application/swagger+json"})
    @Path(value="metadata-catalog")
    public Response getMetadataCatalog() {
        URL url = Resources.findFileOrResource((String)"management-swagger.json", (ClassLoader)this.getClass().getClassLoader());
        try {
            return url == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)url.openStream()).build();
        }
        catch (IOException e) {
            CacheFactory.log((String)("Exception occurred while returning Swagger resource management-swagger.json." + e.getMessage() + "\n" + CacheFactory.getStackTrace((Throwable)e)), (int)1);
            throw new WebApplicationException();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        return this.response(this.getResponseEntityForMbean(this.getQuery(), CHILD_LINKS));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="management")
    public Response getManagement() {
        return this.response(this.getResponseEntityForMbean(this.getManagementQuery(), new String[0]));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="journal")
    public Response getJournalResponse() {
        return this.response(this.getLinksOnlyResponseBody(this.getParentUri(), this.getCurrentUri(), "ram", "flash").toJson());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="platform/{platformMBean}")
    public Response getPlatformResponse(@PathParam(value="platformMBean") String sPlatformMBeanType, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        String sBaseQuery = (String)MAP_PLATFORM_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType);
        if (sBaseQuery == null && (sBaseQuery = (String)MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null && (sBaseQuery = (String)MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(sBaseQuery);
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(this.getParentUri(), this.getCurrentUri(), new String[0]);
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, bldrQuery, responseMap);
        return this.response(responseMap);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="getClusterConfig")
    public Response getClusterConfig() {
        return this.executeMBeanOperation(this.getQuery(), GET_CLUSTER_CONFIG, null, null);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="description")
    public Response getClusterDescription() {
        return this.response(this.getResponseFromMBeanOperation(this.getQuery(), "description", "getClusterDescription"));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="shutdown")
    public Response shutdownCluster() {
        return this.executeMBeanOperation(this.getQuery(), "shutdown", null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="logClusterState")
    public Response logClusterState(Map<String, Object> mapParameters) {
        Object oRole = mapParameters == null ? null : mapParameters.get(ROLE);
        return this.executeMBeanOperation(this.getQuery(), "logClusterState", new Object[]{oRole}, new String[]{String.class.getName()});
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="dumpClusterHeap")
    public Response dumpClusterHeap(Map<String, Object> mapParameters) {
        Object oRole = mapParameters == null ? null : mapParameters.get(ROLE);
        return this.executeMBeanOperation(this.getQuery(), DUMP_CLUSTER_HEAP, new Object[]{oRole}, new String[]{String.class.getName()});
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="configureTracing")
    public Response configureTracing(Map<String, Object> mapParameters) {
        Object oRole = mapParameters == null ? null : mapParameters.get(ROLE);
        Float oRatio = Float.valueOf(mapParameters == null ? -1.0f : Float.parseFloat(mapParameters.get(TRACING_RATIO).toString()));
        return this.executeMBeanOperation(this.getQuery(), CONFIGURE_TRACING, new Object[]{oRole, oRatio}, new String[]{String.class.getName(), Float.class.getName()});
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="management")
    public Response updateJMXManagement(Map<String, Object> mapParameters) {
        return this.update(mapParameters, this.getManagementQuery());
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="search")
    public Response search(Map<String, Object> mapQuery) {
        return this.response(this.getSearchResults(mapQuery, this.getParentUri(), this.getCurrentUri()));
    }

    @Path(value="members")
    public Object getMembersResource() {
        return new ClusterMembersResource(this);
    }

    @Path(value="services")
    public Object getServicesResource() {
        return new ServicesResource(this);
    }

    @Path(value="caches")
    public Object getCachesResource() {
        return new CachesResource(this);
    }

    @Path(value="journal/{journalType:ram|flash}")
    public Object getJournalResource() {
        return new JournalResource(this);
    }

    @Path(value="webApplications")
    public Object getWebAppsResource() {
        return new CWebResource(this);
    }

    @Path(value="reporters")
    public Object getReportersResource() {
        return new ReportersResource(this);
    }

    @Path(value="storage")
    public Object getStorageManagersResource() {
        return new StorageManagersResource(this);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="diagnostic-cmd/{jfrCmd}")
    public Response diagnosticCmd(@PathParam(value="jfrCmd") String sCmd, @QueryParam(value="options") String sOptions, @QueryParam(value="role") String sRole) {
        return this.response(this.getResponseFromMBeanOperation(this.getQuery(), "status", "flightRecording", new Object[]{sRole, sCmd, sOptions}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()}));
    }

    public Map<String, Object> getClusterResponseMap(URI uriParent, String sClusterName) {
        EntityMBeanResponse response = this.getResponseEntityForMbean(this.getQuery(), uriParent, ClusterResource.getSubUri(uriParent, sClusterName), null, CHILD_LINKS);
        return response != null ? response.toJson() : new LinkedHashMap<String, Object>();
    }

    public Map<String, Object> getSearchResults(Map<String, Object> mapQuery, URI uriParent, URI uriCurrent) {
        LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
        EntityMBeanResponse response = this.getResponseEntityForMbean(this.getQuery(), uriParent, uriCurrent, mapQuery, new String[0]);
        mapResponse.putAll(response.toJson());
        Object oChildren = this.getChildrenQuery(mapQuery);
        if (oChildren instanceof Map) {
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildMbeanQueryResult("management", this.getManagementQuery(), mapResponse, mapChildrenQuery, new String[0]);
            this.addChildResourceQueryResult(new ServicesResource(this), "services", mapResponse, mapChildrenQuery, null, uriCurrent);
            this.addChildResourceQueryResult(new ClusterMembersResource(this), "members", mapResponse, mapChildrenQuery, null, uriCurrent);
            this.addChildResourceQueryResult(new ReportersResource(this), "reporters", mapResponse, mapChildrenQuery, null, uriCurrent);
            this.addChildResourceQueryResult(new CWebResource(this), "webApplications", mapResponse, mapChildrenQuery, null, uriCurrent);
            Object oJournal = mapChildrenQuery.get("journal");
            if (oJournal instanceof Map) {
                LinkedHashMap<String, Object> mapJournal = new LinkedHashMap<String, Object>();
                Object oJournalChildren = this.getChildrenQuery((Map)oJournal);
                if (oJournalChildren instanceof Map) {
                    Map mapJournalQuery = (Map)oJournalChildren;
                    this.addChildResourceQueryResult(new JournalResource(this), "ram", mapJournal, mapJournalQuery, Collections.singletonMap("journalType", "ram"), uriCurrent);
                    this.addChildResourceQueryResult(new JournalResource(this), "flash", mapJournal, mapJournalQuery, Collections.singletonMap("journalType", "flash"), uriCurrent);
                    mapResponse.put("journal", mapJournal);
                }
            }
        }
        return mapResponse;
    }

    protected MBeanAccessor.QueryBuilder getQuery() {
        return this.createQueryBuilder().withBaseQuery(":type=Cluster");
    }

    protected MBeanAccessor.QueryBuilder getManagementQuery() {
        return this.createQueryBuilder().withBaseQuery(":type=Management");
    }
}

