/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.convert;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.Wrapper;
import com.oracle.coherence.io.json.genson.convert.ChainedFactory;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public class RuntimeTypeConverter<T>
extends Wrapper<Converter<T>>
implements Converter<T> {
    private static final String CYCLE_KEY = "cycle-detection";
    private final Class<T> tClass;

    public RuntimeTypeConverter(Class<T> tClass, Converter<T> next) {
        super(next);
        this.tClass = tClass.isPrimitive() ? TypeUtil.wrap(tClass) : tClass;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
        if (obj != null && !this.tClass.equals(obj.getClass()) && !this.isContainer(obj)) {
            this.ensureNoCircularRefs(obj, ctx);
            ctx.genson.serialize(obj, obj.getClass(), writer, ctx);
            this.clearCircularCheckRefs(obj, ctx);
        } else {
            ((Converter)this.wrapped).serialize(obj, writer, ctx);
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws Exception {
        return ((Converter)this.wrapped).deserialize(reader, ctx);
    }

    private boolean isContainer(T obj) {
        return obj.getClass().isArray() || obj instanceof Collection || obj instanceof Map;
    }

    private boolean isSimpleType(T obj) {
        return obj instanceof Boolean || obj instanceof Number || obj instanceof String;
    }

    private void ensureNoCircularRefs(T obj, Context ctx) {
        if (!this.isSimpleType(obj)) {
            IdentityHashMap<T, Boolean> seen = ctx.get(CYCLE_KEY, Map.class);
            if (seen == null) {
                seen = new IdentityHashMap<T, Boolean>();
                ctx.store(CYCLE_KEY, seen);
            }
            if (seen.put(obj, Boolean.TRUE) != null) {
                throw new JsonBindingException("Cyclic object graphs are not supported.");
            }
        }
    }

    private void clearCircularCheckRefs(T obj, Context ctx) {
        Map seen = ctx.get(CYCLE_KEY, Map.class);
        if (seen != null) {
            seen.remove(obj);
        }
    }

    public static class RuntimeTypeConverterFactory
    extends ChainedFactory {
        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            if (nextConverter == null) {
                throw new IllegalArgumentException("RuntimeTypeConverter can not be last Converter in the chain.");
            }
            return new RuntimeTypeConverter(TypeUtil.getRawClass(type), nextConverter);
        }
    }
}

