/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    protected final Class<T> f_clzEnum;
    protected final Map<String, T> f_mapDeserializationNames;

    protected EnumConverter(Class<T> enumClass) {
        this.f_clzEnum = enumClass;
        this.f_mapDeserializationNames = new HashMap<String, T>();
        Arrays.stream(enumClass.getFields()).filter(Field::isEnumConstant).forEach(this::acceptField);
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) {
        writer.beginObject().writeString("enum", ((Enum)obj).name()).endObject();
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) {
        String name = null;
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            if (!"enum".equals(reader.name())) continue;
            name = reader.valueAsString();
        }
        reader.endObject();
        Enum value = (Enum)this.f_mapDeserializationNames.get(name);
        if (value == null) {
            throw new JsonBindingException("No enum constant " + this.f_clzEnum.getCanonicalName() + "." + name);
        }
        return (T)value;
    }

    private void acceptField(Field f) {
        try {
            this.f_mapDeserializationNames.put(f.getName(), (Enum)f.get(null));
        }
        catch (IllegalAccessException e) {
            throw new JsonBindingException("Failed to get enum value " + f.getName(), e);
        }
    }

    public static class Factory
    implements com.oracle.coherence.io.json.genson.Factory<Converter<? extends Enum<?>>> {
        public static final Factory INSTANCE = new Factory();

        protected Factory() {
        }

        @Override
        public Converter<Enum<?>> create(Type type, Genson genson) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            return rawClass.isEnum() || Enum.class.isAssignableFrom(rawClass) ? new EnumConverter(rawClass) : null;
        }
    }
}

