/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.annotation.HandleBeanView;
import com.oracle.coherence.io.json.genson.annotation.HandleClassMetadata;
import com.oracle.coherence.io.json.genson.datetime.DateTimeConverterOptions;
import com.oracle.coherence.io.json.genson.datetime.DateTimeUtil;
import com.oracle.coherence.io.json.genson.datetime.TimestampFormat;
import com.oracle.coherence.io.json.genson.datetime.TimestampHandler;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;

@HandleClassMetadata
@HandleBeanView
abstract class BaseTemporalAccessorConverter<T extends TemporalAccessor>
implements Converter<T> {
    private DateTimeConverterOptions options;
    private TimestampHandler<T> timestampHandler;
    private TemporalQuery<T> query;

    BaseTemporalAccessorConverter(DateTimeConverterOptions options, TimestampHandler<T> timestampHandler, TemporalQuery<T> query) {
        this.options = options;
        this.timestampHandler = timestampHandler;
        this.query = query;
    }

    @Override
    public void serialize(T object, ObjectWriter writer, Context ctx) {
        if (this.options.isAsTimestamp()) {
            TimestampFormat timestampFormat = this.options.getTimestampFormat();
            switch (timestampFormat) {
                case MILLIS: 
                case NANOS: {
                    this.timestampHandler.writeNumericTimestamp(object, writer, timestampFormat);
                    break;
                }
                case OBJECT: {
                    this.timestampHandler.writeObjectTimestamp(object, writer);
                    break;
                }
                case ARRAY: {
                    this.timestampHandler.writeArrayTimestamp(object, writer);
                    break;
                }
            }
        } else {
            writer.writeValue(this.options.getDateTimeFormatter().format((TemporalAccessor)object));
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) {
        TemporalAccessor obj = null;
        if (this.options.isAsTimestamp()) {
            TimestampFormat timestampFormat = this.options.getTimestampFormat();
            switch (timestampFormat) {
                case MILLIS: 
                case NANOS: {
                    obj = this.timestampHandler.readNumericTimestamp(reader, this.options.getTimestampFormat());
                    break;
                }
                case OBJECT: {
                    obj = this.timestampHandler.readObjectTimestamp(reader);
                    break;
                }
                case ARRAY: {
                    obj = this.timestampHandler.readArrayTimestamp(reader);
                    break;
                }
            }
        } else {
            obj = (TemporalAccessor)this.options.getDateTimeFormatter().parse((CharSequence)reader.valueAsString(), this.query);
            if (obj instanceof OffsetDateTime) {
                obj = DateTimeUtil.correctOffset((OffsetDateTime)obj, this.options.getZoneId());
            }
        }
        return (T)obj;
    }
}

