/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import com.oracle.coherence.io.json.genson.datetime.BaseTemporalAccessorConverter;
import com.oracle.coherence.io.json.genson.datetime.DateTimeConverterOptions;
import com.oracle.coherence.io.json.genson.datetime.DateTimeUtil;
import com.oracle.coherence.io.json.genson.datetime.TimestampHandler;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.LinkedHashMap;

class InstantConverter
extends BaseTemporalAccessorConverter<Instant> {
    InstantConverter(DateTimeConverterOptions options) {
        super(options, new InstantTimestampHandler(options), Instant::from);
    }

    private static class InstantTimestampHandler
    extends TimestampHandler<Instant> {
        private static final LinkedHashMap<String, TemporalField> INSTANT_TEMPORAL_FIELDS = new LinkedHashMap();

        private InstantTimestampHandler(DateTimeConverterOptions options) {
            super(DateTimeUtil::instantToMillis, DateTimeUtil::instantFromMillis, DateTimeUtil::instantToNanos, DateTimeUtil::instantFromNanos, INSTANT_TEMPORAL_FIELDS, Instant::now);
        }

        static {
            INSTANT_TEMPORAL_FIELDS.put("second", ChronoField.INSTANT_SECONDS);
            INSTANT_TEMPORAL_FIELDS.put("nano", ChronoField.NANO_OF_SECOND);
        }
    }
}

