/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

abstract class GensonJsonNumber
implements JsonNumber {
    GensonJsonNumber() {
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    static class DoubleJsonNumber
    extends GensonJsonNumber {
        private final double value;
        private BigDecimal exactValue;

        protected DoubleJsonNumber(double value) {
            this.value = value;
        }

        protected DoubleJsonNumber(BigDecimal value) {
            this.exactValue = value;
            this.value = this.exactValue.doubleValue();
        }

        public boolean isIntegral() {
            return false;
        }

        public int intValue() {
            return (int)this.value;
        }

        public int intValueExact() {
            return (int)this.value;
        }

        public long longValue() {
            return (long)this.value;
        }

        public long longValueExact() {
            return (long)this.value;
        }

        public BigInteger bigIntegerValue() {
            return this.bigDecimalValue().toBigInteger();
        }

        public BigInteger bigIntegerValueExact() {
            return this.bigDecimalValue().toBigIntegerExact();
        }

        public double doubleValue() {
            return this.value;
        }

        public BigDecimal bigDecimalValue() {
            if (this.exactValue == null) {
                this.exactValue = BigDecimal.valueOf(this.value);
            }
            return this.exactValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleJsonNumber that = (DoubleJsonNumber)o;
            return this.bigDecimalValue().equals(that.bigDecimalValue());
        }

        public int hashCode() {
            return this.bigDecimalValue().hashCode();
        }

        public String toString() {
            return Double.toString(this.value);
        }
    }

    static class IntJsonNumber
    extends GensonJsonNumber {
        private final long value;
        private BigInteger exactValue;

        protected IntJsonNumber(long value) {
            this.value = value;
        }

        IntJsonNumber(BigInteger exactValue) {
            this.exactValue = exactValue;
            this.value = exactValue.longValue();
        }

        public boolean isIntegral() {
            return true;
        }

        public int intValue() {
            return (int)this.value;
        }

        public int intValueExact() {
            return (int)this.value;
        }

        public long longValue() {
            return this.value;
        }

        public long longValueExact() {
            return this.value;
        }

        public BigInteger bigIntegerValue() {
            return BigInteger.valueOf(this.value);
        }

        public BigInteger bigIntegerValueExact() {
            return BigInteger.valueOf(this.value);
        }

        public double doubleValue() {
            return this.value;
        }

        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntJsonNumber that = (IntJsonNumber)o;
            return this.bigIntegerValue().equals(that.bigIntegerValue());
        }

        public int hashCode() {
            return this.bigIntegerValue().hashCode();
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }
}

